/*
 * This file is part of the API Extractor project.
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef FILEOUT_H
#define FILEOUT_H

#include <QtCore/QObject>
#include <QtCore/QFile>
#include <QtCore/QTextStream>
#include "apiextractormacros.h"

class APIEXTRACTOR_API FileOut : public QObject
{
private:
    QByteArray tmp;
    QString name;

public:
    FileOut(QString name);
    ~FileOut()
    {
        if (!isDone)
            done();
    }

    bool done();

    QTextStream stream;

    static bool dummy;
    static bool diff;

private:
    bool isDone;
};

#endif // FILEOUT_H
