/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.func.Functions;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.StaticFunc;
import org.basex.query.scope.ContextScope;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.util.parse.FuncBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.StaticVar;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;
import org.basex.util.options.StringsOption;
import org.basex.util.options.ValueOption;

public final class FnLoadXQueryModule
extends StandardFunc {
    public static final MapType QNAME_MAP_TYPE = MapType.get(AtomType.QNAME, SeqType.ITEM_ZM);

    @Override
    public XQMap item(QueryContext qc, InputInfo ii) throws QueryException {
        String string;
        byte[] modUri = this.toToken(this.arg(0).atomItem(qc, this.info));
        if (modUri.length == 0) {
            throw QueryError.MODULE_URI_EMPTY.get(this.info, new Object[0]);
        }
        LoadXQueryModuleOptions opt = this.toOptions(this.arg(1), new LoadXQueryModuleOptions(), qc);
        ArrayList<IO> srcs = new ArrayList<IO>();
        String cont = opt.get(LoadXQueryModuleOptions.CONTENT);
        if (cont != null) {
            srcs.add(new IOContent(cont));
        } else {
            String[] locs;
            if (opt.contains(LoadXQueryModuleOptions.LOCATION_HINTS)) {
                locs = opt.get(LoadXQueryModuleOptions.LOCATION_HINTS);
            } else {
                byte[] byArray = qc.modDeclared.get(modUri);
                if (byArray != null) {
                    locs = new String[]{Token.string(byArray)};
                } else {
                    String[] stringArray;
                    String path = FnLoadXQueryModule.repoFilePath(modUri, qc.context);
                    if (path == null) {
                        stringArray = new String[]{};
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = path;
                    }
                    locs = stringArray;
                }
            }
            if (locs.length == 0) {
                throw QueryError.MODULE_NOT_FOUND_X.get(this.info, new Object[]{modUri});
            }
            for (String string2 : locs) {
                srcs.add(ii.sc().resolve(string2, ii.path()));
            }
        }
        QNmMap<Value> bindings = new QNmMap<Value>();
        if (opt.contains(LoadXQueryModuleOptions.VARIABLES)) {
            XQMap xQMap = ((XQMap)opt.get(LoadXQueryModuleOptions.VARIABLES)).coerceTo(QNAME_MAP_TYPE, qc, null, ii);
            xQMap.forEach((key, value) -> bindings.put((QNm)key, (Value)value));
        }
        if (opt.contains(LoadXQueryModuleOptions.VENDOR_OPTIONS)) {
            ((XQMap)opt.get(LoadXQueryModuleOptions.VENDOR_OPTIONS)).coerceTo(QNAME_MAP_TYPE, qc, null, ii);
        }
        if (opt.contains(LoadXQueryModuleOptions.XQUERY_VERSION) && !QueryContext.isSupported(string = opt.get(LoadXQueryModuleOptions.XQUERY_VERSION).toString())) {
            throw QueryError.MODULE_XQUERY_VERSION_X.get(this.info, string);
        }
        QueryContext queryContext = new QueryContext(qc);
        for (byte[] uri : qc.modDeclared) {
            queryContext.modDeclared.put(uri, qc.modDeclared.get(uri));
        }
        int nParsed = 0;
        for (IO iO : srcs) {
            queryContext.finalContext = false;
            try {
                String path = iO.path();
                String content = iO.readString();
                queryContext.parse(content, path.isEmpty() ? Token.string(this.sc().baseURI().string()) : path);
            }
            catch (IOException ex) {
                Util.debug(ex);
                throw QueryError.WHICHMODFILE_X.get(this.info, iO);
            }
            catch (QueryException ex) {
                Util.debug(ex);
                throw QueryError.MODULE_STATIC_ERROR_X_X.get(this.info, modUri, ex.getLocalizedMessage());
            }
            try {
                queryContext.vars.bindExternal(queryContext, bindings, false);
            }
            catch (QueryException ex) {
                Util.debug(ex);
                throw ex.error() != QueryError.INVCONVERT_X_X_X ? ex : QueryError.MODULE_PARAMETER_TYPE_X_X.get(this.info, modUri, ex.getLocalizedMessage());
            }
            if (!queryContext.finalContext && opt.contains(LoadXQueryModuleOptions.CONTEXT_ITEM)) {
                Value val = opt.get(LoadXQueryModuleOptions.CONTEXT_ITEM);
                try {
                    if (queryContext.contextType != null) {
                        val = queryContext.contextType.coerce(val, null, queryContext, null, this.info);
                    }
                }
                catch (QueryException ex) {
                    Util.debug(ex);
                    throw ex.error() != QueryError.INVCONVERT_X_X_X ? ex : QueryError.MODULE_CONTEXT_TYPE_X_X.get(this.info, modUri, ex.getLocalizedMessage());
                }
                queryContext.contextValue = new ContextScope(val, queryContext.contextType, new VarScope(), this.sc(), null, null);
                queryContext.finalContext = true;
            }
            queryContext.compile(true);
            if (queryContext.main != null) {
                throw QueryError.MODULE_FOUND_MAIN_X.get(this.info, new Object[]{modUri});
            }
            Iterator<byte[]> it = queryContext.modParsed.values().iterator();
            for (int i = 0; i < nParsed; ++i) {
                it.next();
            }
            byte[] uri = it.next();
            if (!Token.eq(modUri, uri)) {
                String path = iO.path();
                throw path.isEmpty() ? QueryError.MODULE_FOUND_OTHER_X.get(this.info, new Object[]{modUri}) : QueryError.MODULE_FOUND_OTHER_X_X.get(this.info, modUri, path);
            }
            nParsed = queryContext.modParsed.size();
        }
        QNmMap<Map> funcs = new QNmMap<Map>();
        for (StaticFunc sf : queryContext.functions.funcs()) {
            if (sf.updating()) {
                queryContext.updating();
            }
            if (sf.anns.contains(Annotation.PRIVATE) || !Token.eq(sf.sc.module.uri(), modUri)) continue;
            for (int a = sf.minArity(); a <= sf.arity(); ++a) {
                FuncBuilder fb = new FuncBuilder(this.info, a, true);
                Expr item = Functions.item(sf, fb, queryContext, true);
                funcs.computeIfAbsent(sf.name, HashMap::new).put(a, item);
            }
        }
        MapBuilder mapBuilder = new MapBuilder();
        for (QNm qnm : funcs) {
            MapBuilder arities = new MapBuilder();
            Map funcItems = (Map)funcs.get(qnm);
            for (Map.Entry entry : funcItems.entrySet()) {
                arities.put((Item)Itr.get(((Integer)entry.getKey()).intValue()), ((Expr)entry.getValue()).value(queryContext));
            }
            mapBuilder.put((Item)qnm, (Value)arities.map());
        }
        MapBuilder variables = new MapBuilder();
        for (StaticVar var : queryContext.vars) {
            if (var.anns.contains(Annotation.PRIVATE) || !Token.eq(var.sc.module.uri(), modUri)) continue;
            try {
                variables.put((Item)var.name, var.value(queryContext));
            }
            catch (QueryException ex) {
                throw ex;
            }
            catch (Exception ex) {
                Util.debug(ex);
                throw QueryError.VAREMPTY_X.get(this.info, var.name());
            }
        }
        MapBuilder result = new MapBuilder();
        result.put("functions", (Value)mapBuilder.map());
        result.put("variables", (Value)variables.map());
        return result.map();
    }

    private static String repoFilePath(byte[] modUri, Context context) {
        String path = Strings.uri2path(Token.string(modUri));
        String repoPath = context.soptions.get(StaticOptions.REPOPATH);
        for (String suffix : IO.XQSUFFIXES) {
            IOFile file = new IOFile(repoPath, path + suffix);
            if (!file.exists()) continue;
            return file.path();
        }
        return null;
    }

    public static final class LoadXQueryModuleOptions
    extends Options {
        public static final ValueOption XQUERY_VERSION = new ValueOption("xquery-version", SeqType.DECIMAL_O, null);
        public static final StringsOption LOCATION_HINTS = new StringsOption("location-hints", null);
        public static final StringOption CONTENT = new StringOption("content");
        public static final ValueOption CONTEXT_ITEM = new ValueOption("context-item", SeqType.ITEM_ZO, null);
        public static final ValueOption VARIABLES = new ValueOption("variables", SeqType.MAP_O, null);
        public static final ValueOption VENDOR_OPTIONS = new ValueOption("vendor-options", SeqType.MAP_O, null);
    }
}

