/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQHashMap;
import org.basex.query.value.map.XQItemValueMap;
import org.basex.query.value.map.XQStrValueMap;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.util.hash.TokenIntMap;
import org.basex.util.list.IntList;

public final class XQStrIntMap
extends XQHashMap {
    private static final MapType TYPE = MapType.get(AtomType.STRING, SeqType.INTEGER_O);
    private final TokenIntMap map;

    XQStrIntMap(int capacity) {
        super(TYPE);
        this.map = new TokenIntMap(capacity);
    }

    @Override
    public long structSize() {
        return this.map.size();
    }

    @Override
    public Value getOrNull(Item key) throws QueryException {
        int i;
        if (key.type.isStringOrUntyped() && (i = this.map.index(key.string(null))) != 0) {
            return this.valueAt(i - 1);
        }
        return null;
    }

    @Override
    public Value keys() {
        return StrSeq.get(this.map.keys());
    }

    @Override
    public Value items(QueryContext qc) {
        long is = this.structSize();
        IntList list = new IntList(is);
        int i = 1;
        while ((long)i <= is) {
            list.add(this.map.value(i));
            ++i;
        }
        return IntSeq.get(list.finish());
    }

    @Override
    public Str keyAt(int index) {
        return Str.get(this.map.key(index + 1));
    }

    @Override
    public Itr valueAt(int index) {
        return Itr.get(this.map.value(index + 1));
    }

    @Override
    XQHashMap build(Item key, Value value) throws QueryException {
        byte[] k = XQStrIntMap.toStr(key);
        int v = XQStrIntMap.toInt(value);
        if (k != null) {
            if (v != Integer.MIN_VALUE) {
                this.map.put(k, v);
                return this;
            }
            return new XQStrValueMap(this.map.capacity() - 2).build(this).build(key, value);
        }
        return new XQItemValueMap(this.map.capacity() - 2).build(this).build(key, value);
    }
}

