/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.HashSet;
import java.util.regex.Pattern;
import org.basex.core.StaticOptions;
import org.basex.core.users.Perm;
import org.basex.core.users.User;
import org.basex.io.IOFile;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class Databases {
    public static final String DBCHARS = "-+=~!#$%^&()[]{}@'`";
    private static final String DATE = "\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}";
    private static final String REGEXCHARS = "-+=~!#$%^&()[]{}@'`".replaceAll("(.)", "\\\\$1");
    private static final Pattern ZIPPATTERN = Pattern.compile("-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}\\.zip$");
    private static final Pattern REGEX = Pattern.compile(".*[*?,].*");
    private final StaticOptions soptions;

    Databases(StaticOptions soptions) {
        this.soptions = soptions;
    }

    public StringList all() {
        return this.list(null, null, true);
    }

    public StringList list() {
        return this.list(null, null, false);
    }

    public StringList list(User user, String pattern) {
        return this.list(user, pattern, false);
    }

    private StringList list(User user, String pattern, boolean all) {
        Pattern pt = pattern == null ? null : Databases.regex(pattern);
        StringList list = new StringList();
        HashSet<String> map = new HashSet<String>();
        for (IOFile file : this.soptions.dbPath().children()) {
            String name = file.name();
            String entry = null;
            if (all && name.endsWith(".zip")) {
                String[] split = ZIPPATTERN.split(name);
                if (split.length > 0 && !split[0].equals(name)) {
                    entry = split[0];
                }
            } else if (file.isDir() && !Strings.startsWith(name, '.')) {
                entry = name;
            }
            if (entry == null || !map.add(entry) || pt != null && !pt.matcher(entry).matches() || user != null && !user.has(Perm.READ, entry)) continue;
            list.add(entry);
        }
        return list.sort(false);
    }

    public StringList backups() {
        StringList backups = new StringList();
        for (IOFile file : this.soptions.dbPath().children()) {
            String name = file.name();
            if (!name.endsWith(".zip")) continue;
            backups.add(name.substring(0, name.lastIndexOf(46)));
        }
        return backups;
    }

    public StringList backups(String name) {
        StringList backups = new StringList();
        IOFile path = this.soptions.dbPath(name + ".zip");
        if (path.exists()) {
            backups.add(name);
        } else {
            Pattern regex = Databases.regex(name, "-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}\\.zip");
            for (IOFile file : this.soptions.dbPath().children()) {
                String n = file.name();
                if (!regex.matcher(n).matches()) continue;
                backups.add(n.substring(0, n.lastIndexOf(46)));
            }
        }
        return backups.sort(Prop.CASE, false);
    }

    public static Pattern regex(String pattern) {
        return Databases.regex(pattern, "");
    }

    public static String name(String backup) {
        String[] strings = Pattern.compile("-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}$").split(backup);
        return strings.length > 0 ? strings[0] : "";
    }

    public static String date(String backup) {
        return backup.replaceAll("^.*-(\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2})$", "$1");
    }

    public static boolean validChar(int ch, boolean firstLast) {
        return Token.letterOrDigit(ch) || DBCHARS.indexOf(ch) != -1 || !firstLast && ch == 46;
    }

    public static boolean validName(String name) {
        return Databases.valid(name, false);
    }

    public static boolean validPattern(String pattern) {
        return Databases.valid(pattern, true);
    }

    private static Pattern regex(String pattern, String suffix) {
        if (pattern == null) {
            return null;
        }
        String nm = REGEX.matcher(pattern).matches() ? IOFile.regex(pattern) : pattern.replaceAll("([" + REGEXCHARS + "])", "\\\\$1") + suffix;
        return Pattern.compile(nm, Prop.CASE ? 0 : 2);
    }

    private static boolean valid(String name, boolean glob) {
        if (name == null) {
            return false;
        }
        int nl = name.length();
        for (int n = 0; n < nl; ++n) {
            char ch = name.charAt(n);
            if (glob && (ch == '?' || ch == '*' || ch == ',') || Databases.validChar(ch, n == 0 || n + 1 == nl)) continue;
            return false;
        }
        return nl != 0;
    }
}

