/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import java.util.ArrayList;
import java.util.Arrays;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXSplit;
import org.basex.gui.view.ViewComponent;
import org.basex.gui.view.ViewPanel;

final class ViewLayout
implements ViewComponent {
    final boolean horizontal;
    final ArrayList<ViewComponent> list = new ArrayList();

    ViewLayout(boolean horizontal, ViewComponent ... components) {
        this.horizontal = horizontal;
        this.list.addAll(Arrays.asList(components));
    }

    void add(ViewComponent comp) {
        this.list.add(comp);
    }

    void set(ViewComponent comp, int i) {
        this.list.set(i, comp);
    }

    void insert(ViewComponent comp, int i) {
        this.list.add(i, comp);
    }

    ViewComponent delete(ViewPanel panel) {
        for (int c = 0; c < this.list.size(); ++c) {
            ViewComponent comp = this.list.get(c);
            if (comp instanceof ViewLayout) {
                ViewLayout vl = (ViewLayout)comp;
                if ((comp = vl.delete(panel)) == null) continue;
                this.list.set(c, comp);
                continue;
            }
            if (comp != panel) continue;
            this.list.remove(c--);
        }
        return this.list.size() == 1 ? this.list.get(0) : null;
    }

    @Override
    public boolean isVisible() {
        for (ViewComponent comp : this.list) {
            if (!comp.isVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setVisibility(boolean db) {
        for (ViewComponent comp : this.list) {
            comp.setVisibility(db);
        }
    }

    @Override
    public void addTo(BaseXBack panel) {
        if (!this.isVisible()) {
            return;
        }
        BaseXSplit split = new BaseXSplit(this.horizontal);
        for (ViewComponent comp : this.list) {
            comp.addTo(split);
        }
        panel.add(split);
    }

    @Override
    public String layoutString(boolean all) {
        StringBuilder sb = new StringBuilder(this.horizontal ? "H " : "V ");
        for (ViewComponent comp : this.list) {
            sb.append(comp.layoutString(all));
        }
        return sb.append("- ").toString();
    }

    public String toString() {
        return (this.horizontal ? "Horizontal" : "Vertical") + " Layout";
    }
}

