/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import java.util.Arrays;
import org.basex.build.csv.CsvOptions;
import org.basex.build.csv.CsvParserOptions;
import org.basex.io.parse.csv.CsvXQueryConverter;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.ChoiceItemType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class CsvW3Converter
extends CsvXQueryConverter {
    CsvW3Converter(CsvParserOptions opts) {
        super(opts);
    }

    @Override
    protected Value finish(InputInfo ii, QueryContext qc) throws QueryException {
        XQMap map = (XQMap)super.finish(ii, qc);
        Value columns = this.copts.get(CsvOptions.HEADER);
        if (columns.seqType().instanceOf(Types.BOOLEAN_O)) {
            columns = map.get(CsvXQueryConverter.NAMES).atomValue(qc, ii);
        }
        MapBuilder columnIndexBuilder = new MapBuilder();
        int i = 0;
        for (Item column : columns) {
            ++i;
            if (column.string(ii).length <= 0 || columnIndexBuilder.contains(column)) continue;
            columnIndexBuilder.put(column, (Value)Itr.get(i));
        }
        XQMap columnIndex = columnIndexBuilder.map();
        Value rows = map.get(CsvXQueryConverter.RECORDS);
        MapBuilder result = new MapBuilder();
        result.put((Item)COLUMNS, columns);
        result.put((Item)COLUMN_INDEX, (Value)columnIndex);
        result.put((Item)ROWS, rows);
        if (qc != null) {
            result.put((Item)GET, (Value)Get.funcItem(rows, columnIndex, qc, ii));
        }
        return result.map();
    }

    private static final class Get
    extends Arr {
        private final Value rows;
        private final XQMap columnIndex;

        private Get(InputInfo ii, Value rows, XQMap columnIndex, Expr ... args) {
            super(ii, Types.STRING_O, args);
            this.rows = rows;
            this.columnIndex = columnIndex;
        }

        @Override
        public Value value(QueryContext qc) throws QueryException {
            XQArray row;
            long rowIndex = this.toLong(this.arg(0), qc);
            if (rowIndex <= this.rows.size() && (row = (XQArray)this.rows.itemAt(rowIndex - 1L)) != null) {
                Value value;
                Item colIndex = this.toAtomItem(this.arg(1), qc);
                if (colIndex.type.instanceOf(AtomType.STRING)) {
                    Item it = (Item)this.columnIndex.get(colIndex);
                    if (it.isEmpty()) {
                        throw QueryError.CSV_COLUMNNAME_X.get(this.info, colIndex);
                    }
                    colIndex = it;
                }
                if ((value = row.getOrNull(colIndex, qc, this.info)) != null) {
                    return value;
                }
            }
            return Str.EMPTY;
        }

        @Override
        public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
            return this.copyType(new Get(this.info, this.rows, this.columnIndex, Get.copyAll((CompileContext)cc, vm, (Expr[])this.args())));
        }

        @Override
        public void toString(QueryString qs) {
            qs.token("csv-get").params(this.exprs);
        }

        private static FuncItem funcItem(Value rows, XQMap columnIndex, QueryContext qc, InputInfo ii) {
            VarScope vs = new VarScope();
            SeqType rowType = Types.POSITIVE_INTEGER_O;
            SeqType colType = new ChoiceItemType(Arrays.asList(Types.STRING_O, Types.POSITIVE_INTEGER_O)).seqType();
            Var row = vs.addNew(new QNm("row"), rowType, qc, ii);
            Var col = vs.addNew(new QNm("column"), colType, qc, ii);
            Get get = new Get(ii, rows, columnIndex, new VarRef(ii, row), new VarRef(ii, col));
            Var[] params = new Var[]{row, col};
            FuncType funcType = FuncType.get(Types.STRING_O, rowType, colType);
            return new FuncItem(ii, get, params, AnnList.EMPTY, funcType, params.length, null);
        }
    }
}

