/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.basex.data.Data;
import org.basex.index.path.PathIndex;
import org.basex.index.path.PathNode;
import org.basex.index.stats.Stats;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryBiFunction;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.List;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Preds;
import org.basex.query.expr.SimpleMap;
import org.basex.query.expr.Union;
import org.basex.query.expr.index.IndexAccess;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.expr.index.IndexDynDb;
import org.basex.query.expr.index.IndexStaticDb;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.expr.path.CachedPath;
import org.basex.query.expr.path.InvDocTest;
import org.basex.query.expr.path.IterPath;
import org.basex.query.expr.path.MixedPath;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.NodeTest;
import org.basex.query.expr.path.SingleIterPath;
import org.basex.query.expr.path.Step;
import org.basex.query.expr.path.Test;
import org.basex.query.func.Function;
import org.basex.query.func.fn.FnReplicate;
import org.basex.query.func.util.UtilRoot;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dummy;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public abstract class Path
extends ParseExpr {
    public Expr root;
    public Expr[] steps;

    protected Path(InputInfo info, Type type, Expr root, Expr ... steps) {
        super(info, SeqType.get(type, Occ.ZERO_OR_MORE));
        this.root = root;
        this.steps = steps;
    }

    public static Expr get(CompileContext cc, InputInfo info, Expr root, Expr ... steps) throws QueryException {
        return Path.get(info, root, steps).optimize(cc);
    }

    public static Expr get(InputInfo info, Expr input, Expr ... steps) {
        Expr step;
        boolean axes = true;
        ExprList tmp = new ExprList(steps.length);
        for (Expr step2 : steps) {
            Expr expr = step2;
            if (expr instanceof ContextValue) {
                expr = Step.get(expr.info(info), Axis.SELF, NodeTest.NODE, new Expr[0]);
            } else if (expr instanceof Filter) {
                Filter filter = (Filter)expr;
                if (filter.root instanceof ContextValue) {
                    expr = Step.get(filter.info(), Axis.SELF, NodeTest.NODE, filter.exprs);
                }
            }
            tmp.add(expr);
            axes = axes && expr instanceof Step;
        }
        Expr root = input instanceof ContextValue && input.size() == 1L || input instanceof Dummy ? null : input;
        Expr[] stps = (Expr[])tmp.finish();
        Expr expr = step = root == null && stps.length == 1 ? stps[0] : null;
        if (axes) {
            if (Path.iterative(input, stps)) {
                if (step != null && !step.has(Flag.POS)) {
                    return new SingleIterPath(info, step);
                }
                return new IterPath(info, root, stps);
            }
            return new CachedPath(info, root, stps);
        }
        if (step != null && (step.seqType().instanceOf(Types.ANY_ATOMIC_TYPE_ZM) || step.ddo())) {
            return stps[0];
        }
        return new MixedPath(info, root, stps);
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.root);
        int ss = this.steps.length;
        for (int s = 0; s < ss - 1; ++s) {
            this.checkNoUp(this.steps[s]);
        }
        this.steps[ss - 1].checkUp();
    }

    @Override
    public final Expr compile(CompileContext cc) throws QueryException {
        Expr rt;
        if (this.root != null) {
            this.root = this.root.compile(cc);
            rt = this.root;
        } else {
            rt = cc.qc.focus.value;
        }
        cc.get(rt, true, () -> {
            int sl = this.steps.length;
            for (int s = 0; s < sl; ++s) {
                Expr step;
                this.steps[s] = step = cc.compileOrError(this.steps[s], this.root == null && s == 0);
                cc.updateFocus(step, true);
            }
            return null;
        });
        return this.optimize(cc);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        Expr expr;
        if (this.root == null && !cc.nestedFocus()) {
            this.root = cc.qc.focus.value;
        }
        if ((expr = this.simplify(cc)) != this) {
            return expr;
        }
        expr = this.flatten(cc);
        if (expr == this) {
            expr = this.toUnion(cc);
        }
        if (expr == this) {
            expr = this.mergeSteps(cc);
        }
        if (expr == this) {
            expr = this.movePredicates(cc);
        }
        if (expr != this) {
            return expr.optimize(cc);
        }
        Expr rt = this.root != null ? this.root : cc.qc.focus.value;
        this.seqType(rt);
        expr = this.removeEmpty(cc, rt);
        if (expr == this) {
            expr = this.toMap(cc);
        }
        if (expr == this) {
            expr = this.index(cc, rt);
        }
        if (expr == this) {
            expr = this.children(cc, rt);
        }
        if (expr != this) {
            return expr;
        }
        return this.copyType(Path.get(this.info, this.root == null && rt instanceof Dummy ? rt : this.root, this.steps));
    }

    @Override
    public final Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr last;
        Expr expr = this;
        if (mode.oneOf(CompileContext.Simplify.EBV, CompileContext.Simplify.PREDICATE) && (last = this.steps[this.steps.length - 1]) instanceof Step) {
            Expr ex;
            Step step = (Step)last;
            if (step.exprs.length == 1 && step.seqType().type instanceof NodeType && !step.exprs[0].seqType().mayBeNumber() && (ex = step.flattenEbv(this, true, cc)) != step) {
                expr = ex;
            }
        }
        return cc.simplify(this, expr, mode);
    }

    public final Expr removePredicate(CompileContext cc) throws QueryException {
        ExprList list = (ExprList)new ExprList(this.steps.length).add(this.steps);
        Step step = ((Step)list.pop()).removePredicate();
        list.add(cc.get(this.root, true, () -> step.optimize(cc)));
        return this.copyType(Path.get(cc, this.info, this.root, (Expr[])list.finish()));
    }

    @Override
    public final boolean has(Flag ... flags) {
        if (Flag.FCS.oneOf(flags) || Flag.CTX.oneOf(flags) && (this.root == null || this.root.has(Flag.CTX)) || Flag.POS.oneOf(flags) && this.root != null && this.root.has(Flag.POS)) {
            return true;
        }
        Flag[] flgs = Flag.remove(flags, Flag.POS, Flag.CTX);
        if (flgs.length == 0) {
            return false;
        }
        for (Expr step : this.steps) {
            if (!step.has(flgs)) continue;
            return true;
        }
        return this.root != null && this.root.has(flgs);
    }

    private Step axisStep(int index) {
        Step step;
        Expr expr = this.steps[index];
        return expr instanceof Step ? (step = (Step)expr) : null;
    }

    public boolean simple() {
        for (Expr step : this.steps) {
            if (step instanceof Step) {
                Step stp = (Step)step;
                if (stp.axis.oneOf(Axis.SELF, Axis.CHILD, Axis.ATTRIBUTE)) continue;
            }
            return false;
        }
        return true;
    }

    private Expr flatten(CompileContext cc) {
        boolean changed = false;
        ExprList tmp = new ExprList(this.steps.length);
        Expr rt = this.root;
        if (rt instanceof Path) {
            Path path = (Path)rt;
            tmp.add(path.steps);
            rt = path.root;
            Object[] objectArray = new Object[2];
            objectArray[0] = path::description;
            objectArray[1] = path;
            cc.info("flatten nested %: %", objectArray);
            changed = true;
        }
        for (Expr step : this.steps) {
            Expr expr = step;
            if (expr instanceof Path) {
                Path path = (Path)expr;
                if (path.root != null && !(path.root instanceof ContextValue)) {
                    tmp.add(path.root);
                }
                int pl = path.steps.length - 1;
                for (int i = 0; i < pl; ++i) {
                    tmp.add(path.steps[i]);
                }
                expr = path.steps[pl];
                Object[] objectArray = new Object[2];
                objectArray[0] = path::description;
                objectArray[1] = path;
                cc.info("flatten nested %: %", objectArray);
                changed = true;
            }
            tmp.add(expr);
        }
        return changed ? Path.get(this.info, rt, (Expr[])tmp.finish()) : this;
    }

    private Expr simplify(CompileContext cc) throws QueryException {
        if (this.root != null && this.root.seqType().zero()) {
            return cc.emptySeq(this);
        }
        int sl = this.steps.length;
        boolean removed = false;
        ExprList list = new ExprList(sl);
        for (int s = 0; s < sl; ++s) {
            Expr expr;
            Expr prev;
            Expr step = this.steps[s];
            Expr expr2 = list.isEmpty() ? (this.root != null ? this.root : cc.qc.focus.value) : (prev = (Expr)list.peek());
            if (prev != null) {
                Step stp;
                SeqType seqType = prev.seqType();
                if (seqType.type instanceof NodeType && (step instanceof ContextValue || step instanceof Step && (stp = (Step)step).remove(seqType))) {
                    removed = true;
                    continue;
                }
            }
            if ((expr = this.steps[s]) == Empty.VALUE) {
                return cc.emptySeq(this);
            }
            list.add(expr);
            if (!expr.seqType().zero() || s + 1 >= sl) continue;
            cc.info("simplify %: %", this::description, this);
            break;
        }
        if (removed && (list.isEmpty() || !(((Expr)list.get((int)0)).seqType().type instanceof NodeType))) {
            if (this.root == null) {
                this.root = ContextValue.get(cc, this.info);
            }
            if (!this.root.ddo()) {
                this.root = cc.replaceWith(this.root, cc.function(Function.DISTINCT_ORDERED_NODES, this.info, this.root));
            }
        }
        this.steps = (Expr[])list.finish();
        return cc.replaceWith(this, this.steps.length == 0 ? this.root : this);
    }

    private ArrayList<PathNode> pathNodes(Expr rt, boolean stats) {
        Data data = this.data();
        return rt != null && rt.seqType().type.instanceOf(NodeType.DOCUMENT_NODE) && data != null && data.meta.uptodate ? this.pathNodes(data.paths.root(), stats) : null;
    }

    final ArrayList<PathNode> pathNodes(ArrayList<PathNode> nodes, boolean stats) {
        ArrayList<PathNode> pn = nodes;
        for (Expr expr : this.steps) {
            if (expr instanceof UtilRoot) {
                pn = UtilRoot.nodes(pn);
            } else if (expr instanceof Step) {
                Step step = (Step)expr;
                pn = step.nodes(pn, stats);
                if (!stats && pn != null) {
                    for (Expr ex : step.exprs) {
                        ArrayList<PathNode> tmp;
                        if (!(ex instanceof AxisPath)) continue;
                        AxisPath path = (AxisPath)ex;
                        if (path.root != null || (tmp = path.pathNodes(pn, false)) == null || !tmp.isEmpty()) continue;
                        return tmp;
                    }
                }
            } else {
                pn = null;
            }
            if (pn == null) break;
        }
        return pn;
    }

    public ArrayList<Stats> pathStats() {
        ArrayList<PathNode> nodes = this.pathNodes(this.root, true);
        if (nodes == null) {
            return null;
        }
        ArrayList<Stats> stats = new ArrayList<Stats>();
        for (PathNode node : nodes) {
            byte kind;
            if (node.kind == 1) {
                if (!node.stats.isLeaf()) {
                    return null;
                }
                for (PathNode nd : node.children) {
                    if (nd.kind != 2) continue;
                    node = nd;
                }
            }
            if ((kind = node.kind) != 2 && kind != 3) {
                return null;
            }
            stats.add(node.stats);
        }
        return stats;
    }

    private boolean emptySteps(Expr rt) {
        if (rt != null) {
            Expr prev = rt;
            for (Expr step : this.steps) {
                Step stp;
                SeqType seqType = prev.seqType();
                if (seqType.type instanceof NodeType && step instanceof Step && (stp = (Step)step).empty(seqType)) {
                    return true;
                }
                prev = step;
            }
        }
        return false;
    }

    private static boolean iterative(Expr root, Expr ... steps) {
        if (root == null || !root.ddo()) {
            return false;
        }
        SeqType st = root.seqType();
        boolean atMostOne = st.zeroOrOne();
        boolean sameDepth = atMostOne || st.type.instanceOf(NodeType.DOCUMENT_NODE);
        for (Expr expr : steps) {
            Step step = (Step)expr;
            switch (step.axis) {
                case ATTRIBUTE: 
                case SELF: {
                    break;
                }
                case PARENT: 
                case FOLLOWING_SIBLING: 
                case FOLLOWING_SIBLING_OR_SELF: {
                    if (atMostOne) break;
                    return false;
                }
                case CHILD: {
                    if (sameDepth) break;
                    return false;
                }
                case DESCENDANT: 
                case DESCENDANT_OR_SELF: {
                    if (!sameDepth) {
                        return false;
                    }
                    sameDepth = false;
                    break;
                }
                case ANCESTOR: 
                case ANCESTOR_OR_SELF: 
                case PRECEDING: 
                case PRECEDING_OR_SELF: 
                case PRECEDING_SIBLING: 
                case PRECEDING_SIBLING_OR_SELF: {
                    return false;
                }
                case FOLLOWING: 
                case FOLLOWING_OR_SELF: {
                    if (!atMostOne) {
                        return false;
                    }
                    sameDepth = false;
                    break;
                }
                default: {
                    throw Util.notExpected();
                }
            }
            atMostOne &= step.seqType().zeroOrOne();
        }
        return true;
    }

    private void seqType(Expr rt) {
        Expr last = this.steps[this.steps.length - 1];
        Data data = last.data();
        SeqType st = last.seqType();
        Occ occ = Occ.ZERO_OR_MORE;
        long size = this.size(rt, data);
        if (size == -1L && rt != null) {
            occ = rt.seqType().occ;
            size = rt.size();
            for (Expr step : this.steps) {
                occ = occ.union(step.seqType().occ);
                long sz = step.size();
                size = size != -1L && sz != -1L ? size * sz : -1L;
            }
            if (size > 1L) {
                size = -1L;
            }
        }
        this.exprType.assign(st, occ, size).data(data);
    }

    private long size(Expr rt, Data data) {
        if (this.root != null && this.root.size() == 0L) {
            return 0L;
        }
        for (Expr step : this.steps) {
            if (step.size() != 0L) continue;
            return 0L;
        }
        if (rt == null || !rt.seqType().type.instanceOf(NodeType.DOCUMENT_NODE) || data == null || !data.meta.uptodate || (long)data.meta.ndocs != rt.size()) {
            return -1L;
        }
        ArrayList<PathNode> nodes = data.paths.root();
        long lastSize = 1L;
        int sl = this.steps.length;
        for (int s = 0; s < sl; ++s) {
            Step curr = this.axisStep(s);
            if (curr != null) {
                if ((nodes = curr.nodes(nodes, true)) != null) continue;
                return -1L;
            }
            if (s + 1 == sl) {
                lastSize = this.steps[s].size();
                if (lastSize != -1L) continue;
                return -1L;
            }
            return -1L;
        }
        long size = 0L;
        for (PathNode pn : nodes) {
            size += (long)pn.stats.count;
        }
        return size * lastSize;
    }

    private ArrayList<PathNode> pathNodes(int last) {
        Data data = this.data();
        if (data == null || !data.meta.uptodate) {
            return null;
        }
        ArrayList<PathNode> nodes = data.paths.root();
        for (int s = 0; s <= last; ++s) {
            Test test;
            boolean desc;
            Step curr = this.axisStep(s);
            if (curr == null) {
                return null;
            }
            boolean bl = desc = curr.axis == Axis.DESCENDANT;
            if (!desc && curr.axis != Axis.CHILD || !((test = curr.test) instanceof NameTest)) {
                return null;
            }
            NameTest test2 = (NameTest)test;
            if (test2.local == null) {
                return null;
            }
            int name = data.elemNames.index(test2.local);
            ArrayList<PathNode> tmp = new ArrayList<PathNode>();
            for (PathNode node : PathIndex.desc(nodes, desc)) {
                if (node.kind != 1 || name != node.name) continue;
                if (!tmp.isEmpty() && ((PathNode)tmp.get(0)).level() != node.level()) {
                    return null;
                }
                tmp.add(node);
            }
            if (tmp.isEmpty()) {
                return null;
            }
            nodes = tmp;
        }
        return nodes;
    }

    private Expr removeEmpty(CompileContext cc, Expr rt) {
        ArrayList<PathNode> nodes = this.pathNodes(rt, false);
        if (nodes != null ? nodes.isEmpty() : this.emptySteps(rt)) {
            cc.info("remove path without results: %", this);
            return Empty.VALUE;
        }
        return this;
    }

    private Expr children(CompileContext cc, Expr rt) throws QueryException {
        Data data = this.data();
        if (rt == null || !rt.seqType().type.instanceOf(NodeType.DOCUMENT_NODE) || data == null || !data.meta.uptodate || data.defaultNs() == null) {
            return this;
        }
        int sl = this.steps.length;
        for (int s = 0; s < sl; ++s) {
            ArrayList<PathNode> nodes;
            Step prev;
            Step step = prev = s > 0 ? this.axisStep(s - 1) : null;
            if (prev != null && prev.exprs.length != 0) break;
            Step curr = this.axisStep(s);
            if (curr == null || curr.axis != Axis.DESCENDANT || curr.mayBePositional() || (nodes = this.pathNodes(s)) == null) continue;
            ArrayList<QNm> qNames = new ArrayList<QNm>();
            while (nodes.get((int)0).parent != null) {
                QNm qName = new QNm(data.elemNames.key(nodes.get((int)0).name));
                if (qName.hasPrefix()) {
                    return this;
                }
                for (PathNode node : nodes) {
                    if (nodes.get((int)0).name == node.name) continue;
                    qName = null;
                    break;
                }
                qNames.add(qName);
                nodes = PathIndex.parent(nodes);
            }
            cc.info("convert to child steps: %", this.steps[s]);
            int ts = qNames.size();
            Expr[] stps = new Expr[ts + sl - s - 1];
            for (int t = 0; t < ts; ++t) {
                Expr[] preds = t == ts - 1 ? ((Preds)this.steps[s]).exprs : new Expr[]{};
                QNm qName = (QNm)qNames.get(ts - t - 1);
                Test test = qName == null ? NodeTest.ELEMENT : new NameTest(qName, NameTest.Scope.LOCAL, NodeType.ELEMENT, null);
                stps[t] = Step.get(cc, this.root, curr.info(), Axis.CHILD, test, preds);
            }
            while (++s < sl) {
                stps[ts++] = this.steps[s];
            }
            return Path.get(cc, this.info, this.root, stps);
        }
        return this;
    }

    private Expr toMap(CompileContext cc) throws QueryException {
        int sl = this.steps.length;
        if (this.root == null && sl == 1) {
            return this;
        }
        Expr s1 = sl > 1 ? this.steps[sl - 2] : this.root;
        Expr s2 = this.steps[sl - 1];
        Type type1 = s1.seqType().type;
        Type type2 = s2.seqType().type;
        if (!(type1 instanceof NodeType) || s2 instanceof Step || this.size() != 1L && !type2.instanceOf(AtomType.ANY_ATOMIC_TYPE) && !type2.instanceOf(Types.FUNCTION)) {
            return this;
        }
        if (sl > 1) {
            s1 = Path.get(cc, this.info, this.root, Arrays.copyOfRange(this.steps, 0, sl - 1));
        }
        if (s1 != null) {
            s2 = SimpleMap.get(cc, this.info, s1, s2);
        }
        return cc.replaceWith(this, s2);
    }

    private Expr index(CompileContext cc, Expr rt) throws QueryException {
        int s;
        Expr indexRoot;
        Value value;
        Step step;
        if (rt == null || !rt.seqType().type.instanceOf(NodeType.DOCUMENT_NODE)) {
            return this;
        }
        IndexInfo index = null;
        int predIndex = 0;
        int stepIndex = 0;
        Data data = this.data();
        int sl = this.steps.length;
        for (int s2 = 0; s2 < sl && (step = this.axisStep(s2)) != null && step.axis.down && !step.mayBePositional(); ++s2) {
            int el = step.exprs.length;
            if (el <= 0) continue;
            IndexDb db = data != null ? new IndexStaticDb(data, this.info) : new IndexDynDb(this.root == null ? new ContextValue(this.info) : this.root, this.info);
            for (int e = 0; e < el; ++e) {
                IndexInfo ii = new IndexInfo(db, cc, step);
                if (!step.exprs[e].indexAccessible(ii)) continue;
                if (ii.costs.results() == 0) {
                    cc.info("no index results: %", step);
                    return Empty.VALUE;
                }
                if (index != null && index.costs.compareTo(ii.costs) <= 0) continue;
                index = ii;
                predIndex = e;
                stepIndex = s2;
            }
        }
        if (index == null || data != null && index.costs.tooExpensive(data)) {
            return this;
        }
        Test rootTest = null;
        if (rt instanceof Value && !((value = (Value)rt) instanceof Dummy)) {
            rootTest = InvDocTest.get(value);
        } else if (!index.enforce() || rt.has(Flag.CTX)) {
            return this;
        }
        cc.info(index.optInfo, new Object[0]);
        ExprList indexSteps = new ExprList();
        Expr e = index.expr;
        if (e instanceof Path) {
            Path path = (Path)e;
            indexRoot = path.root;
            indexSteps.add(path.steps);
        } else {
            indexRoot = index.expr;
        }
        if (index.costs.results() == 1 && indexRoot instanceof ParseExpr) {
            ParseExpr expr = (ParseExpr)indexRoot;
            expr.exprType.assign(expr instanceof IndexAccess ? Occ.EXACTLY_ONE : Occ.ZERO_OR_ONE);
        }
        Expr indexStep = indexSteps.isEmpty() ? null : (Expr)indexSteps.peek();
        ExprList invSteps = new ExprList();
        ExprList lastPreds = new ExprList();
        if (rootTest != NodeTest.DOCUMENT_NODE || data == null || !data.meta.uptodate || this.invertSteps(stepIndex)) {
            for (s = stepIndex; s >= 0; --s) {
                Expr[] newPreds;
                Test newTest;
                Axis newAxis;
                InputInfo ii;
                Axis axis = this.axisStep((int)s).axis.invert();
                if (s == 0) {
                    ii = this.info;
                    newAxis = axis;
                    if (rootTest != null) {
                        newTest = rootTest;
                        newPreds = new Expr[]{};
                    } else {
                        newTest = NodeTest.DOCUMENT_NODE;
                        newPreds = new Expr[]{new CmpG(this.info, (Expr)Function._DB_NODE_ID.get(this.info, new ContextValue(ii)), (Expr)Function._DB_NODE_ID.get(this.info, rt), CmpG.OpG.EQ)};
                    }
                } else {
                    Step step2 = this.axisStep(s - 1);
                    ii = step2.info();
                    newAxis = step2.axis == Axis.ATTRIBUTE ? Axis.ATTRIBUTE : axis;
                    newTest = step2.test;
                    newPreds = step2.exprs;
                }
                if (!(newAxis != Axis.ANCESTOR && newAxis != Axis.ANCESTOR_OR_SELF || newTest != NodeTest.NODE && newTest != NodeTest.DOCUMENT_NODE) && newPreds.length <= 0) continue;
                Expr expr = invSteps.isEmpty() ? (indexStep != null ? indexStep : indexRoot) : (Expr)invSteps.peek();
                invSteps.add(Step.get(cc, expr, ii, newAxis, newTest, newPreds));
            }
        }
        if (!invSteps.isEmpty()) {
            lastPreds.add(cc.get(indexStep != null ? indexStep : indexRoot, true, () -> Path.get(cc, this.info, null, (Expr[])invSteps.finish())));
        }
        lastPreds.add(Array.remove(index.step.exprs, predIndex));
        if (!lastPreds.isEmpty()) {
            indexSteps.add(indexStep instanceof Step ? ((Step)indexSteps.pop()).addPredicates((Expr[])lastPreds.finish()) : Step.self(cc, indexRoot, this.info, (Expr[])lastPreds.finish()));
        }
        for (s = stepIndex + 1; s < sl; ++s) {
            indexSteps.add(this.steps[s]);
        }
        return indexSteps.isEmpty() ? indexRoot : Path.get(cc, this.info, indexRoot, (Expr[])indexSteps.finish());
    }

    private boolean invertSteps(int i) {
        for (int s = i; s >= 0; --s) {
            Test test;
            Step step = this.axisStep(s);
            if (step.test instanceof NodeTest && s != i) continue;
            if (step.axis != Axis.CHILD || s != i && step.exprs.length > 0 || !((test = step.test) instanceof NameTest)) {
                return true;
            }
            NameTest test2 = (NameTest)test;
            if (test2.local == null) {
                return true;
            }
            ArrayList<PathNode> pn = this.data().paths.desc(test2.local);
            if (pn.size() == 1 && pn.get(0).level() == s + 1) continue;
            return true;
        }
        return false;
    }

    private Expr toUnion(CompileContext cc) throws QueryException {
        Expr rt;
        QueryBiFunction<Expr, Expr, Expr> rewrite = (step, next) -> {
            List lst;
            Expr st;
            Expr patt32219$temp;
            Filter fltr;
            if (step == null || next != null && next.has(Flag.CNS)) {
                return step;
            }
            if (step instanceof List) {
                List lst2 = (List)step;
                return lst2.toUnion(cc);
            }
            if (step instanceof Filter && !(fltr = (Filter)step).mayBePositional() && (patt32219$temp = fltr.root) instanceof List && (st = (lst = (List)patt32219$temp).toUnion(cc)) != fltr.root) {
                return Filter.get(cc, fltr.info(), st, fltr.exprs);
            }
            if (step.seqType().type instanceof NodeType) {
                if (Function.REPLICATE.is((Expr)step) && ((FnReplicate)step).singleEval(false)) {
                    return step.arg(0);
                }
                if (step instanceof SingletonSeq) {
                    SingletonSeq ss = (SingletonSeq)step;
                    return ss.itemAt(0L);
                }
            }
            return step;
        };
        boolean changed = false;
        if (this.steps[0].seqType().type instanceof NodeType && (rt = rewrite.apply(this.root, this.steps[0])) != this.root) {
            this.root = rt;
            changed = true;
        }
        return (changed |= cc.ok(this.root, true, () -> {
            boolean chngd = false;
            int sl = this.steps.length;
            for (int s = 0; s < sl; ++s) {
                Expr step = (Expr)rewrite.apply(this.steps[s], s + 1 < sl ? this.steps[s + 1] : null);
                if (step != this.steps[s]) {
                    this.steps[s] = step;
                    chngd = true;
                }
                cc.updateFocus(step, true);
            }
            return chngd;
        })) ? Path.get(this.info, this.root, this.steps) : this;
    }

    private Expr mergeSteps(CompileContext cc) throws QueryException {
        int sl = this.steps.length;
        ExprList stps = new ExprList(sl);
        return cc.ok(this.root, true, () -> this.lambda$mergeSteps$5(sl, cc, stps)) ? Path.get(this.info, this.root, (Expr[])stps.finish()) : this;
    }

    private Expr movePredicates(CompileContext cc) throws QueryException {
        return cc.get(this.root, true, () -> {
            int sl = this.steps.length;
            for (int s = 0; s < sl; ++s) {
                Expr ex;
                Expr curr = this.steps[s];
                if (curr instanceof Step && (ex = this.movePredicates(s)) != null) {
                    return ex;
                }
                cc.updateFocus(curr, true);
            }
            return this;
        });
    }

    private Expr movePredicates(int s) {
        Path path;
        Step step;
        block7: {
            block6: {
                step = (Step)this.steps[s];
                if (step.exprs.length != 1 || step.mayBePositional()) {
                    return null;
                }
                Expr pred = step.exprs[0];
                if (!(pred instanceof Path)) break block6;
                path = (Path)pred;
                if (path.root == null) break block7;
            }
            return null;
        }
        Expr[] predSteps = path.steps;
        int sl = this.steps.length;
        int pl = predSteps.length;
        int p = 0;
        for (int i = s + 1; i < sl && p < pl && this.steps[i].equals(predSteps[p]); ++p, ++i) {
        }
        if (p < pl) {
            return null;
        }
        Expr[] exprs = (Expr[])this.steps.clone();
        exprs[s] = step.copyType(Step.get(step.info(), step.axis, step.test, new Expr[0]));
        return Path.get(this.info, this.root, exprs);
    }

    private static Expr mergeStep(Step curr, Expr next, Expr prev, CompileContext cc) throws QueryException {
        Expr expr2;
        Filter filter;
        Step stp;
        Step nxt;
        if (curr.mayBePositional()) {
            return null;
        }
        Step step = nxt = next instanceof Step ? (stp = (Step)next) : null;
        if (nxt != null && nxt.axis == Axis.SELF && !nxt.mayBePositional()) {
            Test test = curr.test.intersect(nxt.test);
            return test == null ? null : Step.get(cc, prev, curr.info(), curr.axis, test, ExprList.concat(curr.exprs, nxt.exprs));
        }
        if (curr.axis != Axis.DESCENDANT_OR_SELF || curr.test != NodeTest.NODE || curr.exprs.length > 0) {
            return null;
        }
        Axis merged = Path.mergedAxis(nxt);
        if (merged != null) {
            return Step.get(cc, prev, nxt.info(), merged, nxt.test, nxt.exprs);
        }
        QueryFunction<Expr, Expr> rewrite = expr -> {
            Axis axis;
            if (expr instanceof Union && (axis = Path.commonAxis(expr.args())) != null) {
                for (Expr path : expr.args()) {
                    Path p = (Path)path;
                    Step s = (Step)p.steps[0];
                    p.steps[0] = Step.get(cc, prev, s.info(), axis, s.test, s.exprs);
                }
                return expr.optimize(cc);
            }
            return null;
        };
        if (next instanceof Union) {
            return rewrite.apply(next);
        }
        if (next instanceof Filter && !(filter = (Filter)next).mayBePositional() && (expr2 = rewrite.apply(filter.root)) != null) {
            return Filter.get(cc, filter.info(), expr2, filter.exprs);
        }
        return null;
    }

    private static Axis mergedAxis(Expr expr) {
        if (expr instanceof Step) {
            Step step = (Step)expr;
            Axis axis = step.axis;
            if (!step.mayBePositional()) {
                if (axis == Axis.CHILD || axis == Axis.DESCENDANT) {
                    return Axis.DESCENDANT;
                }
                if (axis == Axis.DESCENDANT_OR_SELF) {
                    return Axis.DESCENDANT_OR_SELF;
                }
            }
        }
        return null;
    }

    private static Axis commonAxis(Expr ... exprs) {
        Axis common = null;
        for (Expr ex : exprs) {
            Path path;
            block4: {
                block3: {
                    if (!(ex instanceof Path)) break block3;
                    path = (Path)ex;
                    if (path.root == null) break block4;
                }
                return null;
            }
            Axis merged = Path.mergedAxis(path.steps[0]);
            Axis axis = common = common == merged || common == null ? merged : null;
            if (common != null) continue;
            return null;
        }
        return common;
    }

    @Override
    public final boolean inlineable(InlineContext ic) {
        if (ic.var != null && ic.expr.has(Flag.CTX)) {
            for (Expr step : this.steps) {
                if (!step.uses(ic.var)) continue;
                return false;
            }
        }
        return this.root == null || this.root.inlineable(ic);
    }

    @Override
    public final VarUsage count(Var var) {
        if (var == null) {
            return this.root == null ? VarUsage.ONCE : this.root.count(null);
        }
        VarUsage inRoot = this.root == null ? VarUsage.NEVER : this.root.count(var);
        return VarUsage.sum(var, this.steps) == VarUsage.NEVER ? inRoot : VarUsage.MORE_THAN_ONCE;
    }

    @Override
    public final Expr inline(InlineContext ic) throws QueryException {
        Expr rt;
        boolean changed = false;
        if (this.root != null) {
            Expr inlined = this.root.inline(ic);
            if (inlined != null) {
                this.root = inlined;
                changed = true;
            }
        } else if (ic.var == null) {
            this.root = ic.copy();
            changed = true;
        }
        CompileContext cc = ic.cc;
        int sl = this.steps.length;
        Expr expr = rt = this.root != null ? this.root : cc.qc.focus.value;
        if (changed) {
            cc.get(rt, true, () -> {
                for (int s = 0; s < sl; ++s) {
                    this.steps[s] = this.steps[s].optimize(cc);
                    cc.updateFocus(this.steps[s], true);
                }
                return null;
            });
        }
        return (changed |= ic.var != null && cc.ok(rt, true, () -> {
            boolean chngd = false;
            for (int s = 0; s < sl; ++s) {
                Expr step = this.steps[s].inline(ic);
                if (step != null) {
                    this.steps[s] = step;
                    chngd = true;
                }
                cc.updateFocus(this.steps[s], true);
            }
            return chngd;
        })) ? this.optimize(cc) : null;
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        if (this.root == null) {
            visitor.lock("internal:context");
        } else if (!this.root.accept(visitor)) {
            return false;
        }
        visitor.enterFocus();
        if (!Path.visitAll(visitor, this.steps)) {
            return false;
        }
        visitor.exitFocus();
        return true;
    }

    @Override
    public final int exprSize() {
        int size = 1;
        for (Expr step : this.steps) {
            size += step.exprSize();
        }
        return this.root == null ? size : size + this.root.exprSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Path)) return false;
        Path path = (Path)obj;
        if (!Objects.equals(this.root, path.root)) return false;
        if (!Array.equals(this.steps, path.steps)) return false;
        return true;
    }

    @Override
    public final void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), new Object[]{this.root, this.steps});
    }

    @Override
    public void toString(QueryString qs) {
        if (this.root != null) {
            qs.token(this.root).token('/');
        }
        qs.tokens(this.steps, "/");
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ Boolean lambda$mergeSteps$5(int sl, CompileContext cc, ExprList stps) throws QueryException {
        chngd = false;
        for (s = 0; s < sl; ++s) {
            block4: {
                curr = this.steps[s];
                if (!(curr instanceof Step)) break block4;
                crr = (Step)curr;
                v0 = next = s < sl - 1 ? this.steps[s + 1] : null;
                if (crr.test != NodeTest.NODE || !(next instanceof Step)) ** GOTO lbl-1000
                stp = (Step)next;
                if (stp.axis == Axis.ATTRIBUTE) {
                    next = Step.get(cc, null, crr.info(), crr.axis, NodeTest.ELEMENT, crr.exprs);
                    curr = cc.replaceWith(curr, next);
                    chngd = true;
                } else if (next != null && (next = Path.mergeStep(crr, next, s > 0 ? this.steps[s - 1] : this.root, cc)) != null) {
                    cc.info("merge: %", new Object[]{next});
                    curr = next;
                    chngd = true;
                    ++s;
                }
            }
            stps.add(curr);
            cc.updateFocus(curr, true);
        }
        return chngd;
    }
}

