/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.IterFilter;
import org.basex.query.expr.List;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class FnFoot
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        Iter input = this.arg(0).iter(qc);
        long size = input.size();
        if (size >= 0L) {
            return size > 0L ? input.get(size - 1L) : Empty.VALUE;
        }
        Item last = null;
        while ((item = qc.next(input)) != null) {
            last = item;
        }
        return last == null ? Empty.VALUE : last;
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr input = this.arg(0);
        SeqType st = input.seqType();
        if (st.zeroOrOne()) {
            return input;
        }
        long size = input.size();
        if (Function.TAIL.is(input) && size > 1L) {
            return cc.function(Function.FOOT, this.info, input.args());
        }
        if (Function.TRUNK.is(input) && size > 0L) {
            return cc.function(Function.ITEMS_AT, this.info, input.arg(0), Itr.get(size));
        }
        if (Function.REVERSE.is(input)) {
            return cc.function(Function.HEAD, this.info, input.args());
        }
        if (Function.REPLICATE.is(input) && input.arg(1) instanceof Itr) {
            return cc.function(Function.FOOT, this.info, input.arg(0));
        }
        if (input instanceof List) {
            Expr[] args = input.args();
            Expr last = args[args.length - 1];
            SeqType stl = last.seqType();
            if (stl.one()) {
                return last;
            }
            if (stl.oneOrMore()) {
                return cc.function(Function.FOOT, this.info, last);
            }
        }
        if (input instanceof IterFilter) {
            IterFilter filter = (IterFilter)input;
            Expr root = cc.function(Function.REVERSE, filter.info(), filter.root);
            return cc.function(Function.HEAD, this.info, Filter.get(cc, filter.info(), root, filter.exprs));
        }
        this.exprType.assign(st.with(st.oneOrMore() ? Occ.EXACTLY_ONE : Occ.ZERO_OR_ONE)).data(input);
        return this.embed(cc, false);
    }
}

