/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.inspect;

import java.io.IOException;
import org.basex.build.xml.XMLParser;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.ann.Ann;
import org.basex.query.scope.AModule;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FNode;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjectMap;
import org.basex.util.list.TokenList;

public abstract class Inspect {
    public static final byte[][] DOC_TAGS = Token.tokens("description", "author", "version", "param", "return", "error", "deprecated", "see", "since");
    public static final byte[] DOC_DESCRIPTION = Token.token("description");
    public static final byte[] DOC_PARAM = Token.token("param");
    public static final byte[] DOC_RETURN = Token.token("return");
    static final QNm Q_OCCURRENCE = new QNm("occurrence");
    static final QNm Q_TAG = new QNm("tag");
    static final QNm Q_PREFIX = new QNm("prefix");
    static final QNm Q_ARITY = new QNm("arity");
    static final QNm Q_EXTERNAL = new QNm("external");
    static final QNm Q_NAME = new QNm("name");
    static final QNm Q_URI = new QNm("uri");
    static final QNm Q_TYPE = new QNm("type");
    final QueryContext qc;
    final InputInfo info;

    Inspect(QueryContext qc, InputInfo info) {
        this.qc = qc;
        this.info = info;
    }

    public abstract FNode parse(IOContent var1) throws QueryException;

    final AModule parseModule(IO content) throws QueryException {
        QueryContext qctx = new QueryContext(this.qc.context);
        try {
            AModule aModule = qctx.parse(content.toString(), content.path());
            qctx.close();
            return aModule;
        }
        catch (Throwable throwable) {
            try {
                try {
                    qctx.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (QueryException ex) {
                throw QueryError.INSPECT_PARSE_X.get(this.info, ex);
            }
        }
    }

    final void comment(TokenObjectMap<TokenList> tags, FBuilder parent) throws QueryException {
        for (byte[] tag : tags) {
            for (byte[] value : tags.get(tag)) {
                FBuilder elem = this.element(tag);
                Inspect.add(value, elem);
                parent.add(elem);
            }
        }
    }

    final void annotations(AnnList anns, FBuilder parent, boolean uri) throws QueryException {
        for (Ann ann : anns) {
            FBuilder annotation = this.element("annotation");
            QNm name = ann.name();
            annotation.add(Q_NAME, NSGlobal.prefix(name.uri()).length == 0 ? name.string() : name.prefixId(QueryText.XQ_URI));
            if (uri) {
                annotation.add(Q_URI, name.uri());
            }
            for (Item arg : ann.value()) {
                annotation.add(this.element("literal").add(Q_TYPE, arg.type).add(arg.string(null)));
            }
            parent.add(annotation);
        }
    }

    final void options(QNmMap<String> options, FBuilder parent, boolean uri) {
        for (QNm name : options) {
            FBuilder option = this.element("option");
            option.add(Q_NAME, NSGlobal.prefix(name.uri()).length == 0 ? name.string() : name.prefixId(QueryText.XQ_URI));
            if (uri) {
                option.add(Q_URI, name.uri());
            }
            option.add(this.element("literal").add(Q_TYPE, Types.STRING_O).add(options.get(name)));
            parent.add(option);
        }
    }

    protected abstract FBuilder element(byte[] var1);

    protected abstract FBuilder element(String var1);

    public static void add(byte[] value, FBuilder elem) throws QueryException {
        try {
            if (Token.contains(value, 60)) {
                MainOptions mopts = new MainOptions();
                DBNode node = new DBNode(new XMLParser(new IOContent(value), mopts, true));
                for (ANode child : ((ANode)node).childIter()) {
                    elem.add(child.copy(mopts, null));
                }
            } else {
                elem.add(new FTxt(value));
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            elem.add(value);
        }
    }

    public static byte[] doc(TokenObjectMap<TokenList> doc, byte[] name) {
        TokenList params;
        TokenList tokenList = params = doc != null ? doc.get(DOC_PARAM) : null;
        if (params != null) {
            block0: for (byte[] param : params) {
                int s;
                int vl = param.length;
                for (int v = s = Token.startsWith(param, 36) ? 1 : 0; v < vl; ++v) {
                    if (!Token.ws(param[v])) continue;
                    if (!Token.eq(Token.substring(param, s, v), name)) continue block0;
                    return Token.trim(Token.substring(param, v + 1, vl));
                }
            }
        }
        return null;
    }
}

