/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.prof;

import java.math.BigDecimal;
import java.math.MathContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.map.MapBuilder;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Options;

public final class ProfTrack
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        TrackOptions options = this.toOptions(this.arg(1), new TrackOptions(), qc);
        long min = -1L;
        if (options.get(TrackOptions.MEMORY).booleanValue()) {
            Performance.gc(4);
            min = Performance.memory();
        }
        Performance perf = null;
        if (options.get(TrackOptions.TIME).booleanValue()) {
            perf = new Performance();
        }
        Value value = null;
        if (options.get(TrackOptions.VALUE).booleanValue()) {
            value = this.arg(0).value(qc);
        } else {
            Iter iter = this.arg(0).iter(qc);
            if (!iter.valueIter()) {
                while (qc.next(iter) != null) {
                }
            }
        }
        MapBuilder mb = new MapBuilder(3L);
        if (perf != null) {
            BigDecimal ms = BigDecimal.valueOf(perf.nanoRuntime()).divide(Dec.BD_1000000, MathContext.DECIMAL64);
            mb.put(TrackOptions.TIME.name(), (Value)Dec.get(ms));
        }
        if (min != -1L) {
            Performance.gc(2);
            mb.put(TrackOptions.MEMORY.name(), (Value)Itr.get(Math.max(0L, Performance.memory() - min)));
        }
        if (value != null) {
            mb.put(TrackOptions.VALUE.name(), value);
        }
        return mb.map();
    }

    public static final class TrackOptions
    extends Options {
        public static final BooleanOption VALUE = new BooleanOption("value", true);
        public static final BooleanOption TIME = new BooleanOption("time", true);
        public static final BooleanOption MEMORY = new BooleanOption("memory", false);
    }
}

