/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.collation;

import java.util.Locale;
import org.basex.query.util.collation.Collation;
import org.basex.util.InputInfo;
import org.basex.util.Token;

final class UnicodeNoCaseCollation
extends Collation {
    static final UnicodeNoCaseCollation INSTANCE = new UnicodeNoCaseCollation();

    UnicodeNoCaseCollation() {
    }

    @Override
    public int compare(byte[] string, byte[] compare) {
        int sl = string.length;
        int cl = compare.length;
        int l = Math.min(sl, cl);
        int s = 0;
        for (int c = 0; s < l || c < l; s += Token.cl(string, s), c += Token.cl(compare, c)) {
            int cp1 = Token.cp(string, s);
            int cp2 = Token.cp(compare, s);
            int d = UnicodeNoCaseCollation.compare(UnicodeNoCaseCollation.lc(cp1), UnicodeNoCaseCollation.lc(cp2));
            if (d == 0) continue;
            return d;
        }
        return Integer.signum(sl - cl);
    }

    @Override
    protected int indexOf(String string, String sub, Collation.Mode mode, InputInfo ii) {
        int[] stringCps = string.toLowerCase(Locale.ENGLISH).codePoints().toArray();
        int[] subCps = sub.toLowerCase(Locale.ENGLISH).codePoints().toArray();
        int tl = stringCps.length;
        int sl = subCps.length;
        if (sl == 0) {
            return 0;
        }
        if (tl >= sl) {
            int t;
            int n = t = mode == Collation.Mode.ENDS_WITH ? tl - sl : 0;
            while (t < tl) {
                int s = 0;
                while (t + s < tl && UnicodeNoCaseCollation.compare(stringCps[t + s], subCps[s]) == 0) {
                    if (++s != sl) continue;
                    return mode == Collation.Mode.INDEX_AFTER ? t + s : t;
                }
                if (mode == Collation.Mode.STARTS_WITH) {
                    return -1;
                }
                ++t;
            }
        }
        return -1;
    }

    @Override
    public byte[] key(byte[] string, InputInfo info) {
        return Collation.key(Token.lc(string));
    }

    private static int compare(int cp1, int cp2) {
        return Integer.signum(UnicodeNoCaseCollation.lc(cp1) - UnicodeNoCaseCollation.lc(cp2));
    }

    private static int lc(int cp) {
        return Character.toLowerCase(cp);
    }

    public boolean equals(Object obj) {
        return obj instanceof UnicodeNoCaseCollation;
    }
}

