/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.fn.FnRound;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Dbl
extends ANum {
    public static final Dbl NAN = new Dbl(Double.NaN);
    public static final Dbl ZERO = new Dbl(0.0);
    public static final Dbl NEGATIVE_ZERO = new Dbl(-0.0);
    public static final Dbl ONE = new Dbl(1.0);
    private final double value;

    private Dbl(double value) {
        super(AtomType.DOUBLE);
        this.value = value;
    }

    public static Dbl get(double value) {
        return value == 0.0 && Double.doubleToRawLongBits(value) == 0L ? ZERO : (value == 1.0 ? ONE : (Double.isNaN(value) ? NAN : new Dbl(value)));
    }

    @Override
    public byte[] string() {
        return Token.token(this.value);
    }

    @Override
    public boolean bool(InputInfo ii) {
        return !Double.isNaN(this.value) && this.value != 0.0;
    }

    @Override
    public long itr() {
        return (long)this.value;
    }

    @Override
    public float flt() {
        return (float)this.value;
    }

    @Override
    public double dbl() {
        return this.value;
    }

    @Override
    public BigDecimal dec(InputInfo ii) throws QueryException {
        if (!Double.isFinite(this.value)) {
            throw QueryError.valueError(AtomType.DECIMAL, this.string(), ii);
        }
        return new BigDecimal(this.value);
    }

    @Override
    public Dbl abs() {
        return this.value > 0.0 || 1.0 / this.value > 0.0 ? this : Dbl.get(-this.value);
    }

    @Override
    public Dbl ceiling() {
        double d = Math.ceil(this.value);
        return d == this.value ? this : Dbl.get(d);
    }

    @Override
    public Dbl floor() {
        double d = Math.floor(this.value);
        return d == this.value ? this : Dbl.get(d);
    }

    @Override
    public Dbl round(int prec, FnRound.RoundMode mode) {
        if (this.value == 0.0 || !Double.isFinite(this.value)) {
            return this;
        }
        double d = Dec.round(new BigDecimal(this.value), prec, mode).doubleValue();
        return d == 0.0 && Double.doubleToRawLongBits(this.value) < 0L ? NEGATIVE_ZERO : (d == this.value ? this : Dbl.get(d));
    }

    @Override
    public int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        return item.type.instanceOf(AtomType.DECIMAL) ? -item.compare(this, coll, transitive, ii) : Dbl.compare(this.value, item.dbl(ii), transitive);
    }

    static int compare(double d1, double d2, boolean transitive) {
        boolean n1 = Double.isNaN(d1);
        boolean n2 = Double.isNaN(d2);
        return n1 || n2 ? (transitive ? (n1 == n2 ? 0 : (n1 ? -1 : 1)) : Integer.MIN_VALUE) : (d1 < d2 ? -1 : (d1 > d2 ? 1 : 0));
    }

    @Override
    public Double toJava() {
        return this.value;
    }

    @Override
    public int hashCode() {
        double v = this.value;
        int i = (int)v;
        return v != (double)i && Double.isFinite(v) ? super.hashCode() : i;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Dbl)) return false;
        Dbl dbl = (Dbl)obj;
        if (Double.compare(this.value, dbl.value) != 0) return false;
        return true;
    }

    public static double parse(byte[] value, InputInfo info) throws QueryException {
        double d = Token.toDouble(value);
        if (!Double.isNaN(d)) {
            return d;
        }
        byte[] v = Token.trim(value);
        if (Token.eq(v, Token.NAN)) {
            return Double.NaN;
        }
        if (Token.eq(v, Token.POSITIVE_INF)) {
            return Double.POSITIVE_INFINITY;
        }
        if (Token.eq(v, Token.NEGATIVE_INF)) {
            return Double.NEGATIVE_INFINITY;
        }
        throw AtomType.DOUBLE.castError(value, info);
    }

    public static byte[] string(double value) {
        byte[] token = Token.fastToken(value);
        if (token != null) {
            return token;
        }
        BigDecimal bd = BigDecimal.valueOf(value).stripTrailingZeros();
        double abs = Math.abs(value);
        return value == 0.0 && Double.doubleToRawLongBits(value) < 0L ? Token.NEGATIVE_ZERO : (abs >= 1.0E-6 && abs < 1.0E21 ? Token.token(bd.toPlainString()) : Token.token(bd.toString().replace('E', 'e').replace("e+", "e")));
    }
}

