/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Arrays;
import org.basex.query.StaticContext;
import org.basex.util.InputParser;
import org.basex.util.Strings;

public final class InputInfo {
    private boolean internal;
    private final String path;
    private StaticContext sc;
    private int[] input;
    private int line;
    private int column;

    public InputInfo(InputParser parser) {
        this.input = parser.input;
        this.path = parser.path;
        this.column = parser.pos;
    }

    public InputInfo(InputParser parser, StaticContext sc) {
        this(parser);
        this.sc = sc;
    }

    public InputInfo(String path, int line, int col) {
        this.path = path;
        this.line = line;
        this.column = col;
    }

    public String path() {
        return this.path;
    }

    public int line() {
        this.init();
        return this.line;
    }

    public int column() {
        this.init();
        return this.column;
    }

    public StaticContext sc() {
        return this.sc;
    }

    private void init() {
        if (this.line != 0) {
            return;
        }
        int cl = Math.min(this.column, this.input.length);
        int l = 1;
        int c = 1;
        for (int i = 0; i < cl; ++i) {
            int cp = this.input[i];
            if (cp == 10) {
                ++l;
                c = 1;
                continue;
            }
            ++c;
        }
        this.line = l;
        this.column = c;
    }

    public boolean internal() {
        return this.internal;
    }

    public void internal(boolean value) {
        this.internal = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof InputInfo)) return false;
        InputInfo ii = (InputInfo)obj;
        if (this.path != null) {
            if (!this.path.equals(ii.path)) return false;
        } else if (!Arrays.equals(this.input, ii.input)) return false;
        if (this.column() != ii.column()) return false;
        if (this.line() != ii.line()) return false;
        return true;
    }

    public int hashCode() {
        return (this.path != null ? this.path.hashCode() : Arrays.hashCode(this.input)) + (this.column() ^ this.line());
    }

    public String toString() {
        return Strings.concat(this.path == null ? "." : this.path, ", ", this.line(), Character.valueOf('/'), this.column());
    }
}

