/*
 * Decompiled with CFR 0.152.
 */
package com.madgag.git.bfg.cleaner;

import com.madgag.collection.concurrent.ConcurrentMultiMap;
import com.madgag.git.bfg.cleaner.CLIReporter$DiffSideDetails$;
import com.madgag.git.bfg.cleaner.ObjectIdCleaner;
import com.madgag.git.bfg.cleaner.Reporter;
import com.madgag.git.bfg.cleaner.Reporter$;
import com.madgag.git.bfg.cleaner.protection.ProtectedObjectCensus$;
import com.madgag.git.bfg.cleaner.protection.ProtectedObjectDirtReport;
import com.madgag.git.bfg.cleaner.protection.ProtectedObjectDirtReport$;
import com.madgag.git.bfg.model.FileName;
import com.madgag.git.package$;
import com.madgag.text.ByteSize$;
import com.madgag.text.Tables$;
import com.madgag.text.Text$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedMap$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.Ordering$String$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tef\u0001B\u0016-\u0001]B\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\u0006\u001f\u0002!\t\u0001\u0015\u0005\t'\u0002A)\u0019!C\u0001)\"Aq\f\u0001EC\u0002\u0013\u0005\u0001\rC\u0003e\u0001\u0011\u0005Q\rC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002\u0018\u0001!\t!!\u0007\u0007\r\u0005%\u0003\u0001QA&\u0011)\tI\u0006\u0003BK\u0002\u0013\u0005\u00111\f\u0005\u000b\u0003GB!\u0011#Q\u0001\n\u0005u\u0003BCA3\u0011\tU\r\u0011\"\u0001\u0002h!Q\u0011\u0011\u0010\u0005\u0003\u0012\u0003\u0006I!!\u001b\t\u0015\u0005m\u0004B!f\u0001\n\u0003\ti\b\u0003\u0006\u0002\u0006\"\u0011\t\u0012)A\u0005\u0003\u007fB!\"a\"\t\u0005+\u0007I\u0011AAE\u0011)\t9\n\u0003B\tB\u0003%\u00111\u0012\u0005\u0007\u001f\"!\t!!'\t\u0013\u0005\u001d\u0006\"!A\u0005\u0002\u0005%\u0006\"CAZ\u0011E\u0005I\u0011AA[\u0011%\tY\rCI\u0001\n\u0003\ti\rC\u0005\u0002R\"\t\n\u0011\"\u0001\u0002T\"I\u0011q\u001b\u0005\u0012\u0002\u0013\u0005\u0011\u0011\u001c\u0005\n\u0003;D\u0011\u0011!C!\u0003?D\u0011\"a;\t\u0003\u0003%\t!!<\t\u0013\u0005U\b\"!A\u0005\u0002\u0005]\b\"\u0003B\u0002\u0011\u0005\u0005I\u0011\tB\u0003\u0011%\u0011\u0019\u0002CA\u0001\n\u0003\u0011)\u0002C\u0005\u0003 !\t\t\u0011\"\u0011\u0003\"!I!Q\u0005\u0005\u0002\u0002\u0013\u0005#q\u0005\u0005\n\u0005SA\u0011\u0011!C!\u0005WA\u0011B!\f\t\u0003\u0003%\tEa\f\b\u0013\tM\u0002!!A\t\u0002\tUb!CA%\u0001\u0005\u0005\t\u0012\u0001B\u001c\u0011\u0019y\u0015\u0005\"\u0001\u0003P!I!\u0011F\u0011\u0002\u0002\u0013\u0015#1\u0006\u0005\n\u0005#\n\u0013\u0011!CA\u0005'B\u0011B!\u0018\"\u0003\u0003%\tIa\u0018\t\u000f\t5\u0004\u0001\"\u0001\u0003p!9!\u0011\u0010\u0001\u0005\u0002\tm\u0004b\u0002BG\u0001\u0011\u0005!q\u0012\u0005\b\u0005C\u0003A\u0011\u0001BR\u0011\u001d\u0011\t\f\u0001C\u0001\u0005g\u00131b\u0011'J%\u0016\u0004xN\u001d;fe*\u0011QFL\u0001\bG2,\u0017M\\3s\u0015\ty\u0003'A\u0002cM\u001eT!!\r\u001a\u0002\u0007\u001dLGO\u0003\u00024i\u00051Q.\u00193hC\u001eT\u0011!N\u0001\u0004G>l7\u0001A\n\u0004\u0001ar\u0004CA\u001d=\u001b\u0005Q$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR$AB!osJ+g\r\u0005\u0002@\u00016\tA&\u0003\u0002BY\tA!+\u001a9peR,'/\u0001\u0003sKB|\u0007C\u0001#N\u001b\u0005)%B\u0001$H\u0003\ra\u0017N\u0019\u0006\u0003\u0011&\u000bAA[4ji*\u0011!jS\u0001\bK\u000ed\u0017\u000e]:f\u0015\u0005a\u0015aA8sO&\u0011a*\u0012\u0002\u000b%\u0016\u0004xn]5u_JL\u0018A\u0002\u001fj]&$h\b\u0006\u0002R%B\u0011q\b\u0001\u0005\u0006\u0005\n\u0001\raQ\u0001\u000be\u0016\u0004xN\u001d;t\t&\u0014X#A+\u0011\u0005YkV\"A,\u000b\u0005aK\u0016\u0001\u00024jY\u0016T!AW.\u0002\u00079LwNC\u0001]\u0003\u0011Q\u0017M^1\n\u0005y;&\u0001\u0002)bi\"\fq\u0002\u001d:pOJ,7o]'p]&$xN]\u000b\u0002CB\u0011AIY\u0005\u0003G\u0016\u00131\u0003V3yiB\u0013xn\u001a:fgNluN\\5u_J\fAC]3q_J$(+\u001a4Va\u0012\fG/Z*uCJ$HC\u00014j!\tIt-\u0003\u0002iu\t!QK\\5u\u0011\u0015QW\u00011\u0001l\u0003E\u0011XMZ+qI\u0006$XmQ8n[\u0006tGm\u001d\t\u0004YR<hBA7s\u001d\tq\u0017/D\u0001p\u0015\t\u0001h'\u0001\u0004=e>|GOP\u0005\u0002w%\u00111OO\u0001\ba\u0006\u001c7.Y4f\u0013\t)hO\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\t\u0019(\b\u0005\u0002yw6\t\u0011P\u0003\u0002{\u000f\u0006IAO]1ogB|'\u000f^\u0005\u0003yf\u0014aBU3dK&4XmQ8n[\u0006tG-A\tsKB|'\u000f\u001e*fMN4uN]*dC:$2a`A\u0006)\r1\u0017\u0011\u0001\u0005\b\u0003\u00071\u00019AA\u0003\u0003%y'M\u001b*fC\u0012,'\u000fE\u0002E\u0003\u000fI1!!\u0003F\u00051y%M[3diJ+\u0017\rZ3s\u0011\u001d\tiA\u0002a\u0001\u0003\u001f\tq!\u00197m%\u001647\u000f\u0005\u0003mi\u0006E\u0001c\u0001#\u0002\u0014%\u0019\u0011QC#\u0003\u0007I+g-\u0001\fsKB|'\u000f^(cU\u0016\u001cG\u000f\u0015:pi\u0016\u001cG/[8o)\u0011\tY\"a\u000e\u0015\u000b\u0019\fi\"a\n\t\u000f\u0005}q\u0001q\u0001\u0002\"\u0005AqN\u00196fGR$%\tE\u0002E\u0003GI1!!\nF\u00059y%M[3di\u0012\u000bG/\u00192bg\u0016Dq!!\u000b\b\u0001\b\tY#A\u0004sKZ<\u0016\r\\6\u0011\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\rH\u0003\u001d\u0011XM^<bY.LA!!\u000e\u00020\t9!+\u001a<XC2\\\u0007bBA\u001d\u000f\u0001\u0007\u00111H\u0001\u0016_\nTWm\u0019;JI\u000ecW-\u00198fe\u000e{gNZ5h!\u0011\ti$a\u0011\u000f\u0007}\ny$C\u0002\u0002B1\nqb\u00142kK\u000e$\u0018\nZ\"mK\u0006tWM]\u0005\u0005\u0003\u000b\n9E\u0001\u0004D_:4\u0017n\u001a\u0006\u0004\u0003\u0003b#a\u0004#jM\u001a\u001c\u0016\u000eZ3EKR\f\u0017\u000e\\:\u0014\r!A\u0014QJA*!\rI\u0014qJ\u0005\u0004\u0003#R$a\u0002)s_\u0012,8\r\u001e\t\u0004Y\u0006U\u0013bAA,m\na1+\u001a:jC2L'0\u00192mK\u0006\u0011\u0011\u000eZ\u000b\u0003\u0003;\u00022\u0001RA0\u0013\r\t\t'\u0012\u0002\t\u001f\nTWm\u0019;JI\u0006\u0019\u0011\u000e\u001a\u0011\u0002\tA\fG\u000f[\u000b\u0003\u0003S\u0002B!a\u001b\u0002t9!\u0011QNA8!\tq'(C\u0002\u0002ri\na\u0001\u0015:fI\u00164\u0017\u0002BA;\u0003o\u0012aa\u0015;sS:<'bAA9u\u0005)\u0001/\u0019;iA\u0005!Qn\u001c3f+\t\ty\bE\u0002E\u0003\u0003K1!a!F\u0005!1\u0015\u000e\\3N_\u0012,\u0017!B7pI\u0016\u0004\u0013\u0001B:ju\u0016,\"!a#\u0011\u000be\ni)!%\n\u0007\u0005=%H\u0001\u0004PaRLwN\u001c\t\u0004s\u0005M\u0015bAAKu\t!Aj\u001c8h\u0003\u0015\u0019\u0018N_3!))\tY*a(\u0002\"\u0006\r\u0016Q\u0015\t\u0004\u0003;CQ\"\u0001\u0001\t\u000f\u0005e\u0013\u00031\u0001\u0002^!9\u0011QM\tA\u0002\u0005%\u0004bBA>#\u0001\u0007\u0011q\u0010\u0005\b\u0003\u000f\u000b\u0002\u0019AAF\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005m\u00151VAW\u0003_\u000b\t\fC\u0005\u0002ZI\u0001\n\u00111\u0001\u0002^!I\u0011Q\r\n\u0011\u0002\u0003\u0007\u0011\u0011\u000e\u0005\n\u0003w\u0012\u0002\u0013!a\u0001\u0003\u007fB\u0011\"a\"\u0013!\u0003\u0005\r!a#\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0017\u0016\u0005\u0003;\nIl\u000b\u0002\u0002<B!\u0011QXAd\u001b\t\tyL\u0003\u0003\u0002B\u0006\r\u0017!C;oG\",7m[3e\u0015\r\t)MO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAe\u0003\u007f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a4+\t\u0005%\u0014\u0011X\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t)N\u000b\u0003\u0002\u0000\u0005e\u0016AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u00037TC!a#\u0002:\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!9\u0011\t\u0005\r\u0018\u0011^\u0007\u0003\u0003KT1!a:\\\u0003\u0011a\u0017M\\4\n\t\u0005U\u0014Q]\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003_\u00042!OAy\u0013\r\t\u0019P\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003s\fy\u0010E\u0002:\u0003wL1!!@;\u0005\r\te.\u001f\u0005\n\u0005\u0003I\u0012\u0011!a\u0001\u0003_\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0004!\u0019\u0011IAa\u0004\u0002z6\u0011!1\u0002\u0006\u0004\u0005\u001bQ\u0014AC2pY2,7\r^5p]&!!\u0011\u0003B\u0006\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t]!Q\u0004\t\u0004s\te\u0011b\u0001B\u000eu\t9!i\\8mK\u0006t\u0007\"\u0003B\u00017\u0005\u0005\t\u0019AA}\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\u0005(1\u0005\u0005\n\u0005\u0003a\u0012\u0011!a\u0001\u0003_\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003_\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003C\fa!Z9vC2\u001cH\u0003\u0002B\f\u0005cA\u0011B!\u0001 \u0003\u0003\u0005\r!!?\u0002\u001f\u0011KgMZ*jI\u0016$U\r^1jYN\u00042!!(\"'\u0015\t#\u0011\bB#!9\u0011YD!\u0011\u0002^\u0005%\u0014qPAF\u00037k!A!\u0010\u000b\u0007\t}\"(A\u0004sk:$\u0018.\\3\n\t\t\r#Q\b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004\u0003\u0002B$\u0005\u001bj!A!\u0013\u000b\u0007\t-3,\u0001\u0002j_&!\u0011q\u000bB%)\t\u0011)$A\u0003baBd\u0017\u0010\u0006\u0006\u0002\u001c\nU#q\u000bB-\u00057Bq!!\u0017%\u0001\u0004\ti\u0006C\u0004\u0002f\u0011\u0002\r!!\u001b\t\u000f\u0005mD\u00051\u0001\u0002\u0000!9\u0011q\u0011\u0013A\u0002\u0005-\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0005C\u0012I\u0007E\u0003:\u0003\u001b\u0013\u0019\u0007E\u0006:\u0005K\ni&!\u001b\u0002\u0000\u0005-\u0015b\u0001B4u\t1A+\u001e9mKRB\u0011Ba\u001b&\u0003\u0003\u0005\r!a'\u0002\u0007a$\u0003'\u0001\u0012sKB|'\u000f\u001e)s_R,7\r^3e\u0007>lW.\u001b;t\u0003:$G\u000b[3je\u0012K'\u000f\u001e\u000b\u0005\u0005c\u00129\bF\u0003g\u0005g\u0012)\bC\u0004\u0002 \u0019\u0002\u001d!!\t\t\u000f\u0005%b\u0005q\u0001\u0002,!9\u0011\u0011\b\u0014A\u0002\u0005m\u0012aD2iC:<W\r\u001a'j]\u0016\u001chi\u001c:\u0015\t\u0005%$Q\u0010\u0005\b\u0005\u007f:\u0003\u0019\u0001BA\u0003\u0015)G-\u001b;t!\u0011\u0011\u0019I!#\u000e\u0005\t\u0015%b\u0001BD\u000f\u0006!A-\u001b4g\u0013\u0011\u0011YI!\"\u0003\u0011\u0015#\u0017\u000e\u001e'jgR\f1C]3q_J$8\t\\3b]&twm\u0015;beR$2A\u001aBI\u0011\u001d\u0011\u0019\n\u000ba\u0001\u0005+\u000bqaY8n[&$8\u000fE\u0003m\u0005/\u0013Y*C\u0002\u0003\u001aZ\u00141aU3r!\u0011\tiC!(\n\t\t}\u0015q\u0006\u0002\n%\u001648i\\7nSR\fQB]3q_J$(+Z:vYR\u001cH#\u00024\u0003&\n\u001d\u0006b\u0002BJS\u0001\u0007!Q\u0013\u0005\b\u0005SK\u0003\u0019\u0001BV\u0003=y'M[3di&#7\t\\3b]\u0016\u0014\bcA \u0003.&\u0019!q\u0016\u0017\u0003\u001f=\u0013'.Z2u\u0013\u0012\u001cE.Z1oKJ\fQ\u0001^5uY\u0016$B!!9\u00036\"9!q\u0017\u0016A\u0002\u0005%\u0014\u0001\u0002;fqR\u0004")
public class CLIReporter
implements Reporter {
    private Path reportsDir;
    private TextProgressMonitor progressMonitor;
    private volatile CLIReporter$DiffSideDetails$ DiffSideDetails$module;
    private final Repository repo;
    private volatile byte bitmap$0;

    public CLIReporter$DiffSideDetails$ DiffSideDetails() {
        if (this.DiffSideDetails$module == null) {
            this.DiffSideDetails$lzycompute$1();
        }
        return this.DiffSideDetails$module;
    }

    private Path reportsDir$lzycompute() {
        CLIReporter cLIReporter = this;
        synchronized (cLIReporter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                ZonedDateTime now = ZonedDateTime.now();
                Path topDirPath = package$.MODULE$.RichRepo(this.repo).topDirectory().toPath().toAbsolutePath();
                Path reportsDir = topDirPath.resolveSibling(topDirPath.getFileName() + ".bfg-report");
                DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("uuuu-MM-dd");
                DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH-mm-ss");
                Path dir = reportsDir.resolve(now.format(dateFormatter)).resolve(now.format(timeFormatter));
                Files.createDirectories(dir, new FileAttribute[0]);
                this.reportsDir = dir;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.reportsDir;
    }

    public Path reportsDir() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.reportsDir$lzycompute();
        }
        return this.reportsDir;
    }

    private TextProgressMonitor progressMonitor$lzycompute() {
        CLIReporter cLIReporter = this;
        synchronized (cLIReporter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.progressMonitor = new TextProgressMonitor();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.progressMonitor;
    }

    @Override
    public TextProgressMonitor progressMonitor() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.progressMonitor$lzycompute();
        }
        return this.progressMonitor;
    }

    @Override
    public void reportRefUpdateStart(Iterable<ReceiveCommand> refUpdateCommands) {
        Predef$.MODULE$.println(this.title("Updating " + Text$.MODULE$.plural(refUpdateCommands, "Ref")));
        Iterable summaryTableCells = (Iterable)refUpdateCommands.map((Function1<ReceiveCommand, Tuple3> & Serializable)update -> new Tuple3<String, String, String>(update.getRefName(), package$.MODULE$.RichObjectId(update.getOldId()).shortName(), package$.MODULE$.RichObjectId(update.getNewId()).shortName()));
        ((IterableOnceOps)Tables$.MODULE$.formatTable(new Tuple3<String, String, String>("Ref", "Before", "After"), summaryTableCells.toSeq(), Tables$.MODULE$.formatTable$default$3()).map((Function1<String, String> & Serializable)x$1 -> "\t" + x$1)).foreach((Function1<Object, Object> & Serializable)x -> {
            Predef$.MODULE$.println(x);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println();
    }

    @Override
    public void reportRefsForScan(Iterable<Ref> allRefs, ObjectReader objReader) {
        Map refsByObjType = allRefs.groupBy((Function1<Ref, Object> & Serializable)ref -> BoxesRunTime.boxToInteger(CLIReporter.$anonfun$reportRefsForScan$1(objReader, ref))).withDefault((Function1)scala.package$.MODULE$.Seq().empty());
        refsByObjType.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            CLIReporter.$anonfun$reportRefsForScan$2(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void reportObjectProtection(ObjectIdCleaner.Config objectIdCleanerConfig, ObjectDatabase objectDB, RevWalk revWalk) {
        Predef$.MODULE$.println(this.title("Protected commits"));
        if (objectIdCleanerConfig.protectedObjectCensus().isEmpty()) {
            Predef$.MODULE$.println("You're not protecting any commits, which means the BFG will modify the contents of even *current* commits.\n\nThis isn't recommended - ideally, if your current commits are dirty, you should fix up your working copy and commit that, check that your build still works, and only then run the BFG to clean up your history.");
            return;
        }
        Predef$.MODULE$.println("These are your protected commits, and so their contents will NOT be altered:\n");
        ObjectIdCleaner.Config unprotectedConfig = objectIdCleanerConfig.copy(ProtectedObjectCensus$.MODULE$.None(), objectIdCleanerConfig.copy$default$2(), objectIdCleanerConfig.copy$default$3(), objectIdCleanerConfig.copy$default$4(), objectIdCleanerConfig.copy$default$5(), objectIdCleanerConfig.copy$default$6(), objectIdCleanerConfig.copy$default$7());
        this.reportProtectedCommitsAndTheirDirt(objectIdCleanerConfig, objectDB, revWalk);
    }

    public void reportProtectedCommitsAndTheirDirt(ObjectIdCleaner.Config objectIdCleanerConfig, ObjectDatabase objectDB, RevWalk revWalk) {
        ObjectReader reader = revWalk.getObjectReader();
        Path protectedDirtDir = this.reportsDir().resolve("protected-dirt");
        Files.createDirectories(protectedDirtDir, new FileAttribute[0]);
        Iterable<ProtectedObjectDirtReport> reports = ProtectedObjectDirtReport$.MODULE$.reportsFor(objectIdCleanerConfig, objectDB, revWalk);
        reports.foreach((Function1<ProtectedObjectDirtReport, Object> & Serializable)report -> {
            CLIReporter.$anonfun$reportProtectedCommitsAndTheirDirt$3(this, objectIdCleanerConfig, revWalk, protectedDirtDir, reader, report);
            return BoxedUnit.UNIT;
        });
        Iterable dirtyReports = (Iterable)reports.filter((Function1<ProtectedObjectDirtReport, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(x$4.objectProtectsDirt()));
        if (dirtyReports.nonEmpty()) {
            Predef$.MODULE$.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |WARNING: The dirty content above may be removed from other commits, but as\n      |the *protected* commits still use it, it will STILL exist in your repository.\n      |\n      |Details of protected dirty content have been recorded here :\n      |\n      |" + ((Object)protectedDirtDir.toAbsolutePath()).toString() + protectedDirtDir.getFileSystem().getSeparator() + "\n      |\n      |If you *really* want this content gone, make a manual commit that removes it,\n      |and then run the BFG on a fresh copy of your repo.\n       ")));
            return;
        }
    }

    public String changedLinesFor(EditList edits) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(edits).asScala().map((Function1<Edit, String> & Serializable)edit -> ((IterableOnceOps)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{edit.getBeginA() + 1, edit.getEndA()})).distinct()).mkString("-"))).mkString(";");
    }

    @Override
    public void reportCleaningStart(Seq<RevCommit> commits) {
        Predef$.MODULE$.println(this.title("Cleaning"));
        Predef$.MODULE$.println("Found " + commits.size() + " commits");
    }

    @Override
    public void reportResults(Seq<RevCommit> commits, ObjectIdCleaner objectIdCleaner) {
        LazyRef mapFile$lzy = new LazyRef();
        LazyRef cacheStatsFile$lzy = new LazyRef();
        this.reportTreeDirtHistory$1(commits, objectIdCleaner);
        Map<ObjectId, ObjectId> changedIds = objectIdCleaner.cleanedObjectMap();
        this.reportFiles$1(objectIdCleaner.changesByFilename(), "Changed", new Tuple2<String, String>("Filename", "Before & After"), (Function1<Tuple2, Product> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                FileName filename = (FileName)tuple2._1();
                Set changes = (Set)tuple2._2();
                return new Tuple2<FileName, String>(filename, Text$.MODULE$.abbreviate((Iterable)changes.map((Function1<Tuple2, String> & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        ObjectId oldId = (ObjectId)tuple2._1();
                        ObjectId newId = (ObjectId)tuple2._2();
                        return package$.MODULE$.RichObjectId(oldId).shortName() + " \u21d2 " + package$.MODULE$.RichObjectId(newId).shortName();
                    }
                    throw new MatchError(tuple2);
                }), "...", Text$.MODULE$.abbreviate$default$3()).mkString(", "));
            }
            throw new MatchError(tuple2);
        }, (Function1<Tuple2, Seq> & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                ObjectId oldId = (ObjectId)tuple2._1();
                ObjectId newId = (ObjectId)tuple2._2();
                return new $colon$colon<Nothing$>((Nothing$)((Object)oldId.name()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)newId.name()), Nil$.MODULE$));
            }
            throw new MatchError(tuple2);
        });
        ObjectReader reader = objectIdCleaner.threadLocalResources().reader();
        this.reportFiles$1(objectIdCleaner.deletionsByFilename(), "Deleted", new Tuple2<String, String>("Filename", "Git id"), (Function1<Tuple2, Product> & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                FileName filename = (FileName)tuple2._1();
                Set oldIds = (Set)tuple2._2();
                return new Tuple2<FileName, String>(filename, Text$.MODULE$.abbreviate((Iterable)oldIds.map((Function1<ObjectId, String> & Serializable)oldId -> package$.MODULE$.RichObjectId((AnyObjectId)oldId).shortName() + Option$.MODULE$.option2Iterable(package$.MODULE$.RichObjectId((AnyObjectId)oldId).sizeOpt(reader).map((Function1<Object, String> & Serializable)size -> CLIReporter.$anonfun$reportResults$26(BoxesRunTime.unboxToLong(size)))).mkString()), "...", Text$.MODULE$.abbreviate$default$3()).mkString(", "));
            }
            throw new MatchError(tuple2);
        }, (Function1<ObjectId, Seq> & Serializable)oldId -> new $colon$colon<Nothing$>((Nothing$)((Object)oldId.name()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Option$.MODULE$.option2Iterable(package$.MODULE$.RichObjectId((AnyObjectId)oldId).sizeOpt(reader)).mkString()), Nil$.MODULE$)));
        Predef$.MODULE$.println("\n\nIn total, " + changedIds.size() + " object ids were changed. Full details are logged here:\n\n\t" + this.reportsDir());
        Reporter$.MODULE$.dump(this.mapFile$1(mapFile$lzy), (Iterable)((MapOps)SortedMap$.MODULE$.apply(changedIds.toSeq(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).view().map((Function1<Tuple2, String> & Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 != null) {
                AnyObjectId o = (AnyObjectId)tuple2._1();
                ObjectId n = (ObjectId)tuple2._2();
                return o.name() + " " + n.name();
            }
            throw new MatchError(tuple2);
        }));
        Reporter$.MODULE$.dump(this.cacheStatsFile$1(cacheStatsFile$lzy), (Iterable)objectIdCleaner.stats().map((Function1<Tuple2, String> & Serializable)x$13 -> x$13.toString()));
        Predef$.MODULE$.println("\nBFG run is complete! When ready, run: git reflog expire --expire=now --all && git gc --prune=now --aggressive");
    }

    public String title(String text) {
        return "\n" + text + "\n" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(text))) + "\n";
    }

    private final void DiffSideDetails$lzycompute$1() {
        CLIReporter cLIReporter = this;
        synchronized (cLIReporter) {
            if (this.DiffSideDetails$module == null) {
                this.DiffSideDetails$module = new CLIReporter$DiffSideDetails$(this);
            }
        }
    }

    public static final /* synthetic */ int $anonfun$reportRefsForScan$1(ObjectReader objReader$1, Ref ref) {
        return objReader$1.open(ref.getObjectId()).getType();
    }

    public static final /* synthetic */ void $anonfun$reportRefsForScan$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int typ = tuple2._1$mcI$sp();
            Iterable refs = (Iterable)tuple2._2();
            Predef$.MODULE$.println("Found " + refs.size() + " " + Constants.typeString(typ) + "-pointing refs : " + Text$.MODULE$.abbreviate(((IterableOnceOps)refs.map((Function1<Ref, String> & Serializable)x$2 -> x$2.getName())).toSeq(), "...", 4).mkString(", "));
            return;
        }
        throw new MatchError(tuple2);
    }

    private final DiffSideDetails diffDetails$1(DiffEntry d, ObjectReader reader$1) {
        DiffEntry.Side side = DiffEntry.Side.OLD;
        ObjectId id = d.getId(side).toObjectId();
        return new DiffSideDetails(this, id, d.getPath(side), d.getMode(side), package$.MODULE$.RichObjectId(id).sizeOpt(reader$1));
    }

    private static final String fileInfo$1(DiffSideDetails d) {
        FileMode fileMode = d.mode();
        FileMode fileMode2 = FileMode.GITLINK;
        FileMode fileMode3 = fileMode;
        Option extraInfo = (!(fileMode2 != null ? !fileMode2.equals(fileMode3) : fileMode3 != null) ? new Some<String>("submodule") : d.size().map((Function1<Object, String> & Serializable)x$3 -> ByteSize$.MODULE$.format(BoxesRunTime.unboxToLong(x$3)))).map((Function1<String, String> & Serializable)e -> "(" + e + ")");
        String string = d.path();
        return ((IterableOnceOps)Option$.MODULE$.option2Iterable(extraInfo).toSeq().$plus$colon(string)).mkString(" ");
    }

    public static final /* synthetic */ void $anonfun$reportProtectedCommitsAndTheirDirt$3(CLIReporter $this, ObjectIdCleaner.Config objectIdCleanerConfig$1, RevWalk revWalk$1, Path protectedDirtDir$1, ObjectReader reader$1, ProtectedObjectDirtReport report) {
        Set protectorRevs = (Set)objectIdCleanerConfig$1.protectedObjectCensus().protectorRevsByObject().apply(report.revObject());
        String objectTitle = " * " + package$.MODULE$.RichRevObject(report.revObject()).typeString() + " " + package$.MODULE$.RichObjectId(report.revObject()).shortName() + " (protected by '" + protectorRevs.mkString("', '") + "')";
        Option<Seq<DiffEntry>> option = report.dirt(revWalk$1);
        if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.println(objectTitle);
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq diffEntries = (Seq)some.value();
            if (diffEntries.isEmpty()) {
                Predef$.MODULE$.println(objectTitle + " - dirty");
                return;
            }
            Predef$.MODULE$.println(objectTitle + " - contains " + Text$.MODULE$.plural(diffEntries, "dirty file") + " : ");
            Text$.MODULE$.abbreviate(diffEntries.view().map((Function1<DiffEntry, DiffSideDetails> & Serializable)d -> $this.diffDetails$1((DiffEntry)d, reader$1)).map((Function1<DiffSideDetails, String> & Serializable)d -> CLIReporter.fileInfo$1(d)), "...", Text$.MODULE$.abbreviate$default$3()).foreach((Function1<String, Object> & Serializable)dirtyFile -> {
                Predef$.MODULE$.println("\t- " + dirtyFile);
                return BoxedUnit.UNIT;
            });
            String protectorRefsFileNameSafe = protectorRevs.mkString("_").replace(protectedDirtDir$1.getFileSystem().getSeparator(), "-");
            Path diffFile = protectedDirtDir$1.resolve(package$.MODULE$.RichObjectId(report.revObject()).shortName() + "-" + protectorRefsFileNameSafe + ".csv");
            Reporter$.MODULE$.dump(diffFile, (Iterable)diffEntries.map((Function1<DiffEntry, String> & Serializable)diffEntry -> {
                DiffSideDetails de = $this.diffDetails$1((DiffEntry)diffEntry, reader$1);
                DiffEntry.ChangeType changeType = diffEntry.getChangeType();
                DiffEntry.ChangeType changeType2 = DiffEntry.ChangeType.MODIFY;
                None$ modifiedLines = !(changeType != null ? !((Object)((Object)changeType)).equals((Object)changeType2) : changeType2 != null) ? package$.MODULE$.RichDiffEntry((DiffEntry)diffEntry).editList(reader$1).map((Function1<EditList, String> & Serializable)edits -> $this.changedLinesFor((EditList)edits)) : None$.MODULE$;
                Seq elems = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{de.id().name(), diffEntry.getChangeType().name(), package$.MODULE$.RichFileMode(de.mode()).name(), de.path(), de.size().getOrElse((Function0<String> & Serializable)() -> ""), modifiedLines.getOrElse((Function0<String> & Serializable)() -> "")}));
                return elems.mkString(",");
            }));
            return;
        }
        throw new MatchError(option);
    }

    private static final int startOf$1(int unit, float avgSize$1) {
        return scala.math.package$.MODULE$.round((float)unit * avgSize$1);
    }

    public static final /* synthetic */ Seq $anonfun$reportResults$1(Seq xs$1, float avgSize$1, int u) {
        return (Seq)xs$1.slice(CLIReporter.startOf$1(u, avgSize$1), CLIReporter.startOf$1(u + 1, avgSize$1));
    }

    private static final IndexedSeqView cut$1(Seq xs, int n) {
        float avgSize = (float)xs.size() / (float)n;
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).view().map((Function1<Object, Seq> & Serializable)u -> CLIReporter.$anonfun$reportResults$1(xs, avgSize, BoxesRunTime.unboxToInt(u)));
    }

    public static final /* synthetic */ char $anonfun$reportResults$2(ObjectIdCleaner objectIdCleaner$1, Seq x0$1) {
        Seq seq = x0$1;
        if (seq.isEmpty()) {
            return ' ';
        }
        if (seq.exists((Function1<RevCommit, Object> & Serializable)c -> BoxesRunTime.boxToBoolean(objectIdCleaner$1.isDirty(c.getTree())))) {
            return 'D';
        }
        if (seq.exists((Function1<ObjectId, Object> & Serializable)v -> BoxesRunTime.boxToBoolean(objectIdCleaner$1.isDirty(v)))) {
            return 'm';
        }
        return '.';
    }

    private static final String leftRight$1(Seq markers, String treeDirtHistory$1) {
        return markers.mkString(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), treeDirtHistory$1.length() - BoxesRunTime.unboxToInt(((IterableOnceOps)markers.map((Function1<String, Object> & Serializable)x$5 -> BoxesRunTime.boxToInteger(StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(x$5))))).sum(Numeric$IntIsIntegral$.MODULE$))));
    }

    public static final /* synthetic */ boolean $anonfun$reportResults$10(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$reportResults$12(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    private final void reportTreeDirtHistory$1(Seq commits$1, ObjectIdCleaner objectIdCleaner$1) {
        int dirtHistoryElements = scala.math.package$.MODULE$.max(20, scala.math.package$.MODULE$.min(60, commits$1.size()));
        String treeDirtHistory = CLIReporter.cut$1(commits$1, dirtHistoryElements).map((Function1<Seq, Object> & Serializable)x0$1 -> BoxesRunTime.boxToCharacter(CLIReporter.$anonfun$reportResults$2(objectIdCleaner$1, x0$1))).mkString();
        Predef$.MODULE$.println(this.title("Commit Tree-Dirt History"));
        Predef$.MODULE$.println("\t" + CLIReporter.leftRight$1(new $colon$colon<Nothing$>((Nothing$)((Object)"Earliest"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"Latest"), Nil$.MODULE$)), treeDirtHistory));
        Predef$.MODULE$.println("\t" + CLIReporter.leftRight$1(new $colon$colon<Nothing$>((Nothing$)((Object)"|"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"|"), Nil$.MODULE$)), treeDirtHistory));
        Predef$.MODULE$.println("\t" + treeDirtHistory);
        Predef$.MODULE$.println("\n\tD = dirty commits (file tree fixed)");
        Predef$.MODULE$.println("\tm = modified commits (commit message or parents changed)");
        Predef$.MODULE$.println("\t. = clean commits (no changes to file tree)\n");
        Option firstModifiedCommit = commits$1.find((Function1<ObjectId, Object> & Serializable)v -> BoxesRunTime.boxToBoolean(objectIdCleaner$1.isDirty(v))).map((Function1<RevCommit, Tuple2> & Serializable)x$6 -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$6), "First modified commit"));
        Option lastDirtyCommit = ((IterableOnceOps)commits$1.reverse()).find((Function1<RevCommit, Object> & Serializable)c -> BoxesRunTime.boxToBoolean(objectIdCleaner$1.isDirty(c.getTree()))).map((Function1<RevCommit, Tuple2> & Serializable)x$7 -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$7), "Last dirty commit"));
        Iterable items = (Iterable)((IterableOps)Option$.MODULE$.option2Iterable(firstModifiedCommit).$plus$plus(lastDirtyCommit)).withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(CLIReporter.$anonfun$reportResults$10(check$ifrefutable$1))).flatMap((Function1<Tuple2, Option> & Serializable)x$9 -> {
            Tuple2 tuple2 = x$9;
            if (tuple2 != null) {
                RevCommit commit = (RevCommit)tuple2._1();
                String desc = (String)tuple2._2();
                return objectIdCleaner$1.substitution(commit).withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(CLIReporter.$anonfun$reportResults$12(check$ifrefutable$2))).map((Function1<Tuple2, Tuple3> & Serializable)x$8 -> {
                    Tuple2 tuple2 = x$8;
                    if (tuple2 != null) {
                        ObjectId before = (ObjectId)tuple2._1();
                        ObjectId after = (ObjectId)tuple2._2();
                        return new Tuple3<String, String, String>(desc, package$.MODULE$.RichObjectId(before).shortName(), package$.MODULE$.RichObjectId(after).shortName());
                    }
                    throw new MatchError(tuple2);
                });
            }
            throw new MatchError(tuple2);
        });
        ((IterableOnceOps)Tables$.MODULE$.formatTable(new Tuple3<String, String, String>("", "Before", "After"), items.toSeq(), Tables$.MODULE$.formatTable$default$3()).map((Function1<String, String> & Serializable)x$10 -> "\t" + x$10)).foreach((Function1<Object, Object> & Serializable)x -> {
            Predef$.MODULE$.println(x);
            return BoxedUnit.UNIT;
        });
    }

    private final /* synthetic */ Path mapFile$lzycompute$1(LazyRef mapFile$lzy$1) {
        Path path;
        LazyRef lazyRef = mapFile$lzy$1;
        synchronized (lazyRef) {
            path = mapFile$lzy$1.initialized() ? (Path)mapFile$lzy$1.value() : mapFile$lzy$1.initialize(this.reportsDir().resolve("object-id-map.old-new.txt"));
        }
        return path;
    }

    private final Path mapFile$1(LazyRef mapFile$lzy$1) {
        if (mapFile$lzy$1.initialized()) {
            return (Path)mapFile$lzy$1.value();
        }
        return this.mapFile$lzycompute$1(mapFile$lzy$1);
    }

    private final /* synthetic */ Path cacheStatsFile$lzycompute$1(LazyRef cacheStatsFile$lzy$1) {
        Path path;
        LazyRef lazyRef = cacheStatsFile$lzy$1;
        synchronized (lazyRef) {
            path = cacheStatsFile$lzy$1.initialized() ? (Path)cacheStatsFile$lzy$1.value() : cacheStatsFile$lzy$1.initialize(this.reportsDir().resolve("cache-stats.txt"));
        }
        return path;
    }

    private final Path cacheStatsFile$1(LazyRef cacheStatsFile$lzy$1) {
        if (cacheStatsFile$lzy$1.initialized()) {
            return (Path)cacheStatsFile$lzy$1.value();
        }
        return this.cacheStatsFile$lzycompute$1(cacheStatsFile$lzy$1);
    }

    private final void reportFiles$1(ConcurrentMultiMap fileData, String actionType, Product tableTitles, Function1 f, Function1 fi) {
        Ordering fileNameOrdering = scala.package$.MODULE$.Ordering().apply(Ordering$String$.MODULE$).on((Function1<FileName, String> & Serializable)x$11 -> x$11.string());
        SortedMap dataByFilename = (SortedMap)SortedMap$.MODULE$.apply(fileData.toMap().toSeq(), fileNameOrdering);
        if (dataByFilename.nonEmpty()) {
            Predef$.MODULE$.println(this.title(actionType + " files"));
            ((IterableOnceOps)Tables$.MODULE$.formatTable(tableTitles, ((IterableOnceOps)dataByFilename.map(f)).toSeq(), Tables$.MODULE$.formatTable$default$3()).map((Function1<String, String> & Serializable)x$12 -> "\t" + x$12)).foreach((Function1<Object, Object> & Serializable)x -> {
                Predef$.MODULE$.println(x);
                return BoxedUnit.UNIT;
            });
            Path actionFile = this.reportsDir().resolve(actionType.toLowerCase() + "-files.txt");
            Reporter$.MODULE$.dump(actionFile, (Iterable)dataByFilename.flatMap((Function1<Tuple2, IterableOnce> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    FileName filename = (FileName)tuple2._1();
                    Set changes = (Set)tuple2._2();
                    return (IterableOnce)changes.map(fi.andThen((Function1<Seq, String> & Serializable)fid -> ((IterableOnceOps)fid.$colon$plus(filename)).mkString(" ")));
                }
                throw new MatchError(tuple2);
            }));
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$reportResults$26(long size) {
        return " (" + ByteSize$.MODULE$.format(size) + ")";
    }

    public CLIReporter(Repository repo) {
        this.repo = repo;
    }

    public class DiffSideDetails
    implements Product,
    Serializable {
        private final ObjectId id;
        private final String path;
        private final FileMode mode;
        private final Option<Object> size;
        public final /* synthetic */ CLIReporter $outer;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        public ObjectId id() {
            return this.id;
        }

        public String path() {
            return this.path;
        }

        public FileMode mode() {
            return this.mode;
        }

        public Option<Object> size() {
            return this.size;
        }

        public DiffSideDetails copy(ObjectId id, String path, FileMode mode, Option<Object> size) {
            return new DiffSideDetails(this.com$madgag$git$bfg$cleaner$CLIReporter$DiffSideDetails$$$outer(), id, path, mode, size);
        }

        public ObjectId copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.path();
        }

        public FileMode copy$default$3() {
            return this.mode();
        }

        public Option<Object> copy$default$4() {
            return this.size();
        }

        @Override
        public String productPrefix() {
            return "DiffSideDetails";
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.id();
                }
                case 1: {
                    return this.path();
                }
                case 2: {
                    return this.mode();
                }
                case 3: {
                    return this.size();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof DiffSideDetails;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "path";
                }
                case 2: {
                    return "mode";
                }
                case 3: {
                    return "size";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DiffSideDetails)) return false;
            if (((DiffSideDetails)object).com$madgag$git$bfg$cleaner$CLIReporter$DiffSideDetails$$$outer() != this.com$madgag$git$bfg$cleaner$CLIReporter$DiffSideDetails$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            DiffSideDetails diffSideDetails = (DiffSideDetails)x$1;
            ObjectId objectId = this.id();
            ObjectId objectId2 = diffSideDetails.id();
            if (objectId == null) {
                if (objectId2 != null) {
                    return false;
                }
            } else if (!((Object)objectId).equals(objectId2)) return false;
            String string = this.path();
            String string2 = diffSideDetails.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            FileMode fileMode = this.mode();
            FileMode fileMode2 = diffSideDetails.mode();
            if (fileMode == null) {
                if (fileMode2 != null) {
                    return false;
                }
            } else if (!fileMode.equals(fileMode2)) return false;
            Option<Object> option = this.size();
            Option<Object> option2 = diffSideDetails.size();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!diffSideDetails.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ CLIReporter com$madgag$git$bfg$cleaner$CLIReporter$DiffSideDetails$$$outer() {
            return this.$outer;
        }

        public DiffSideDetails(CLIReporter $outer, ObjectId id, String path, FileMode mode, Option<Object> size) {
            this.id = id;
            this.path = path;
            this.mode = mode;
            this.size = size;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$(this);
        }
    }
}

