/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class BEViewer {
    public static final int GUI_EDGE_PADDING = 4;
    public static final int GUI_X_PADDING = 3;
    public static final int GUI_Y_PADDING = 8;
    public static final Dimension BUTTON_SIZE = new Dimension(18, 18);
    public static final int SPLIT_PANE_DIVIDER_SIZE = 4;
    public static final ReportsModel reportsModel = new ReportsModel();
    public static final ReportSelectionManager reportSelectionManager = new ReportSelectionManager();
    public static final FeaturesModel featuresModel = new FeaturesModel(reportSelectionManager, FeaturesModel.ModelType.FEATURES_OR_HISTOGRAM);
    public static final FeaturesModel referencedFeaturesModel = new FeaturesModel(reportSelectionManager, FeaturesModel.ModelType.REFERENCED_FEATURES);
    public static final BookmarksModel bookmarksModel = new BookmarksModel();
    public static final FeatureLineSelectionManager featureLineSelectionManager = new FeatureLineSelectionManager();
    public static final ImageModel imageModel = new ImageModel(featureLineSelectionManager);
    public static final UserHighlightModel userHighlightModel = new UserHighlightModel();
    public static final ImageView imageView = new ImageView(imageModel, userHighlightModel);
    public static final RangeSelectionManager rangeSelectionManager = new RangeSelectionManager();
    public static final ClassificationManager classificationManager = new ClassificationManager();
    public static final ScanSettingsListModel scanSettingsListModel = new ScanSettingsListModel();
    private static final ScanSettingsConsumer scanSettingsConsumer = new ScanSettingsConsumer();
    public static final BEToolbar toolbar = new BEToolbar();
    public static ReportsPane reportsPane;
    public static FeaturesPane featuresPane;
    public static NavigationPane navigationPane;
    public static final boolean isWindows;
    public static final boolean isMac;
    private static JFrame frame;

    public static JFrame getBEWindow() {
        return frame;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Starter(stringArray));
    }

    private BEViewer() {
        UIManager.put("FeaturesUI", BasicFeaturesUI.class.getName());
        UIManager.put("ImageUI", BasicImageUI.class.getName());
        frame = new JFrame("Bulk Extractor Viewer");
        WLog.log("Bulk Extractor Viewer Version 1.5.5");
        WLog.setExceptionHandling();
        if (isMac) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            WLog.log("Error setting native LAF: " + exception);
        }
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BEViewer.doClose();
            }
        });
        this.addComponents(frame.getContentPane());
        frame.setJMenuBar(new BEMenus());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        frame.pack();
        reportsPane.grabTreeFocus();
        frame.setVisible(true);
    }

    public static void closeReport(ReportsModel.ReportTreeNode reportTreeNode) {
        reportsModel.remove(reportTreeNode);
        bookmarksModel.removeAssociatedFeatureLines(reportTreeNode);
        FeatureLine featureLine = featureLineSelectionManager.getFeatureLineSelection();
        if (featureLine.isFromReport(reportTreeNode)) {
            featureLineSelectionManager.setFeatureLineSelection(new FeatureLine());
        }
        imageModel.closeImageReader(reportTreeNode.reportImageFile);
    }

    public static void closeAllReports() {
        bookmarksModel.clear();
        reportsModel.clear();
        featureLineSelectionManager.setFeatureLineSelection(new FeatureLine());
        imageModel.closeAllImageReaders();
        userHighlightModel.setHighlightBytes(new byte[0]);
        userHighlightModel.setHighlightMatchCase(true);
        featuresModel.setFilterBytes(new byte[0]);
        featuresModel.setFilterMatchCase(true);
    }

    public static void printRange() {
        if (!rangeSelectionManager.hasSelection()) {
            throw new RuntimeException("invalid request");
        }
        int n = rangeSelectionManager.getMinSelectionIndex();
        int n2 = rangeSelectionManager.getMaxSelectionIndex();
        if (rangeSelectionManager.getProvider() == imageView) {
            new ImageRangePrinter().printImageRange(imageView, n, n2);
        } else if (rangeSelectionManager.getProvider() == featuresModel) {
            new FeatureRangePrinter().printFeatureRange(featuresModel, n, n2);
        } else if (rangeSelectionManager.getProvider() == referencedFeaturesModel) {
            new FeatureRangePrinter().printFeatureRange(referencedFeaturesModel, n, n2);
        } else {
            throw new RuntimeException("invalid request");
        }
    }

    public static void doClose() {
        BEPreferences.savePreferences();
        System.exit(0);
    }

    private void addComponents(Container container) {
        container.setLayout(new BorderLayout());
        container.add((Component)this.getToolbar(), "North");
        featuresPane = new FeaturesPane();
        navigationPane = new NavigationPane();
        JSplitPane jSplitPane = new JSplitPane(1, true, featuresPane, navigationPane);
        jSplitPane.setBorder(null);
        jSplitPane.setDividerSize(4);
        reportsPane = new ReportsPane();
        JSplitPane jSplitPane2 = new JSplitPane(1, true, reportsPane, jSplitPane);
        jSplitPane2.setDividerSize(4);
        container.add((Component)jSplitPane2, "Center");
    }

    private Container getToolbar() {
        Container container = new Container();
        container.setLayout(new BorderLayout());
        container.add((Component)new Container(), "North");
        container.add((Component)toolbar, "Center");
        return container;
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("windows")) {
            isWindows = true;
            isMac = false;
        } else if (string.startsWith("mac")) {
            isWindows = false;
            isMac = true;
        } else {
            isWindows = false;
            isMac = false;
        }
    }

    private static final class Starter
    implements Runnable {
        private final String[] args;

        private Starter(String[] stringArray) {
            this.args = stringArray;
        }

        @Override
        public void run() {
            new BEViewer();
            BEPreferences.loadPreferences();
            if (this.args.length > 0) {
                BEArgsParser.parseArgs(this.args);
            }
        }
    }
}

