/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Observable;
import java.util.Observer;

public class BulkExtractorVersionReader {
    public static void showVersions() {
        VersionReaderThread versionReaderThread = new VersionReaderThread();
        versionReaderThread.start();
    }

    private static class VersionReaderThread
    extends Thread {
        private BufferedReader readFromProcess;
        ThreadReaderModel stderrThread;

        private VersionReaderThread() {
        }

        @Override
        public void run() {
            try {
                this.readVersion();
            }
            catch (IOException iOException) {
                WError.showError("Error in reading bulk_extractor version.\nBulk_extractor features may not be available during this session.", "bulk_extractor failure", iOException);
            }
        }

        private void readVersion() throws IOException {
            String[] stringArray = new String[]{"bulk_extractor", "-V"};
            String[] stringArray2 = new String[]{};
            Process process = Runtime.getRuntime().exec(stringArray, stringArray2);
            this.readFromProcess = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            this.stderrThread = new ThreadReaderModel(bufferedReader);
            this.stderrThread.addReaderModelChangedListener(new Observer(){

                @Override
                public void update(Observable observable, Object object) {
                    String string = (String)object;
                    WLog.log("BulkExtractorVersionReader stderr: '" + string + "'");
                }
            });
            ThreadAborterTimer threadAborterTimer = new ThreadAborterTimer(process, 10000);
            String string = this.readFromProcess.readLine();
            if (string == null || !string.startsWith("bulk_extractor ")) {
                WError.showErrorLater("Error in reading bulk_extractor version: '" + string + "'", "bulk_extractor failure", null);
            } else {
                String string2 = string.substring("bulk_extractor ".length());
                string2 = string2.trim();
                WLog.log("BulkExtractorVersionReader.readVersion: bulk_extractor version " + string2 + ", Bulk Extractor Viewer version " + "1.5.5");
                WError.showMessageLater("Versions:\nBulk Extractor Viewer: 1.5.5\nbulk_extractor: " + string2, "Version Information");
            }
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                WLog.log("BulkExtractorVersionReader process interrupted");
            }
            try {
                while ((string = this.readFromProcess.readLine()) != null) {
                    WLog.log("BulkExtractorVersionReader stdout: '" + string + "'");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.stderrThread.join();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("unexpected event");
            }
            threadAborterTimer.cancel();
        }
    }
}

