/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FeaturesPane
extends Container {
    private static final int EDGE_PADDING = 4;
    private static final int Y_PADDING = 8;
    private static final long serialVersionUID = 1L;
    private final FeaturesComponent featuresComponent = new FeaturesComponent(BEViewer.featuresModel, BEViewer.rangeSelectionManager);
    private final FeaturesComponent referencedFeaturesComponent = new FeaturesComponent(BEViewer.referencedFeaturesModel, BEViewer.rangeSelectionManager);
    private final JLabel featuresFileL = new JLabel("Feature File");
    private final JCheckBox matchCaseCB = new JCheckBox("Match case");
    private final JTextField filterTF = new JTextField();
    private final FileComponent featuresFileLabel = new FileComponent();
    private final FileComponent referencedFeaturesFileLabel = new FileComponent();
    private final TextComponent referencedFeatureLabel = new TextComponent();
    private final Container featuresContainer = this.getFeaturesContainer();
    private final Container referencedFeaturesContainer = this.getReferencedFeaturesContainer();
    private final JSplitPane featuresSplitPane = new JSplitPane(0, true, this.featuresContainer, this.referencedFeaturesContainer);
    private int featuresSplitPaneDividerLocation = 300;
    private Color defaultFilterTFBackgroundColor = null;

    public FeaturesPane() {
        this.setComponents();
        BEViewer.reportSelectionManager.addReportSelectionManagerChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                FeaturesPane.this.setReferencedFeatureViewVisibility();
                if (BEViewer.reportSelectionManager.getChangeType() == ReportSelectionManager.ChangeType.SELECTION_CHANGED) {
                    FeaturesPane.this.setFeatureFields();
                }
            }
        });
        BEViewer.featuresModel.addFeaturesModelChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                FeaturesPane.this.matchCaseCB.setSelected(BEViewer.featuresModel.isFilterMatchCase());
                byte[] byArray = BEViewer.featuresModel.getFilterBytes();
                if (!UTF8Tools.bytesMatch(byArray, FeaturesPane.this.filterTF.getText().getBytes(UTF8Tools.UTF_8))) {
                    FeaturesPane.this.filterTF.setText(new String(byArray));
                }
                if (byArray.length > 0) {
                    FeaturesPane.this.filterTF.setBackground(Color.YELLOW);
                } else {
                    FeaturesPane.this.filterTF.setBackground(FeaturesPane.this.defaultFilterTFBackgroundColor);
                }
            }
        });
        BEViewer.referencedFeaturesModel.addFeaturesModelChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                byte[] byArray = BEViewer.referencedFeaturesModel.getFilterBytes();
                if (byArray.length == 0) {
                    FeaturesPane.this.referencedFeatureLabel.setComponentText(null);
                } else {
                    if (UTF8Tools.escapedLooksLikeUTF16(byArray)) {
                        byArray = UTF8Tools.utf16To8Basic(byArray);
                    }
                    FeaturesPane.this.referencedFeatureLabel.setComponentText(new String(byArray));
                }
            }
        });
    }

    private void setFeatureFields() {
        if (BEViewer.reportSelectionManager.getReportSelectionType() == ReportSelectionManager.ReportSelectionType.HISTOGRAM) {
            this.featuresFileL.setText("Histogram File");
            this.featuresFileLabel.setFile(BEViewer.reportSelectionManager.getHistogramFile());
            this.referencedFeaturesFileLabel.setFile(BEViewer.reportSelectionManager.getReferencedFeaturesFile());
        } else {
            this.featuresFileL.setText("Feature File");
            this.featuresFileLabel.setFile(BEViewer.reportSelectionManager.getFeaturesFile());
            this.referencedFeaturesFileLabel.setFile(null);
        }
    }

    private void setReferencedFeatureViewVisibility() {
        boolean bl;
        boolean bl2 = this.featuresSplitPane.getBottomComponent() == null;
        boolean bl3 = BEViewer.reportSelectionManager.isRequestHideReferencedFeatureView();
        boolean bl4 = bl = BEViewer.reportSelectionManager.getReportSelectionType() != ReportSelectionManager.ReportSelectionType.HISTOGRAM;
        if (!(!bl2 || bl3 && bl)) {
            this.featuresSplitPane.setBottomComponent(this.referencedFeaturesContainer);
            this.featuresSplitPane.setDividerLocation(this.featuresSplitPaneDividerLocation);
            this.featuresSplitPane.setDividerSize(4);
        } else if (!bl2 && bl3 && bl) {
            this.featuresSplitPane.setBottomComponent(null);
            this.featuresSplitPaneDividerLocation = this.featuresSplitPane.getDividerLocation();
            this.featuresSplitPane.setDividerSize(0);
        }
    }

    private void setComponents() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.getFilterControls(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.featuresSplitPane.setBorder(null);
        this.featuresSplitPane.setResizeWeight(0.5);
        this.featuresSplitPane.setDividerSize(4);
        this.add((Component)this.featuresSplitPane, gridBagConstraints);
    }

    private Container getFeaturesContainer() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        container.add((Component)this.getFeatureStats(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.featuresComponent, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(330, 300));
        jScrollPane.getViewport().setScrollMode(0);
        container.add((Component)jScrollPane, gridBagConstraints);
        return container;
    }

    private Container getFeatureStats() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        container.add((Component)this.featuresFileL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        container.add((Component)this.featuresFileLabel, gridBagConstraints);
        return container;
    }

    private Container getReferencedFeaturesContainer() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        container.add((Component)this.getReferencedFeatureStats(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.referencedFeaturesComponent, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(330, 300));
        jScrollPane.getViewport().setScrollMode(0);
        container.add((Component)jScrollPane, gridBagConstraints);
        return container;
    }

    private Container getReferencedFeatureStats() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        container.add((Component)new JLabel("Referenced Feature File"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        container.add((Component)this.referencedFeaturesFileLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        container.add((Component)new JLabel("Referenced Feature"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        container.add((Component)this.referencedFeatureLabel, gridBagConstraints);
        return container;
    }

    private Container getFilterControls() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        container.add((Component)new JLabel("Feature Filter"), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.matchCaseCB.setFocusable(false);
        this.matchCaseCB.setSelected(BEViewer.featuresModel.isFilterMatchCase());
        this.matchCaseCB.setRequestFocusEnabled(false);
        this.matchCaseCB.setToolTipText("Match case in filter text");
        Dimension dimension = new Dimension(this.matchCaseCB.getPreferredSize().width, new JLabel((String)" ").getPreferredSize().height);
        this.matchCaseCB.setMinimumSize(dimension);
        this.matchCaseCB.setPreferredSize(dimension);
        this.matchCaseCB.setMaximumSize(dimension);
        this.matchCaseCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.featuresModel.setFilterMatchCase(FeaturesPane.this.matchCaseCB.isSelected());
                FeaturesPane.this.filterTF.requestFocusInWindow();
            }
        });
        container.add((Component)this.matchCaseCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.defaultFilterTFBackgroundColor = this.filterTF.getBackground();
        this.filterTF.setToolTipText("Type text to filter Features");
        this.filterTF.getDocument().addDocumentListener(new DocumentListener(){

            private void setFeatureFilter() {
                BEViewer.featuresModel.setFilterBytes(FeaturesPane.this.filterTF.getText().getBytes(UTF8Tools.UTF_8));
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.setFeatureFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.setFeatureFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.setFeatureFilter();
            }
        });
        container.add((Component)this.filterTF, gridBagConstraints);
        return container;
    }
}

