/*
 * Decompiled with CFR 0.152.
 */
public final class ForensicPath {
    public static String getAdjustedPath(String string, long l) {
        int n = ForensicPath.getOffsetIndex(string);
        if (n == 0) {
            return String.valueOf(l);
        }
        String string2 = string.substring(0, n);
        String string3 = string2 + String.valueOf(l);
        return string3;
    }

    public static String getAlignedPath(String string) {
        long l = ForensicPath.getOffset(string);
        long l2 = l - l % 4096L;
        return ForensicPath.getAdjustedPath(string, l2);
    }

    public static long getOffset(String string) {
        long l;
        if (string == "") {
            return 0L;
        }
        int n = ForensicPath.getOffsetIndex(string);
        String string2 = string.substring(n);
        try {
            l = Long.parseLong(string2);
        }
        catch (Exception exception) {
            WLog.log("malformed forensic path: '" + string + "'");
            l = 0L;
        }
        return l;
    }

    private static int getForensicPathIndex(String string) {
        int n = string.length();
        if (n < 3) {
            return 0;
        }
        for (int i = 0; i < n - 3; ++i) {
            if (string.charAt(i) != '\udbc0' || string.charAt(i + 1) != '\udc1c' || string.charAt(i + 2) != '-') continue;
            return i + 3;
        }
        return 0;
    }

    private static int getOffsetIndex(String string) {
        int n = string.lastIndexOf(45);
        if (n == -1) {
            return 0;
        }
        return n + 1;
    }

    public static boolean hasFilename(String string) {
        return ForensicPath.getForensicPathIndex(string) > 0;
    }

    public static String getFilename(String string) {
        int n = ForensicPath.getForensicPathIndex(string);
        if (n == 0) {
            return "";
        }
        String string2 = string.substring(0, n - 2 - 1);
        return string2;
    }

    public static String getPathWithoutFilename(String string) {
        int n = ForensicPath.getForensicPathIndex(string);
        if (n == 0) {
            return string;
        }
        String string2 = string.substring(n);
        return string2;
    }

    public static String getPrintablePath(String string, boolean bl) {
        if (!bl) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("-");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            try {
                long l = Long.parseLong(string2);
                String string3 = Long.toString(l, 16);
                stringBuffer.append(string3);
            }
            catch (Exception exception) {
                stringBuffer.append(string2);
            }
            if (i == stringArray.length - 1) continue;
            stringBuffer.append('-');
        }
        return stringBuffer.toString();
    }

    public static boolean isHistogram(String string) {
        if (string.length() > 4 && string.charAt(0) == 'n' && string.charAt(1) == '=') {
            int n;
            for (n = 2; n < string.length() && string.charAt(n) >= '0' && string.charAt(n) <= '9'; ++n) {
            }
            if (string.charAt(n) == '\t') {
                return true;
            }
        }
        return false;
    }
}

