/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.HashMap;
import java.util.Observer;
import java.util.Set;

public class ImageReaderManager {
    private final ModelChangedNotifier<Object> imageReaderManagerChangedNotifier = new ModelChangedNotifier();
    private HashMap<File, ImageReader> readers = new HashMap();

    private ImageReader getImageReader(File file) {
        ImageReader imageReader;
        if (file == null) {
            return new ImageReader(null);
        }
        if (this.readers.size() == 20) {
            this.closeAll();
        }
        if (this.readers.containsKey(file)) {
            imageReader = this.readers.get(file);
            if (imageReader.isValid()) {
                return imageReader;
            }
            imageReader.close();
        }
        WLog.log("ImageReaderManager allocating reader " + this.readers.size() + " for file " + file.toString());
        imageReader = new ImageReader(file);
        this.readers.put(file, imageReader);
        return imageReader;
    }

    public ImageReader.ImageReaderResponse read(File file, String string, long l) {
        ImageReader imageReader = this.getImageReader(file);
        return imageReader.read(string, l);
    }

    public void close(File file) {
        ImageReader imageReader = this.readers.get(file);
        if (imageReader == null) {
            return;
        }
        imageReader.close();
        this.readers.remove(file);
        this.imageReaderManagerChangedNotifier.fireModelChanged(null);
    }

    public void closeAll() {
        Set<File> set = this.readers.keySet();
        for (File file : set) {
            ImageReader imageReader = this.readers.get(file);
            imageReader.close();
        }
        this.readers.clear();
        this.imageReaderManagerChangedNotifier.fireModelChanged(null);
    }

    public void addImageReaderManagerChangedListener(Observer observer) {
        this.imageReaderManagerChangedNotifier.addObserver(observer);
    }

    public void removeImageReaderManagerChangedListener(Observer observer) {
        this.imageReaderManagerChangedNotifier.deleteObserver(observer);
    }
}

