/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;

public class ImageReaderThread
extends Thread {
    private File imageFile;
    private String forensicPath;
    private int numBytes;
    public ImageReader.ImageReaderResponse response;
    public boolean isDone = false;
    private final ImageModel imageModel;
    private final ImageReaderManager imageReaderManager;

    public ImageReaderThread(ImageModel imageModel, ImageReaderManager imageReaderManager, File file, String string, int n) {
        this.imageModel = imageModel;
        this.imageReaderManager = imageReaderManager;
        this.imageFile = file;
        this.forensicPath = string;
        this.numBytes = n;
    }

    @Override
    public void run() {
        try {
            this.response = this.imageReaderManager.read(this.imageFile, this.forensicPath, this.numBytes);
            if (this.response.bytes.length == 0) {
                WError.showMessageLater("No bytes were read from the image path, likely because the image file is not aviailable.", "No Data");
            }
        }
        catch (Exception exception) {
            WError.showErrorLater("Unable to read the Image.\nfile: '" + this.imageFile + "' forensic path: '" + this.forensicPath + "'", "Error reading Image", exception);
            this.response = new ImageReader.ImageReaderResponse(new byte[0], 0L);
        }
        this.isDone = true;
        this.imageModel.manageModelChanges();
    }
}

