/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Observer;

public class RangeSelectionManager {
    private final ModelChangedNotifier<Object> selectionManagerChangedNotifier = new ModelChangedNotifier();
    private static final Clipboard selectionClipboard = Toolkit.getDefaultToolkit().getSystemSelection();
    private static final Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private CopyableLineInterface provider = null;
    private int minSelectionIndex = -1;
    private int maxSelectionIndex = -1;
    private Transferable transferableSelection = new StringSelection("");

    public void setRange(CopyableLineInterface copyableLineInterface, int n, int n2) {
        if (copyableLineInterface == this.provider && n == this.minSelectionIndex && n2 == this.maxSelectionIndex) {
            return;
        }
        this.provider = copyableLineInterface;
        this.minSelectionIndex = n;
        this.maxSelectionIndex = n2;
        this.transferableSelection = this.getTransferableSelection();
        RangeSelectionManager.setSelectionClipboard(this.transferableSelection);
        this.selectionManagerChangedNotifier.fireModelChanged(null);
    }

    public void clear() {
        this.setRange(null, -1, -1);
    }

    public CopyableLineInterface getProvider() {
        return this.provider;
    }

    public int getMinSelectionIndex() {
        return this.minSelectionIndex;
    }

    public int getMaxSelectionIndex() {
        return this.maxSelectionIndex;
    }

    public boolean hasSelection() {
        return this.provider != null && this.minSelectionIndex > -1;
    }

    public Transferable getSelection() {
        return this.transferableSelection;
    }

    private Transferable getTransferableSelection() {
        if (this.provider == null || this.minSelectionIndex == -1) {
            return new StringSelection("");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.minSelectionIndex; i <= this.maxSelectionIndex; ++i) {
            stringBuffer.append(this.provider.getCopyableLine(i));
            stringBuffer.append("\n");
        }
        String string = stringBuffer.toString();
        StringSelection stringSelection = new StringSelection(string);
        return stringSelection;
    }

    public static void setSystemClipboard(Transferable transferable) {
        try {
            systemClipboard.setContents(transferable, null);
        }
        catch (IllegalStateException illegalStateException) {
            WError.showError("Copy Log to System Clipboard failed.", "BEViewer System Clipboard error", illegalStateException);
        }
    }

    public static void setSelectionClipboard(Transferable transferable) {
        try {
            if (selectionClipboard != null) {
                selectionClipboard.setContents(transferable, null);
            }
        }
        catch (IllegalStateException illegalStateException) {
            WError.showError("Copy Log to Selection Clipboard failed.", "BEViewer Selection Clipboard error", illegalStateException);
        }
    }

    public void addRangeSelectionManagerChangedListener(Observer observer) {
        this.selectionManagerChangedNotifier.addObserver(observer);
    }

    public void removeRangeSelectionManagerChangedListener(Observer observer) {
        this.selectionManagerChangedNotifier.deleteObserver(observer);
    }
}

