/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ReportsModel {
    private final RootTreeNode rootTreeNode = new RootTreeNode();
    private DefaultTreeModel treeModel = new DefaultTreeModel(this.rootTreeNode);
    private DefaultTreeSelectionModel treeSelectionModel = new DefaultTreeSelectionModel();
    private boolean includeStoplistFiles;
    private boolean includeEmptyFiles;
    private static final FileFilter featuresFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (!file.canRead() || file.isDirectory()) {
                return false;
            }
            String string = file.getName();
            if (!string.endsWith(".txt")) {
                return false;
            }
            return !string.startsWith("wordlist_");
        }
    };
    private static final Comparator<File> fileComparator = new Comparator<File>(){

        @Override
        public int compare(File file, File file2) {
            return file.compareTo(file2);
        }
    };

    private static boolean filesEqual(File file, File file2) {
        if (file == null && file2 == null) {
            return true;
        }
        return file != null && file.equals(file2);
    }

    public ReportsModel() {
        this.treeSelectionModel.setSelectionMode(1);
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public TreeSelectionModel getTreeSelectionModel() {
        return this.treeSelectionModel;
    }

    public void setIncludeStoplistFiles(boolean bl) {
        this.includeStoplistFiles = bl;
        this.setFiles();
    }

    public boolean isIncludeStoplistFiles() {
        return this.includeStoplistFiles;
    }

    public void setIncludeEmptyFiles(boolean bl) {
        this.includeEmptyFiles = bl;
        this.setFiles();
    }

    public boolean isIncludeEmptyFiles() {
        return this.includeEmptyFiles;
    }

    private void setFiles() {
        Enumeration<ReportTreeNode> enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ReportTreeNode reportTreeNode = enumeration.nextElement();
            reportTreeNode.setFiles(this.includeStoplistFiles, this.includeEmptyFiles);
        }
        this.treeModel.reload();
    }

    public void addReport(File file, File file2) {
        int n = this.rootTreeNode.getIndex(file, file2);
        if (n == -1) {
            ReportTreeNode reportTreeNode = new ReportTreeNode(this.rootTreeNode, file, file2);
            this.rootTreeNode.add(reportTreeNode);
            reportTreeNode.setFiles(this.includeStoplistFiles, this.includeEmptyFiles);
            n = this.rootTreeNode.getIndex(reportTreeNode);
            int[] nArray = new int[]{n};
            this.treeModel.nodesWereInserted(this.rootTreeNode, nArray);
        } else {
            WError.showError("Report already opened for directory '" + file + "'\nReport Image file '" + file2 + "'.", "Already Open", null);
        }
    }

    public void remove(ReportTreeNode reportTreeNode) {
        int n = this.rootTreeNode.getIndex(reportTreeNode);
        if (n != -1) {
            TreePath treePath = this.treeSelectionModel.getSelectionPath();
            ReportTreeNode reportTreeNode2 = ReportsModel.getReportTreeNodeFromTreePath(treePath);
            if (reportTreeNode == reportTreeNode2) {
                this.treeSelectionModel.clearSelection();
                this.treeSelectionModel.setSelectionPath(null);
            }
            this.rootTreeNode.removeElementAt(n);
            int[] nArray = new int[]{n};
            Object[] objectArray = new TreeNode[]{reportTreeNode};
            this.treeModel.nodesWereRemoved(this.rootTreeNode, nArray, objectArray);
        } else {
            WLog.log("ReportsModel.RootTreeNode.remove: Report not present: " + reportTreeNode);
        }
    }

    public void clear() {
        int n = this.rootTreeNode.removeAllElements();
        if (n > 0) {
            this.treeModel.reload();
            this.treeSelectionModel.clearSelection();
        } else {
            WLog.log("ReportsModel.RootTreeNode.removeAllElements: Already empty");
        }
    }

    public Enumeration<ReportTreeNode> elements() {
        return this.rootTreeNode.children();
    }

    public TreePath getTreePath(File file, File file2) {
        int n = this.rootTreeNode.getIndex(file, file2);
        if (n != -1) {
            ReportTreeNode reportTreeNode = this.rootTreeNode.getChildAt(n);
            return new TreePath(new Object[]{reportTreeNode.parent, reportTreeNode});
        }
        return null;
    }

    public TreePath getSelectedTreePath() {
        return this.treeSelectionModel.getSelectionPath();
    }

    public static ReportTreeNode getReportTreeNodeFromTreePath(TreePath treePath) {
        if (treePath != null && treePath.getPathCount() >= 2) {
            return (ReportTreeNode)treePath.getPathComponent(1);
        }
        return null;
    }

    public static FeaturesFileTreeNode getFeaturesFileTreeNodeFromTreePath(TreePath treePath) {
        if (treePath != null && treePath.getPathCount() == 3) {
            return (FeaturesFileTreeNode)treePath.getPathComponent(2);
        }
        return null;
    }

    public static class FeaturesFileTreeNode
    implements TreeNode {
        private final ReportTreeNode parent;
        public final File featuresFile;

        public FeaturesFileTreeNode(ReportTreeNode reportTreeNode, File file) {
            this.parent = reportTreeNode;
            this.featuresFile = file;
        }

        public Enumeration<FeaturesFileTreeNode> children() {
            return null;
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }

        @Override
        public TreeNode getChildAt(int n) {
            return null;
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            return -1;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    }

    public static class ReportTreeNode
    implements TreeNode {
        public final RootTreeNode parent;
        public final File featuresDirectory;
        public final File reportImageFile;
        private final Vector<FeaturesFileTreeNode> featuresFileNodes = new Vector();

        public ReportTreeNode(RootTreeNode rootTreeNode, File file, File file2) {
            this.parent = rootTreeNode;
            this.featuresDirectory = file;
            this.reportImageFile = file2;
        }

        private void setFiles(boolean bl, boolean bl2) {
            File[] fileArray;
            if (this.featuresDirectory == null) {
                fileArray = new File[]{};
            } else {
                fileArray = this.featuresDirectory.listFiles(featuresFileFilter);
                if (fileArray == null) {
                    WLog.log("ReportsModel.ReportTreeNode: unexpected invalid null featuresFiles.");
                    fileArray = new File[]{};
                }
            }
            Arrays.sort(fileArray, fileComparator);
            this.featuresFileNodes.clear();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!bl && fileArray[i].getName().endsWith("_stoplist.txt") || !bl2 && fileArray[i].length() == 0L) continue;
                this.featuresFileNodes.add(new FeaturesFileTreeNode(this, fileArray[i]));
            }
        }

        public String toString() {
            if (this.reportImageFile == null) {
                return "features directory: " + this.featuresDirectory + ", no image file, features files size: " + this.featuresFileNodes.size();
            }
            return "features directory: " + this.featuresDirectory + ", report image file: " + this.reportImageFile + ", features files size: " + this.featuresFileNodes.size();
        }

        public Enumeration<FeaturesFileTreeNode> children() {
            return this.featuresFileNodes.elements();
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public FeaturesFileTreeNode getChildAt(int n) {
            return this.featuresFileNodes.get(n);
        }

        @Override
        public int getChildCount() {
            return this.featuresFileNodes.size();
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            FeaturesFileTreeNode featuresFileTreeNode = (FeaturesFileTreeNode)treeNode;
            if (featuresFileTreeNode == null) {
                return -1;
            }
            Enumeration<FeaturesFileTreeNode> enumeration = this.featuresFileNodes.elements();
            while (enumeration.hasMoreElements()) {
                FeaturesFileTreeNode featuresFileTreeNode2 = enumeration.nextElement();
                if (!ReportsModel.filesEqual(featuresFileTreeNode.featuresFile, featuresFileTreeNode2.featuresFile)) continue;
                return this.featuresFileNodes.indexOf(featuresFileTreeNode2);
            }
            return -1;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    public static class RootTreeNode
    implements TreeNode {
        private final Vector<ReportTreeNode> reportTreeNodes = new Vector();

        public int getIndex(File file, File file2) {
            File file3 = new File(file, "report.xml");
            if (!file3.isFile()) {
                WLog.log("ReportsModel.getIndex: unexpected missing file " + file3);
            }
            Enumeration<ReportTreeNode> enumeration = this.reportTreeNodes.elements();
            while (enumeration.hasMoreElements()) {
                ReportTreeNode reportTreeNode = enumeration.nextElement();
                if (!ReportsModel.filesEqual(reportTreeNode.featuresDirectory, file) || !ReportsModel.filesEqual(reportTreeNode.reportImageFile, file2)) continue;
                return this.reportTreeNodes.indexOf(reportTreeNode);
            }
            return -1;
        }

        private void add(ReportTreeNode reportTreeNode) {
            if (this.getIndex(reportTreeNode) == -1) {
                this.reportTreeNodes.add(reportTreeNode);
            } else {
                WLog.log("ReportsModel.RootTreeNode.add: Node already present: " + reportTreeNode);
            }
        }

        private void removeElementAt(int n) {
            if (n != -1) {
                this.reportTreeNodes.removeElementAt(n);
            }
        }

        private int removeAllElements() {
            int n = this.reportTreeNodes.size();
            this.reportTreeNodes.removeAllElements();
            return n;
        }

        public Enumeration<ReportTreeNode> children() {
            return this.reportTreeNodes.elements();
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public ReportTreeNode getChildAt(int n) {
            return this.reportTreeNodes.get(n);
        }

        @Override
        public int getChildCount() {
            return this.reportTreeNodes.size();
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            return this.reportTreeNodes.indexOf(treeNode);
        }

        @Override
        public TreeNode getParent() {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }
}

