/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class ScanSettings {
    public ImageSourceType imageSourceType;
    public String inputImage;
    public String outdir;
    public boolean useBannerFile;
    public String bannerFile;
    public boolean useAlertlistFile;
    public String alertlistFile;
    public boolean useStoplistFile;
    public String stoplistFile;
    public boolean useFindRegexTextFile;
    public String findRegexTextFile;
    public boolean useFindRegexText;
    public String findRegexText;
    public boolean useRandomSampling;
    public String randomSampling;
    public boolean useContextWindowSize;
    public String contextWindowSize;
    public boolean usePageSize;
    public String pageSize;
    public boolean useMarginSize;
    public String marginSize;
    public boolean useBlockSize;
    public String blockSize;
    public boolean useNumThreads;
    public String numThreads;
    public boolean useMaxRecursionDepth;
    public String maxRecursionDepth;
    public boolean useMaxWait;
    public String maxWait;
    public boolean useStartProcessingAt;
    public String startProcessingAt;
    public boolean useProcessRange;
    public String processRange;
    public boolean useAddOffset;
    public String addOffset;
    public boolean useStartOnPageNumber;
    public String startOnPageNumber;
    public boolean useDebugNumber;
    public String debugNumber;
    public boolean useEraseOutputDirectory;
    public boolean usePluginDirectories;
    public String pluginDirectories;
    public boolean useSettableOptions;
    public String settableOptions;
    public Vector<BulkExtractorScanListReader.Scanner> scanners;
    public boolean validTokens = true;

    public ScanSettings() {
        this.imageSourceType = ImageSourceType.IMAGE_FILE;
        this.inputImage = "";
        this.outdir = "";
        this.useBannerFile = false;
        this.bannerFile = "";
        this.useAlertlistFile = false;
        this.alertlistFile = "";
        this.useStoplistFile = false;
        this.stoplistFile = "";
        this.useFindRegexTextFile = false;
        this.findRegexTextFile = "";
        this.useFindRegexText = false;
        this.findRegexText = "";
        this.useRandomSampling = false;
        this.randomSampling = "";
        this.useContextWindowSize = false;
        this.contextWindowSize = "16";
        this.usePageSize = false;
        this.pageSize = "16777216";
        this.useMarginSize = false;
        this.marginSize = "4194304";
        this.useBlockSize = false;
        this.blockSize = "512";
        this.useNumThreads = false;
        this.numThreads = Integer.toString(Runtime.getRuntime().availableProcessors());
        this.useMaxRecursionDepth = false;
        this.maxRecursionDepth = "7";
        this.useMaxWait = false;
        this.maxWait = "60";
        this.useStartProcessingAt = false;
        this.startProcessingAt = "";
        this.useProcessRange = false;
        this.processRange = "";
        this.useAddOffset = false;
        this.addOffset = "";
        this.useStartOnPageNumber = false;
        this.startOnPageNumber = "0";
        this.useDebugNumber = false;
        this.debugNumber = "1";
        this.useEraseOutputDirectory = false;
        this.usePluginDirectories = false;
        this.pluginDirectories = "";
        this.useSettableOptions = false;
        this.settableOptions = "";
        try {
            this.scanners = BulkExtractorScanListReader.readScanList(WScanBoxedControls.usePluginDirectoriesCB.isSelected(), WScanBoxedControls.pluginDirectoriesTF.getText());
        }
        catch (IOException iOException) {
            WError.showError("Error in obtaining list of scanners from bulk_extractor.\nBulk_extractor is not available during this session.\nIs bulk_extractor installed?", "bulk_extractor failure", iOException);
            this.scanners = new Vector();
        }
    }

    public ScanSettings(ScanSettings scanSettings) {
        this.imageSourceType = scanSettings.imageSourceType;
        this.inputImage = scanSettings.inputImage;
        this.outdir = scanSettings.outdir;
        this.useBannerFile = scanSettings.useBannerFile;
        this.bannerFile = scanSettings.bannerFile;
        this.useAlertlistFile = scanSettings.useAlertlistFile;
        this.alertlistFile = scanSettings.alertlistFile;
        this.useStoplistFile = scanSettings.useStoplistFile;
        this.stoplistFile = scanSettings.stoplistFile;
        this.useFindRegexTextFile = scanSettings.useFindRegexTextFile;
        this.findRegexTextFile = scanSettings.findRegexTextFile;
        this.useFindRegexText = scanSettings.useFindRegexText;
        this.findRegexText = scanSettings.findRegexText;
        this.useRandomSampling = scanSettings.useRandomSampling;
        this.randomSampling = scanSettings.randomSampling;
        this.useContextWindowSize = scanSettings.useContextWindowSize;
        this.contextWindowSize = scanSettings.contextWindowSize;
        this.usePageSize = scanSettings.usePageSize;
        this.pageSize = scanSettings.pageSize;
        this.useMarginSize = scanSettings.useMarginSize;
        this.marginSize = scanSettings.marginSize;
        this.useBlockSize = scanSettings.useBlockSize;
        this.blockSize = scanSettings.blockSize;
        this.useNumThreads = scanSettings.useNumThreads;
        this.numThreads = scanSettings.numThreads;
        this.useMaxRecursionDepth = scanSettings.useMaxRecursionDepth;
        this.maxRecursionDepth = scanSettings.maxRecursionDepth;
        this.useMaxWait = scanSettings.useMaxWait;
        this.maxWait = scanSettings.maxWait;
        this.useStartProcessingAt = scanSettings.useStartProcessingAt;
        this.startProcessingAt = scanSettings.startProcessingAt;
        this.useProcessRange = scanSettings.useProcessRange;
        this.processRange = scanSettings.processRange;
        this.useAddOffset = scanSettings.useAddOffset;
        this.addOffset = scanSettings.addOffset;
        this.useStartOnPageNumber = scanSettings.useStartOnPageNumber;
        this.startOnPageNumber = scanSettings.startOnPageNumber;
        this.useDebugNumber = scanSettings.useDebugNumber;
        this.debugNumber = scanSettings.debugNumber;
        this.useEraseOutputDirectory = scanSettings.useEraseOutputDirectory;
        this.usePluginDirectories = scanSettings.usePluginDirectories;
        this.pluginDirectories = scanSettings.pluginDirectories;
        this.useSettableOptions = scanSettings.useSettableOptions;
        this.settableOptions = scanSettings.settableOptions;
        this.scanners = new Vector();
        for (BulkExtractorScanListReader.Scanner scanner : scanSettings.scanners) {
            this.scanners.add(new BulkExtractorScanListReader.Scanner(scanner.name, scanner.defaultUseScanner, scanner.useScanner));
        }
    }

    public ScanSettings(String string) {
        this();
        String[] stringArray = string.split("\\s+");
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length) {
            boolean bl;
            String string2;
            String string3 = stringArray[n];
            String string4 = string2 = n + 1 < stringArray.length ? stringArray[n + 1] : "";
            if (n == 0 && string3.equals("bulk_extractor")) {
                ++n;
                continue;
            }
            if (string3.equals("-o")) {
                this.outdir = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-b")) {
                this.useBannerFile = true;
                this.bannerFile = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-r")) {
                this.useAlertlistFile = true;
                this.alertlistFile = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-w")) {
                this.useStoplistFile = true;
                this.stoplistFile = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-F")) {
                this.useFindRegexTextFile = true;
                this.findRegexTextFile = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-s")) {
                this.useRandomSampling = true;
                this.randomSampling = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-C")) {
                this.useContextWindowSize = true;
                this.contextWindowSize = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-G")) {
                this.usePageSize = true;
                this.pageSize = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-g")) {
                this.useMarginSize = true;
                this.marginSize = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-B")) {
                this.useBlockSize = true;
                this.blockSize = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-j")) {
                this.useNumThreads = true;
                this.numThreads = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-M")) {
                this.useMaxRecursionDepth = true;
                this.maxRecursionDepth = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-m")) {
                this.useMaxWait = true;
                this.maxWait = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-Y")) {
                if (string2.indexOf(45) == -1) {
                    this.useStartProcessingAt = true;
                    this.startProcessingAt = string2;
                    n += 2;
                    continue;
                }
                this.useProcessRange = true;
                this.processRange = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-A")) {
                this.useAddOffset = true;
                this.addOffset = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-z")) {
                this.useStartOnPageNumber = true;
                this.startOnPageNumber = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-d")) {
                this.useDebugNumber = true;
                this.debugNumber = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-Z")) {
                this.useEraseOutputDirectory = true;
                ++n;
                continue;
            }
            if (string3.equals("-P")) {
                this.usePluginDirectories = true;
                this.pluginDirectories = string2;
                n += 2;
                continue;
            }
            if (string3.equals("-S")) {
                this.useSettableOptions = true;
                if (this.settableOptions.length() > 0) {
                    this.settableOptions = this.settableOptions + "|";
                }
                this.settableOptions = this.settableOptions + string2;
                n += 2;
                continue;
            }
            if (string3.equals("-x")) {
                bl = false;
                for (BulkExtractorScanListReader.Scanner scanner : this.scanners) {
                    if (!string2.equals(scanner.name)) continue;
                    scanner.useScanner = false;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.validTokens = false;
                    WLog.log("ScanSettings -x parse error: no scanner named '" + string2 + "'");
                    WError.showError("Invalid scanner name '" + string2 + "'", "Scanner deselection error", null);
                }
                n += 2;
                continue;
            }
            if (string3.equals("-e")) {
                bl = false;
                for (BulkExtractorScanListReader.Scanner scanner : this.scanners) {
                    if (!string2.equals(scanner.name)) continue;
                    scanner.useScanner = true;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.validTokens = false;
                    WLog.log("ScanSettings -e parse error: no scanner named '" + string2 + "'");
                    WError.showError("Invalid scanner name '" + string2 + "'", "Scanner selection error", null);
                }
                n += 2;
                continue;
            }
            if (string3.equals("-R")) {
                this.imageSourceType = ImageSourceType.DIRECTORY_OF_FILES;
                ++n;
                continue;
            }
            this.inputImage = string3;
            ++n2;
            ++n;
        }
        if (n != stringArray.length || n2 != 1) {
            this.validTokens = false;
            WLog.log("ScanSettings input error: '" + string + "'");
            WLog.log("ScanSettings command length: " + stringArray.length + ", parameter count: " + n2);
            WError.showError("Invalid scan settings text: '" + string + "'", "Scan Settings Text error", null);
        }
    }

    public String[] getCommandArray() {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        vector.add("bulk_extractor");
        if (!this.outdir.equals("")) {
            vector.add("-o");
            vector.add(this.outdir);
        }
        if (this.useBannerFile) {
            vector.add("-b");
            vector.add(this.bannerFile);
        }
        if (this.useAlertlistFile) {
            vector.add("-r");
            vector.add(this.alertlistFile);
        }
        if (this.useStoplistFile) {
            vector.add("-w");
            vector.add(this.stoplistFile);
        }
        if (this.useFindRegexTextFile) {
            vector.add("-F");
            vector.add(this.findRegexTextFile);
        }
        if (this.useFindRegexText) {
            vector.add("-f");
            vector.add(this.findRegexText);
        }
        if (this.useRandomSampling) {
            vector.add("-s");
            vector.add(this.randomSampling);
        }
        if (this.useContextWindowSize) {
            vector.add("-C");
            vector.add(this.contextWindowSize);
        }
        if (this.usePageSize) {
            vector.add("-G");
            vector.add(this.pageSize);
        }
        if (this.useMarginSize) {
            vector.add("-g");
            vector.add(this.marginSize);
        }
        if (this.useBlockSize) {
            vector.add("-B");
            vector.add(this.blockSize);
        }
        if (this.useNumThreads) {
            vector.add("-j");
            vector.add(this.numThreads);
        }
        if (this.useMaxRecursionDepth) {
            vector.add("-M");
            vector.add(this.maxRecursionDepth);
        }
        if (this.useMaxWait) {
            vector.add("-m");
            vector.add(this.maxWait);
        }
        if (this.useStartProcessingAt) {
            vector.add("-Y");
            vector.add(this.startProcessingAt);
        }
        if (this.useProcessRange) {
            vector.add("-Y");
            vector.add(this.processRange);
        }
        if (this.useAddOffset) {
            vector.add("-A");
            vector.add(this.addOffset);
        }
        if (this.useStartOnPageNumber) {
            vector.add("-z");
            vector.add(this.startOnPageNumber);
        }
        if (this.useDebugNumber) {
            vector.add("-d" + this.debugNumber);
        }
        if (this.useEraseOutputDirectory) {
            vector.add("-Z");
        }
        if (this.usePluginDirectories && this.pluginDirectories.length() > 0) {
            for (String string : stringArray = this.pluginDirectories.split("\\|")) {
                vector.add("-P");
                vector.add(string);
            }
        }
        if (this.useSettableOptions && this.settableOptions.length() > 0) {
            for (String string : stringArray = this.settableOptions.split("\\|")) {
                vector.add("-S");
                vector.add(string);
            }
        }
        for (BulkExtractorScanListReader.Scanner scanner : this.scanners) {
            if (scanner.defaultUseScanner) {
                if (scanner.useScanner) continue;
                vector.add("-x");
                vector.add(scanner.name);
                continue;
            }
            if (!scanner.useScanner) continue;
            vector.add("-e");
            vector.add(scanner.name);
        }
        if (this.imageSourceType == ImageSourceType.DIRECTORY_OF_FILES) {
            vector.add("-R");
        }
        vector.add(this.inputImage);
        stringArray = vector.toArray(new String[0]);
        return stringArray;
    }

    public String getCommandString() {
        String[] stringArray = this.getCommandArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            if (stringArray[i].indexOf(" ") >= 0) {
                stringBuffer.append("\"" + stringArray[i] + "\"");
                continue;
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private boolean isInt(String string, String string2) {
        try {
            int n = Integer.valueOf(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            WError.showError("Invalid input for " + string2 + ": " + string, "Settings error", null);
            return false;
        }
    }

    public boolean validateSomeSettings() {
        File file;
        File file2;
        File file3;
        File file4 = new File(this.inputImage);
        if (this.imageSourceType == ImageSourceType.IMAGE_FILE) {
            if (file4.isDirectory() || !file4.canRead()) {
                WError.showError("The image file provided,\n'" + this.inputImage + "', is not valid." + "\nPlease verify that this path exists and is accessible.", "Settings error", null);
                return false;
            }
        } else if (this.imageSourceType == ImageSourceType.RAW_DEVICE) {
            if (file4.isDirectory() || !file4.canRead()) {
                WError.showError("The image device provided,\n'" + this.inputImage + "', is not valid." + "\nPlease verify that this path exists and is accessible.", "Settings error", null);
                return false;
            }
        } else if (!(this.imageSourceType != ImageSourceType.DIRECTORY_OF_FILES || file4.isDirectory() && file4.canRead())) {
            WError.showError("The input image directory provided,\n'" + this.inputImage + "', is not valid." + "\nPlease verify that this path exists and is accessible.", "Settings error", null);
            return false;
        }
        if ((file3 = (file2 = new File(this.outdir)).getParentFile()) == null || !file3.isDirectory()) {
            WError.showError("The folder to contain Output Feature directory\n'" + file2 + "' is not valid." + "\nPlease verify that this folder exists and is accessible.", "Settings error", null);
            return false;
        }
        if (!(!this.useBannerFile || (file = new File(this.bannerFile)).isFile() && file.canRead())) {
            WError.showError("The banner file \n'" + this.bannerFile + "' is not valid." + "\nPlease verify that this file exists and is accessible.", "Settings error", null);
            return false;
        }
        if (!(!this.useAlertlistFile || (file = new File(this.alertlistFile)).isFile() && file.canRead())) {
            WError.showError("The alert list file \n'" + this.alertlistFile + "' is not valid." + "\nPlease verify that this file exists and is accessible.", "Settings error", null);
            return false;
        }
        if (!(!this.useStoplistFile || (file = new File(this.stoplistFile)).isFile() && file.canRead())) {
            WError.showError("The alert list file \n'" + this.stoplistFile + "' is not valid." + "\nPlease verify that this file exists and is accessible.", "Settings error", null);
            return false;
        }
        if (!(!this.useFindRegexTextFile || (file = new File(this.findRegexTextFile)).isFile() && file.canRead())) {
            WError.showError("The alert list file \n'" + this.findRegexTextFile + "' is not valid." + "\nPlease verify that this file exists and is accessible.", "Settings error", null);
            return false;
        }
        if (this.useContextWindowSize && !this.isInt(this.contextWindowSize, "context window size")) {
            return false;
        }
        if (this.usePageSize && !this.isInt(this.pageSize, "page size")) {
            return false;
        }
        if (this.useMarginSize && !this.isInt(this.marginSize, "margin size")) {
            return false;
        }
        if (this.useBlockSize && !this.isInt(this.blockSize, "block size")) {
            return false;
        }
        if (this.useNumThreads && !this.isInt(this.numThreads, "number of threads")) {
            return false;
        }
        if (this.useMaxRecursionDepth && !this.isInt(this.maxRecursionDepth, "maximum recursion depth")) {
            return false;
        }
        if (this.useStartOnPageNumber && !this.isInt(this.startOnPageNumber, "start on page number")) {
            return false;
        }
        return !this.useDebugNumber || this.isInt(this.debugNumber, "debug mode number");
    }
}

