/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.concurrent.locks.LockSupport;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class ScanSettingsConsumer
extends Thread {
    private static ScanSettingsConsumer scanSettingsConsumer;
    private static boolean isPaused;

    public ScanSettingsConsumer() {
        scanSettingsConsumer = this;
        this.start();
    }

    public static synchronized void pauseConsumer(boolean bl) {
        if (bl) {
            isPaused = true;
        } else {
            isPaused = false;
            LockSupport.unpark(scanSettingsConsumer);
        }
    }

    @Override
    public void run() {
        BEViewer.scanSettingsListModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                LockSupport.unpark(scanSettingsConsumer);
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
        while (true) {
            Process process;
            ScanSettings scanSettings;
            LockSupport.park();
            if (isPaused || (scanSettings = BEViewer.scanSettingsListModel.remove()) == null) continue;
            WLog.log("ScanSettingsConsumer starting bulk_extractor run: '" + scanSettings.getCommandString() + "'");
            try {
                process = Runtime.getRuntime().exec(scanSettings.getCommandArray());
            }
            catch (IOException iOException) {
                WError.showErrorLater("bulk_extractor Scanner failed to start command\n'" + scanSettings.getCommandString() + "'", "bulk_extractor failure", iOException);
                LockSupport.unpark(scanSettingsConsumer);
                continue;
            }
            WScanProgress.openWindow(scanSettings, process);
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("unexpected event");
            }
            LockSupport.unpark(scanSettingsConsumer);
        }
    }

    static {
        isPaused = false;
    }
}

