/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class WLog
implements Thread.UncaughtExceptionHandler {
    private static final WLog wLog = new WLog();
    private static final StringBuffer textBuffer = new StringBuffer();
    private static JDialog window;
    private static JTextArea textArea;

    private WLog() {
    }

    public static void setExceptionHandling() {
        Thread.setDefaultUncaughtExceptionHandler(wLog);
    }

    public static void log(String string) {
        textBuffer.append(string);
        textBuffer.append("\n");
        System.out.println(string);
        if (window != null && window.isVisible()) {
            WLog.setLogText();
        }
    }

    private static void setLogText() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                textArea.setText(textBuffer.toString());
            }
        });
    }

    public static void logBytes(String string, byte[] byArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append(", size: " + byArray.length);
        stringBuffer.append("\n");
        for (n = 0; n < byArray.length; ++n) {
            byte by = byArray[n];
            if (by > 31 && by < 127) {
                stringBuffer.append((char)by);
                continue;
            }
            stringBuffer.append(".");
        }
        stringBuffer.append("\n");
        for (n = 0; n < byArray.length; ++n) {
            stringBuffer.append(String.format("%1$02x", byArray[n]));
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n");
        String string2 = stringBuffer.toString();
        textBuffer.append(string2);
        System.out.println(string2);
        if (window != null && window.isVisible()) {
            WLog.setLogText();
        }
    }

    public static void logThrowable(Throwable throwable) {
        textBuffer.append(throwable.toString());
        textBuffer.append("\n");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            textBuffer.append(stackTraceElementArray[i]);
            textBuffer.append("\n");
        }
        throwable.printStackTrace();
        if (window != null && window.isVisible()) {
            WLog.setLogText();
        }
    }

    public static void clearLog() {
        textBuffer.delete(0, textBuffer.length());
        if (window != null && window.isVisible()) {
            WLog.setLogText();
        }
    }

    public static String getLog() {
        return textBuffer.toString();
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        textBuffer.append("Error:\n");
        textBuffer.append(thread.toString());
        textBuffer.append("\n");
        WLog.logThrowable(throwable);
        WLog.setVisible();
    }

    public static void setVisible() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (window == null) {
                    window = new JDialog((Frame)null, "Bulk Extractor Viewer Log", false);
                    Container container = window.getContentPane();
                    container.setLayout(new GridBagLayout());
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = 0;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.fill = 1;
                    textArea = new JTextArea();
                    textArea.setEditable(false);
                    JScrollPane jScrollPane = new JScrollPane(textArea, 20, 30);
                    jScrollPane.setPreferredSize(new Dimension(700, 700));
                    container.add((Component)jScrollPane, gridBagConstraints);
                    window.pack();
                }
                WLog.setLogText();
                window.setLocationRelativeTo(BEViewer.getBEWindow());
                window.setVisible(true);
            }
        });
    }
}

