/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class WProgress {
    public static final long DELAY = 300L;
    private JDialog window;
    private JProgressBar bar;
    private boolean active = false;
    private boolean visible = false;
    private long startTime = 0L;
    private int percent = 0;
    private final Runnable showWindow = new Runnable(){

        @Override
        public void run() {
            WProgress.this.window.setLocationRelativeTo(BEViewer.getBEWindow());
            WProgress.this.window.setVisible(true);
        }
    };
    private final Runnable hideWindow = new Runnable(){

        @Override
        public void run() {
            WProgress.this.window.setVisible(false);
        }
    };
    private final Runnable setProgressIndicator = new Runnable(){

        @Override
        public void run() {
            WProgress.this.bar.setValue(WProgress.this.percent);
        }
    };

    public WProgress(String string) {
        this.window = new JDialog(BEViewer.getBEWindow(), string, false);
        this.window.setFocusableWindowState(false);
        this.window.setDefaultCloseOperation(0);
        Container container = this.window.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.bar = new JProgressBar(0, 100);
        this.bar.setStringPainted(true);
        this.bar.setMinimumSize(this.bar.getPreferredSize());
        container.add((Component)this.bar, gridBagConstraints);
        this.window.pack();
    }

    public synchronized void setActive(boolean bl) {
        if (this.active == bl) {
            throw new RuntimeException("invalid usage: active: " + bl);
        }
        this.active = bl;
        if (bl) {
            this.startTime = new Date().getTime();
        } else {
            bl = false;
            this.visible = false;
            SwingUtilities.invokeLater(this.hideWindow);
            long l = new Date().getTime() - this.startTime;
            WLog.log("WProgress time in ms: " + l);
        }
    }

    public synchronized void setPercent(int n) {
        if (!this.active) {
            throw new RuntimeException("invalid usage");
        }
        if (!this.visible) {
            long l = new Date().getTime();
            if (l > this.startTime + 300L) {
                this.visible = true;
                this.percent = n;
                SwingUtilities.invokeLater(this.setProgressIndicator);
                SwingUtilities.invokeLater(this.showWindow);
            }
        } else if (n != this.percent) {
            this.percent = n;
            SwingUtilities.invokeLater(this.setProgressIndicator);
        }
    }
}

