/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WScanBoxedControls {
    public final Component component;
    public static final JCheckBox usePluginDirectoriesCB = new JCheckBox("Use Plugin Directories");
    public static final JTextField pluginDirectoriesTF = new JTextField();
    private final FileChooserButton pluginDirectoriesChooserB = new FileChooserButton(WScan.getWScanWindow(), "Select Plugin Directories", 1, pluginDirectoriesTF);
    private final JCheckBox useSettableOptionsCB = new JCheckBox("Use Settable Options");
    private final JTextField settableOptionsTF = new JTextField();

    public WScanBoxedControls() {
        this.component = this.buildContainer();
        this.wireActions();
    }

    private Component buildContainer() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Scanner Controls"));
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        WScan.addOptionalFileLine(jPanel, n++, usePluginDirectoriesCB, pluginDirectoriesTF, this.pluginDirectoriesChooserB);
        WScan.addOptionalTextLine(jPanel, n++, this.useSettableOptionsCB, this.settableOptionsTF, 250);
        usePluginDirectoriesCB.setToolTipText("Path to plugin directories, separated by vertical bar character \"|\"");
        this.useSettableOptionsCB.setToolTipText("Provide settable options in form <key>=<value> separated by vertical bar character \"|\"");
        return jPanel;
    }

    public void setScanSettings(ScanSettings scanSettings) {
        usePluginDirectoriesCB.setSelected(scanSettings.usePluginDirectories);
        pluginDirectoriesTF.setEnabled(scanSettings.usePluginDirectories);
        pluginDirectoriesTF.setText(scanSettings.pluginDirectories);
        this.pluginDirectoriesChooserB.setEnabled(scanSettings.usePluginDirectories);
        this.useSettableOptionsCB.setSelected(scanSettings.useSettableOptions);
        this.settableOptionsTF.setEnabled(scanSettings.useSettableOptions);
        this.settableOptionsTF.setText(scanSettings.settableOptions);
    }

    public void getScanSettings(ScanSettings scanSettings) {
        scanSettings.usePluginDirectories = usePluginDirectoriesCB.isSelected();
        scanSettings.pluginDirectories = pluginDirectoriesTF.getText();
        scanSettings.useSettableOptions = this.useSettableOptionsCB.isSelected();
        scanSettings.settableOptions = this.settableOptionsTF.getText();
    }

    private void wireActions() {
        GetUIValuesActionListener getUIValuesActionListener = new GetUIValuesActionListener();
        usePluginDirectoriesCB.addActionListener(getUIValuesActionListener);
        this.useSettableOptionsCB.addActionListener(getUIValuesActionListener);
    }

    private class GetUIValuesActionListener
    implements ActionListener {
        private GetUIValuesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScanSettings scanSettings = new ScanSettings();
            WScanBoxedControls.this.getScanSettings(scanSettings);
            WScanBoxedControls.this.setScanSettings(scanSettings);
        }
    }
}

