/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WScanBoxedParallelizing {
    public final Component component;
    private final JCheckBox useStartProcessingAtCB = new JCheckBox("Use start processing at offset");
    private final JCheckBox useProcessRangeCB = new JCheckBox("Use process range offset o1-o2");
    private final JCheckBox useAddOffsetCB = new JCheckBox("Use add offset to reported feature offsets");
    private final JTextField startProcessingAtTF = new JTextField();
    private final JTextField processRangeTF = new JTextField();
    private final JTextField addOffsetTF = new JTextField();

    public WScanBoxedParallelizing() {
        this.component = this.buildContainer();
        this.wireActions();
    }

    private Component buildContainer() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Parallelizing"));
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        WScan.addOptionalTextLine(jPanel, n++, this.useStartProcessingAtCB, this.startProcessingAtTF, 50);
        WScan.addOptionalTextLine(jPanel, n++, this.useProcessRangeCB, this.processRangeTF, 100);
        WScan.addOptionalTextLine(jPanel, n++, this.useAddOffsetCB, this.addOffsetTF, 50);
        this.useStartProcessingAtCB.setToolTipText("Start processing at offset, may use K, M, or G, for example 1G");
        this.useProcessRangeCB.setToolTipText("Process range, may use K, M, or G, for example 4G-7G");
        this.useAddOffsetCB.setToolTipText("Add offset to feature offset, may use K, M, or G, for example 1G");
        return jPanel;
    }

    public void setScanSettings(ScanSettings scanSettings) {
        this.useStartProcessingAtCB.setSelected(scanSettings.useStartProcessingAt);
        this.useProcessRangeCB.setSelected(scanSettings.useProcessRange);
        this.useAddOffsetCB.setSelected(scanSettings.useAddOffset);
        this.startProcessingAtTF.setEnabled(scanSettings.useStartProcessingAt);
        this.processRangeTF.setEnabled(scanSettings.useProcessRange);
        this.addOffsetTF.setEnabled(scanSettings.useAddOffset);
        this.startProcessingAtTF.setText(scanSettings.startProcessingAt);
        this.processRangeTF.setText(scanSettings.processRange);
        this.addOffsetTF.setText(scanSettings.addOffset);
    }

    public void getScanSettings(ScanSettings scanSettings) {
        scanSettings.useStartProcessingAt = this.useStartProcessingAtCB.isSelected();
        scanSettings.useProcessRange = this.useProcessRangeCB.isSelected();
        scanSettings.useAddOffset = this.useAddOffsetCB.isSelected();
        scanSettings.startProcessingAt = this.startProcessingAtTF.getText();
        scanSettings.processRange = this.processRangeTF.getText();
        scanSettings.addOffset = this.addOffsetTF.getText();
    }

    private void wireActions() {
        final GetUIValuesActionListener getUIValuesActionListener = new GetUIValuesActionListener();
        this.useStartProcessingAtCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WScanBoxedParallelizing.this.useStartProcessingAtCB.isSelected()) {
                    WScanBoxedParallelizing.this.useProcessRangeCB.setSelected(false);
                    getUIValuesActionListener.actionPerformed(null);
                }
            }
        });
        this.useProcessRangeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WScanBoxedParallelizing.this.useProcessRangeCB.isSelected()) {
                    WScanBoxedParallelizing.this.useStartProcessingAtCB.setSelected(false);
                    getUIValuesActionListener.actionPerformed(null);
                }
            }
        });
        this.useAddOffsetCB.addActionListener(getUIValuesActionListener);
    }

    private class GetUIValuesActionListener
    implements ActionListener {
        private GetUIValuesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScanSettings scanSettings = new ScanSettings();
            WScanBoxedParallelizing.this.getScanSettings(scanSettings);
            WScanBoxedParallelizing.this.setScanSettings(scanSettings);
        }
    }
}

