/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class WScanBoxedRequired {
    public final Component component;
    private final JRadioButton imageFileChooserRB = new JRadioButton("Image File");
    private final JRadioButton rawDeviceChooserRB = new JRadioButton("Raw Device");
    private final JRadioButton directoryOfFilesChooserRB = new JRadioButton("Directory of Files");
    private final ButtonGroup imageChooserGroup = new ButtonGroup();
    private final JLabel inputImageL = new JLabel();
    private final JTextField inputImageTF = new JTextField();
    private final JButton inputImageChooserB = new JButton("\u2026");
    private final JTextField outdirTF = new JTextField();
    private final JButton outdirChooserB = new JButton("\u2026");

    public WScanBoxedRequired() {
        this.component = this.buildContainer();
        this.wireActions();
    }

    private Component buildContainer() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Required Parameters"));
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 21;
        jPanel.add(this.buildScanTypeContainer(), gridBagConstraints);
        this.addFileLine(jPanel, n++, this.inputImageL, this.inputImageTF, this.inputImageChooserB);
        this.inputImageChooserB.setToolTipText("Select the image path");
        this.addFileLine(jPanel, n++, new JLabel("Output Feature Directory"), this.outdirTF, this.outdirChooserB);
        this.outdirChooserB.setToolTipText("Select the Output Feature Directory");
        this.imageChooserGroup.add(this.imageFileChooserRB);
        this.imageChooserGroup.add(this.rawDeviceChooserRB);
        this.imageChooserGroup.add(this.directoryOfFilesChooserRB);
        return jPanel;
    }

    private Component buildScanTypeContainer() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        jPanel.add((Component)new JLabel("Scan:"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        jPanel.add((Component)this.imageFileChooserRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        if (BEViewer.isWindows || BEViewer.isMac) {
            this.rawDeviceChooserRB.setEnabled(false);
            this.rawDeviceChooserRB.setToolTipText("(not available on Windows or Mac)");
        }
        jPanel.add((Component)this.rawDeviceChooserRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        jPanel.add((Component)this.directoryOfFilesChooserRB, gridBagConstraints);
        return jPanel;
    }

    public void setScanSettings(ScanSettings scanSettings) {
        this.setImageSourceType(scanSettings.imageSourceType);
        this.inputImageTF.setText(scanSettings.inputImage);
        this.outdirTF.setText(scanSettings.outdir);
    }

    public void getScanSettings(ScanSettings scanSettings) {
        if (this.imageFileChooserRB.isSelected()) {
            scanSettings.imageSourceType = ImageSourceType.IMAGE_FILE;
        } else if (this.rawDeviceChooserRB.isSelected()) {
            scanSettings.imageSourceType = ImageSourceType.RAW_DEVICE;
        } else if (this.directoryOfFilesChooserRB.isSelected()) {
            scanSettings.imageSourceType = ImageSourceType.DIRECTORY_OF_FILES;
        } else {
            throw new RuntimeException("bad setting");
        }
        scanSettings.inputImage = this.inputImageTF.getText();
        scanSettings.outdir = this.outdirTF.getText();
    }

    private void setImageSourceType(ImageSourceType imageSourceType) {
        this.inputImageL.setText(imageSourceType.toString());
        this.inputImageTF.setText("");
        if (imageSourceType == ImageSourceType.IMAGE_FILE) {
            this.imageFileChooserRB.setSelected(true);
            this.inputImageChooserB.setToolTipText("select the Image File to scan");
        } else if (imageSourceType == ImageSourceType.RAW_DEVICE) {
            this.rawDeviceChooserRB.setSelected(true);
            this.inputImageChooserB.setToolTipText("select the Raw Device to scan");
        } else if (imageSourceType == ImageSourceType.DIRECTORY_OF_FILES) {
            this.directoryOfFilesChooserRB.setSelected(true);
            this.inputImageChooserB.setToolTipText("select the directory of files to scan");
        } else {
            throw new RuntimeException("bad image source");
        }
    }

    private void wireActions() {
        this.imageFileChooserRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WScanBoxedRequired.this.setImageSourceType(ImageSourceType.IMAGE_FILE);
            }
        });
        this.rawDeviceChooserRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WScanBoxedRequired.this.setImageSourceType(ImageSourceType.RAW_DEVICE);
            }
        });
        this.directoryOfFilesChooserRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WScanBoxedRequired.this.setImageSourceType(ImageSourceType.DIRECTORY_OF_FILES);
            }
        });
        this.inputImageChooserB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WScanBoxedRequired.this.imageFileChooserRB.isSelected()) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setDialogTitle("Image File to Extract Features From");
                    jFileChooser.setDialogType(0);
                    jFileChooser.setFileSelectionMode(0);
                    jFileChooser.setSelectedFile(new File(WScanBoxedRequired.this.inputImageTF.getText()));
                    jFileChooser.setFileFilter(ImageFileType.imageFileFilter);
                    if (jFileChooser.showOpenDialog(WScan.getWScanWindow()) == 0) {
                        String string = jFileChooser.getSelectedFile().getAbsolutePath();
                        WScanBoxedRequired.this.inputImageTF.setText(string);
                    }
                } else if (WScanBoxedRequired.this.directoryOfFilesChooserRB.isSelected()) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setDialogTitle("Directory of Files to Recursively Extract Features From");
                    jFileChooser.setDialogType(0);
                    jFileChooser.setFileSelectionMode(1);
                    jFileChooser.setSelectedFile(new File(WScanBoxedRequired.this.inputImageTF.getText()));
                    if (jFileChooser.showOpenDialog(WScan.getWScanWindow()) == 0) {
                        String string = jFileChooser.getSelectedFile().getAbsolutePath();
                        WScanBoxedRequired.this.inputImageTF.setText(string);
                    }
                } else if (WScanBoxedRequired.this.rawDeviceChooserRB.isSelected()) {
                    WRawDeviceChooser.openWindow();
                    String string = WRawDeviceChooser.getSelection();
                    if (string != null) {
                        WScanBoxedRequired.this.inputImageTF.setText(string);
                    }
                }
            }
        });
        this.outdirChooserB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle("Output Feature Directory");
                jFileChooser.setDialogType(1);
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setSelectedFile(new File(WScanBoxedRequired.this.outdirTF.getText()));
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                if (jFileChooser.showDialog(WScan.getWScanWindow(), "Select") == 0) {
                    String string = jFileChooser.getSelectedFile().getAbsolutePath();
                    WScanBoxedRequired.this.outdirTF.setText(string);
                }
            }
        });
    }

    private void addFileLine(Container container, int n, JComponent jComponent, JTextField jTextField, JButton jButton) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 21;
        container.add((Component)jComponent, gridBagConstraints);
        jTextField.setMinimumSize(new Dimension(250, jTextField.getPreferredSize().height));
        jTextField.setPreferredSize(new Dimension(250, jTextField.getPreferredSize().height));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 21;
        container.add((Component)jTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        container.add((Component)jButton, gridBagConstraints);
    }
}

