/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WScanBoxedTuning {
    public final Component component;
    private final JCheckBox useContextWindowSizeCB = new JCheckBox("Use Context Window Size");
    private final JCheckBox usePageSizeCB = new JCheckBox("Use Page Size");
    private final JCheckBox useMarginSizeCB = new JCheckBox("Use Margin Size");
    private final JCheckBox useBlockSizeCB = new JCheckBox("Use Block Size");
    private final JCheckBox useNumThreadsCB = new JCheckBox("Use Number of Threads");
    private final JCheckBox useMaxRecursionDepthCB = new JCheckBox("Use Maximum Recursion Depth");
    private final JCheckBox useMaxWaitCB = new JCheckBox("Use Wait Time");
    private final JTextField contextWindowSizeTF = new JTextField();
    private final JTextField pageSizeTF = new JTextField();
    private final JTextField marginSizeTF = new JTextField();
    private final JTextField blockSizeTF = new JTextField();
    private final JTextField numThreadsTF = new JTextField();
    private final JTextField maxRecursionDepthTF = new JTextField();
    private final JTextField maxWaitTF = new JTextField();

    public WScanBoxedTuning() {
        this.component = this.buildContainer();
        this.wireActions();
    }

    private Component buildContainer() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Tuning Parameters"));
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        WScan.addOptionalTextLine(jPanel, n++, this.useContextWindowSizeCB, this.contextWindowSizeTF, 50);
        WScan.addOptionalTextLine(jPanel, n++, this.usePageSizeCB, this.pageSizeTF, 100);
        WScan.addOptionalTextLine(jPanel, n++, this.useMarginSizeCB, this.marginSizeTF, 100);
        WScan.addOptionalTextLine(jPanel, n++, this.useBlockSizeCB, this.blockSizeTF, 50);
        WScan.addOptionalTextLine(jPanel, n++, this.useNumThreadsCB, this.numThreadsTF, 50);
        WScan.addOptionalTextLine(jPanel, n++, this.useMaxRecursionDepthCB, this.maxRecursionDepthTF, 50);
        WScan.addOptionalTextLine(jPanel, n++, this.useMaxWaitCB, this.maxWaitTF, 50);
        this.useNumThreadsCB.setToolTipText("Number of Analysis Threads");
        this.useMaxWaitCB.setToolTipText("Time, in minutes, to wait for memory starvation");
        return jPanel;
    }

    public void setScanSettings(ScanSettings scanSettings) {
        this.useContextWindowSizeCB.setSelected(scanSettings.useContextWindowSize);
        this.usePageSizeCB.setSelected(scanSettings.usePageSize);
        this.useMarginSizeCB.setSelected(scanSettings.useMarginSize);
        this.useBlockSizeCB.setSelected(scanSettings.useBlockSize);
        this.useNumThreadsCB.setSelected(scanSettings.useNumThreads);
        this.useMaxRecursionDepthCB.setSelected(scanSettings.useMaxRecursionDepth);
        this.useMaxWaitCB.setSelected(scanSettings.useMaxWait);
        this.contextWindowSizeTF.setEnabled(scanSettings.useContextWindowSize);
        this.pageSizeTF.setEnabled(scanSettings.usePageSize);
        this.marginSizeTF.setEnabled(scanSettings.useMarginSize);
        this.blockSizeTF.setEnabled(scanSettings.useBlockSize);
        this.numThreadsTF.setEnabled(scanSettings.useNumThreads);
        this.maxRecursionDepthTF.setEnabled(scanSettings.useMaxRecursionDepth);
        this.maxWaitTF.setEnabled(scanSettings.useMaxWait);
        this.contextWindowSizeTF.setText(scanSettings.contextWindowSize);
        this.pageSizeTF.setText(scanSettings.pageSize);
        this.marginSizeTF.setText(scanSettings.marginSize);
        this.blockSizeTF.setText(scanSettings.blockSize);
        this.numThreadsTF.setText(scanSettings.numThreads);
        this.maxRecursionDepthTF.setText(scanSettings.maxRecursionDepth);
        this.maxWaitTF.setText(scanSettings.maxWait);
    }

    public void getScanSettings(ScanSettings scanSettings) {
        scanSettings.useContextWindowSize = this.useContextWindowSizeCB.isSelected();
        scanSettings.usePageSize = this.usePageSizeCB.isSelected();
        scanSettings.useMarginSize = this.useMarginSizeCB.isSelected();
        scanSettings.useBlockSize = this.useBlockSizeCB.isSelected();
        scanSettings.useNumThreads = this.useNumThreadsCB.isSelected();
        scanSettings.useMaxRecursionDepth = this.useMaxRecursionDepthCB.isSelected();
        scanSettings.useMaxWait = this.useMaxWaitCB.isSelected();
        scanSettings.contextWindowSize = this.contextWindowSizeTF.getText();
        scanSettings.pageSize = this.pageSizeTF.getText();
        scanSettings.marginSize = this.marginSizeTF.getText();
        scanSettings.blockSize = this.blockSizeTF.getText();
        scanSettings.numThreads = this.numThreadsTF.getText();
        scanSettings.maxRecursionDepth = this.maxRecursionDepthTF.getText();
        scanSettings.maxWait = this.maxWaitTF.getText();
    }

    private void wireActions() {
        GetUIValuesActionListener getUIValuesActionListener = new GetUIValuesActionListener();
        this.useContextWindowSizeCB.addActionListener(getUIValuesActionListener);
        this.usePageSizeCB.addActionListener(getUIValuesActionListener);
        this.useMarginSizeCB.addActionListener(getUIValuesActionListener);
        this.useBlockSizeCB.addActionListener(getUIValuesActionListener);
        this.useNumThreadsCB.addActionListener(getUIValuesActionListener);
        this.useMaxRecursionDepthCB.addActionListener(getUIValuesActionListener);
        this.useMaxWaitCB.addActionListener(getUIValuesActionListener);
    }

    private class GetUIValuesActionListener
    implements ActionListener {
        private GetUIValuesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScanSettings scanSettings = new ScanSettings();
            WScanBoxedTuning.this.getScanSettings(scanSettings);
            WScanBoxedTuning.this.setScanSettings(scanSettings);
        }
    }
}

