/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class BEMenus
extends JMenuBar {
    private final long serialVersionUID = 1L;
    private JCheckBoxMenuItem cbShowToolbar;
    private JRadioButtonMenuItem rbFeatureText;
    private JRadioButtonMenuItem rbTypedText;
    private JRadioButtonMenuItem rbTextView;
    private JRadioButtonMenuItem rbHexView;
    private JRadioButtonMenuItem rbDecimal;
    private JRadioButtonMenuItem rbHex;
    private JRadioButtonMenuItem rbReferencedFeaturesVisible;
    private JRadioButtonMenuItem rbReferencedFeaturesCollapsible;
    private JCheckBoxMenuItem cbShowStoplistFiles;
    private JCheckBoxMenuItem cbShowEmptyFiles;
    private JMenuItem miPrintFeature;
    private JMenuItem miClearBookmarks;
    private JMenuItem miExportBookmarks;
    private JMenuItem miCopy;
    private JMenuItem miClose;
    private JMenuItem miCloseAll;
    private JMenuItem miAddBookmark;
    private JMenuItem miManageBookmarks;
    private JMenuItem miPanToStart;
    private JMenuItem miPanToEnd;
    private JMenuItem miShowReportFile;
    private JMenuItem miShowLog;
    private final int KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private final KeyStroke KEYSTROKE_O = KeyStroke.getKeyStroke(79, this.KEY_MASK);
    private final KeyStroke KEYSTROKE_Q = KeyStroke.getKeyStroke(81, this.KEY_MASK);
    private final KeyStroke KEYSTROKE_C = KeyStroke.getKeyStroke(67, this.KEY_MASK);
    private final KeyStroke KEYSTROKE_R = KeyStroke.getKeyStroke(82, this.KEY_MASK);
    private final KeyStroke KEYSTROKE_A = KeyStroke.getKeyStroke(65, this.KEY_MASK);
    private final KeyStroke KEYSTROKE_M = KeyStroke.getKeyStroke(77, this.KEY_MASK);
    private final KeyStroke KEYSTROKE_B = KeyStroke.getKeyStroke(66, this.KEY_MASK);
    private final KeyStroke KEYSTROKE_L = KeyStroke.getKeyStroke(76, this.KEY_MASK);

    public BEMenus() {
        JMenu jMenu = new JMenu("File");
        this.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Open Report\u2026", BEIcons.OPEN_REPORT_16);
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(this.KEYSTROKE_O);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WOpen.openWindow();
            }
        });
        this.miClose = new JMenuItem("Close Selected Report");
        jMenu.add(this.miClose);
        this.miClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath = BEViewer.reportsModel.getSelectedTreePath();
                ReportsModel.ReportTreeNode reportTreeNode = ReportsModel.getReportTreeNodeFromTreePath(treePath);
                if (reportTreeNode != null) {
                    BEViewer.closeReport(reportTreeNode);
                } else {
                    WLog.log("BEMenus Close Report failure");
                }
            }
        });
        this.miClose.setEnabled(false);
        BEViewer.reportsModel.getTreeSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = BEViewer.reportsModel.getSelectedTreePath();
                ReportsModel.ReportTreeNode reportTreeNode = ReportsModel.getReportTreeNodeFromTreePath(treePath);
                if (reportTreeNode != null) {
                    BEMenus.this.miClose.setEnabled(true);
                } else {
                    BEMenus.this.miClose.setEnabled(false);
                }
            }
        });
        this.miCloseAll = new JMenuItem("Close all Reports");
        jMenu.add(this.miCloseAll);
        this.miCloseAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.closeAllReports();
            }
        });
        this.miCloseAll.setEnabled(false);
        BEViewer.reportsModel.getTreeModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                this.setCloseAllVisibility();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                this.setCloseAllVisibility();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                this.setCloseAllVisibility();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                this.setCloseAllVisibility();
            }

            private void setCloseAllVisibility() {
                Enumeration<ReportsModel.ReportTreeNode> enumeration = BEViewer.reportsModel.elements();
                BEMenus.this.miCloseAll.setEnabled(enumeration.hasMoreElements());
            }
        });
        jMenu.addSeparator();
        this.miExportBookmarks = new JMenuItem("Export Bookmarks\u2026", BEIcons.EXPORT_BOOKMARKS_16);
        jMenu.add(this.miExportBookmarks);
        this.miExportBookmarks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WManageBookmarks.saveBookmarks();
            }
        });
        BEViewer.bookmarksModel.bookmarksComboBoxModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                BEMenus.this.miExportBookmarks.setEnabled(!BEViewer.bookmarksModel.isEmpty());
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                BEMenus.this.miExportBookmarks.setEnabled(!BEViewer.bookmarksModel.isEmpty());
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                BEMenus.this.miExportBookmarks.setEnabled(!BEViewer.bookmarksModel.isEmpty());
            }
        });
        this.miExportBookmarks.setEnabled(false);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Import Work Settings\u2026");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WImportWorkSettings.openWindow();
            }
        });
        jMenuItem = new JMenuItem("Export Work Settings\u2026");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WExportWorkSettings.openWindow();
            }
        });
        jMenu.addSeparator();
        this.miPrintFeature = new JMenuItem("Print Range\u2026", BEIcons.PRINT_FEATURE_16);
        this.miPrintFeature.setEnabled(false);
        jMenu.add(this.miPrintFeature);
        this.miPrintFeature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.printRange();
            }
        });
        BEViewer.rangeSelectionManager.addRangeSelectionManagerChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                BEMenus.this.miPrintFeature.setEnabled(BEViewer.rangeSelectionManager.hasSelection());
            }
        });
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Quit", BEIcons.EXIT_16);
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(this.KEYSTROKE_Q);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.doClose();
            }
        });
        JMenu jMenu2 = new JMenu("Edit");
        this.add(jMenu2);
        this.miCopy = new JMenuItem("Copy", BEIcons.COPY_16);
        this.miCopy.setEnabled(false);
        jMenu2.add(this.miCopy);
        this.miCopy.setAccelerator(this.KEYSTROKE_C);
        this.miCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RangeSelectionManager.setSystemClipboard(BEViewer.rangeSelectionManager.getSelection());
            }
        });
        BEViewer.rangeSelectionManager.addRangeSelectionManagerChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                BEMenus.this.miCopy.setEnabled(BEViewer.rangeSelectionManager.hasSelection());
            }
        });
        jMenu2.addSeparator();
        this.miClearBookmarks = new JMenuItem("Clear Bookmarks");
        jMenu2.add(this.miClearBookmarks);
        this.miClearBookmarks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.bookmarksModel.clear();
            }
        });
        this.miClearBookmarks.setEnabled(false);
        BEViewer.bookmarksModel.bookmarksComboBoxModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                BEMenus.this.miClearBookmarks.setEnabled(!BEViewer.bookmarksModel.isEmpty());
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                BEMenus.this.miClearBookmarks.setEnabled(!BEViewer.bookmarksModel.isEmpty());
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                BEMenus.this.miClearBookmarks.setEnabled(!BEViewer.bookmarksModel.isEmpty());
            }
        });
        JMenu jMenu3 = new JMenu("View");
        this.add(jMenu3);
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this.cbShowToolbar = new JCheckBoxMenuItem("Toolbar");
        this.cbShowToolbar.setSelected(true);
        jMenu3.add(this.cbShowToolbar);
        this.cbShowToolbar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.toolbar.setVisible(BEMenus.this.cbShowToolbar.isSelected());
            }
        });
        BEViewer.toolbar.addToolbarChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                BEMenus.this.cbShowToolbar.setSelected(BEViewer.toolbar.isVisible());
            }
        });
        JMenu jMenu4 = new JMenu("Image Format");
        jMenu3.add(jMenu4);
        this.rbTextView = new JRadioButtonMenuItem("Text");
        buttonGroup.add(this.rbTextView);
        jMenu4.add(this.rbTextView);
        this.rbTextView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.imageView.setLineFormat(ImageLine.LineFormat.TEXT_FORMAT);
            }
        });
        this.rbHexView = new JRadioButtonMenuItem("Hex");
        buttonGroup.add(this.rbHexView);
        jMenu4.add(this.rbHexView);
        this.rbHexView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.imageView.setLineFormat(ImageLine.LineFormat.HEX_FORMAT);
            }
        });
        BEViewer.imageView.addImageViewChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                ImageLine.LineFormat lineFormat = BEViewer.imageView.getLineFormat();
                if (lineFormat == ImageLine.LineFormat.TEXT_FORMAT) {
                    BEMenus.this.rbTextView.setSelected(true);
                } else if (lineFormat == ImageLine.LineFormat.HEX_FORMAT) {
                    BEMenus.this.rbHexView.setSelected(true);
                } else {
                    throw new RuntimeException("invalid image format source");
                }
            }
        });
        JMenu jMenu5 = new JMenu("Forensic Path Numeric Base");
        jMenu3.add(jMenu5);
        this.rbDecimal = new JRadioButtonMenuItem("Decimal");
        buttonGroup2.add(this.rbDecimal);
        jMenu5.add(this.rbDecimal);
        this.rbDecimal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.featuresModel.setUseHexPath(false);
                BEViewer.referencedFeaturesModel.setUseHexPath(false);
                BEViewer.imageView.setUseHexPath(false);
                BEViewer.bookmarksModel.fireViewChanged();
            }
        });
        this.rbHex = new JRadioButtonMenuItem("Hexadecimal");
        buttonGroup2.add(this.rbHex);
        jMenu5.add(this.rbHex);
        this.rbHex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.featuresModel.setUseHexPath(true);
                BEViewer.referencedFeaturesModel.setUseHexPath(true);
                BEViewer.imageView.setUseHexPath(true);
                BEViewer.bookmarksModel.fireViewChanged();
            }
        });
        BEViewer.imageView.addImageViewChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                if (BEViewer.imageView.getChangeType() == ImageView.ChangeType.FORENSIC_PATH_NUMERIC_BASE_CHANGED) {
                    boolean bl = BEViewer.imageView.getUseHexPath();
                    if (!bl) {
                        BEMenus.this.rbDecimal.setSelected(true);
                    } else {
                        BEMenus.this.rbHex.setSelected(true);
                    }
                }
            }
        });
        JMenu jMenu6 = new JMenu("Feature Font Size");
        jMenu3.add(jMenu6);
        jMenuItem = new JMenuItem("Zoom In");
        jMenu6.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.featuresModel.setFontSize(BEViewer.featuresModel.getFontSize() + 1);
                BEViewer.referencedFeaturesModel.setFontSize(BEViewer.featuresModel.getFontSize());
            }
        });
        jMenuItem = new JMenuItem("Zoom Out");
        jMenu6.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = BEViewer.featuresModel.getFontSize();
                if (n > 6) {
                    BEViewer.featuresModel.setFontSize(n - 1);
                    BEViewer.referencedFeaturesModel.setFontSize(BEViewer.featuresModel.getFontSize());
                } else {
                    WError.showError("Already at minimum font size of " + n + ".", "BEViewer Feature Font Size error", null);
                }
            }
        });
        jMenuItem = new JMenuItem("Normal Size");
        jMenu6.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.featuresModel.setFontSize(12);
                BEViewer.referencedFeaturesModel.setFontSize(BEViewer.featuresModel.getFontSize());
            }
        });
        JMenu jMenu7 = new JMenu("Image Font Size");
        jMenu3.add(jMenu7);
        jMenuItem = new JMenuItem("Zoom In");
        jMenu7.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.imageView.setFontSize(BEViewer.imageView.getFontSize() + 1);
            }
        });
        jMenuItem = new JMenuItem("Zoom Out");
        jMenu7.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = BEViewer.imageView.getFontSize();
                if (n > 6) {
                    BEViewer.imageView.setFontSize(n - 1);
                } else {
                    WError.showError("Already at minimum font size of " + n + ".", "BEViewer Image Font Size Size error", null);
                }
            }
        });
        jMenuItem = new JMenuItem("Normal Size");
        jMenu7.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.imageView.setFontSize(12);
            }
        });
        JMenu jMenu8 = new JMenu("Referenced Features");
        jMenu3.add(jMenu8);
        this.rbReferencedFeaturesVisible = new JRadioButtonMenuItem("Always Visible");
        buttonGroup3.add(this.rbReferencedFeaturesVisible);
        jMenu8.add(this.rbReferencedFeaturesVisible);
        this.rbReferencedFeaturesVisible.setSelected(!BEViewer.reportSelectionManager.isRequestHideReferencedFeatureView());
        this.rbReferencedFeaturesVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.reportSelectionManager.setRequestHideReferencedFeatureView(false);
            }
        });
        this.rbReferencedFeaturesCollapsible = new JRadioButtonMenuItem("Collapsed when not Referenced");
        buttonGroup3.add(this.rbReferencedFeaturesCollapsible);
        jMenu8.add(this.rbReferencedFeaturesCollapsible);
        this.rbReferencedFeaturesCollapsible.setSelected(BEViewer.reportSelectionManager.isRequestHideReferencedFeatureView());
        this.rbReferencedFeaturesCollapsible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.reportSelectionManager.setRequestHideReferencedFeatureView(true);
            }
        });
        BEViewer.reportSelectionManager.addReportSelectionManagerChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                boolean bl = BEViewer.reportSelectionManager.isRequestHideReferencedFeatureView();
                if (bl) {
                    BEMenus.this.rbReferencedFeaturesCollapsible.setSelected(true);
                } else {
                    BEMenus.this.rbReferencedFeaturesVisible.setSelected(true);
                }
            }
        });
        JMenu jMenu9 = new JMenu("Feature Files");
        jMenu3.add(jMenu9);
        this.cbShowStoplistFiles = new JCheckBoxMenuItem("Show Stoplist Files");
        jMenu9.add(this.cbShowStoplistFiles);
        this.cbShowStoplistFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.reportsModel.setIncludeStoplistFiles(BEMenus.this.cbShowStoplistFiles.getState());
            }
        });
        BEViewer.reportsModel.getTreeModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                this.setShowStoplistVisibility();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                this.setShowStoplistVisibility();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                this.setShowStoplistVisibility();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                this.setShowStoplistVisibility();
            }

            private void setShowStoplistVisibility() {
                Enumeration<ReportsModel.ReportTreeNode> enumeration = BEViewer.reportsModel.elements();
                BEMenus.this.cbShowStoplistFiles.setSelected(BEViewer.reportsModel.isIncludeStoplistFiles());
            }
        });
        this.cbShowEmptyFiles = new JCheckBoxMenuItem("Show Empty Files");
        jMenu9.add(this.cbShowEmptyFiles);
        this.cbShowEmptyFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.reportsModel.setIncludeEmptyFiles(BEMenus.this.cbShowEmptyFiles.getState());
            }
        });
        BEViewer.reportsModel.getTreeModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                this.setShowEmptyFilesVisibility();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                this.setShowEmptyFilesVisibility();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                this.setShowEmptyFilesVisibility();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                this.setShowEmptyFilesVisibility();
            }

            private void setShowEmptyFilesVisibility() {
                Enumeration<ReportsModel.ReportTreeNode> enumeration = BEViewer.reportsModel.elements();
                BEMenus.this.cbShowEmptyFiles.setSelected(BEViewer.reportsModel.isIncludeEmptyFiles());
            }
        });
        jMenu3.addSeparator();
        JMenu jMenu10 = new JMenu("Selected Feature");
        jMenu3.add(jMenu10);
        this.miPanToStart = new JMenuItem("Pan to Start of Path");
        jMenu10.add(this.miPanToStart);
        this.miPanToStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.imageModel.setImageSelection(ForensicPath.getAdjustedPath(BEViewer.imageView.getImagePage().pageForensicPath, 0L));
            }
        });
        this.miPanToStart.setEnabled(false);
        this.miPanToEnd = new JMenuItem("Pan to End of Path");
        jMenu10.add(this.miPanToEnd);
        this.miPanToEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageModel.ImagePage imagePage = BEViewer.imageView.getImagePage();
                String string = imagePage.pageForensicPath;
                long l = imagePage.imageSize;
                long l2 = l > 0L ? l - 1L : 0L;
                BEViewer.imageModel.setImageSelection(ForensicPath.getAdjustedPath(string, l2));
            }
        });
        this.miPanToEnd.setEnabled(false);
        jMenu10.addSeparator();
        this.miShowReportFile = new JMenuItem("Show report.xml File");
        jMenu10.add(this.miShowReportFile);
        this.miShowReportFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FeatureLine featureLine = BEViewer.featureLineSelectionManager.getFeatureLineSelection();
                if (featureLine.featuresFile == null) {
                    WError.showError("A Feature must be selected before viewing the Report file.", "BEViewer Selected Feature error", null);
                } else {
                    try {
                        File file = new File(featureLine.featuresFile.getParentFile(), "report.xml");
                        URL uRL = file.toURI().toURL();
                        new WURL("Bulk Extractor Viewer Report file " + file.toString(), uRL);
                    }
                    catch (Exception exception) {
                        WError.showError("Unable to read report.xml file.", "BEViewer Read error", exception);
                    }
                }
            }
        });
        this.miShowReportFile.setEnabled(false);
        BEViewer.featureLineSelectionManager.addFeatureLineSelectionManagerChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                FeatureLine featureLine = BEViewer.featureLineSelectionManager.getFeatureLineSelection();
                boolean bl = !featureLine.isBlank();
                BEMenus.this.miPanToStart.setEnabled(bl);
                BEMenus.this.miPanToEnd.setEnabled(bl);
                BEMenus.this.miShowReportFile.setEnabled(bl);
            }
        });
        JMenu jMenu11 = new JMenu("Bookmarks");
        this.add(jMenu11);
        this.miAddBookmark = new JMenuItem("Bookmark selected Feature", BEIcons.ADD_BOOKMARK_16);
        jMenu11.add(this.miAddBookmark);
        this.miAddBookmark.setAccelerator(this.KEYSTROKE_B);
        this.miAddBookmark.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FeatureLine featureLine = BEViewer.featureLineSelectionManager.getFeatureLineSelection();
                BEViewer.bookmarksModel.addElement(featureLine);
            }
        });
        BEViewer.featureLineSelectionManager.addFeatureLineSelectionManagerChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                FeatureLine featureLine = BEViewer.featureLineSelectionManager.getFeatureLineSelection();
                BEMenus.this.miAddBookmark.setEnabled(!featureLine.isBlank() && !BEViewer.bookmarksModel.contains(featureLine));
            }
        });
        FeatureLine featureLine = BEViewer.featureLineSelectionManager.getFeatureLineSelection();
        this.miAddBookmark.setEnabled(!featureLine.isBlank() && !BEViewer.bookmarksModel.contains(featureLine));
        this.miManageBookmarks = new JMenuItem("Manage Bookmarks\u2026", BEIcons.MANAGE_BOOKMARKS_16);
        jMenu11.add(this.miManageBookmarks);
        this.miManageBookmarks.setAccelerator(this.KEYSTROKE_M);
        this.miManageBookmarks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WManageBookmarks.openWindow();
            }
        });
        BEViewer.bookmarksModel.bookmarksComboBoxModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                BEMenus.this.miManageBookmarks.setEnabled(!BEViewer.bookmarksModel.isEmpty());
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                BEMenus.this.miManageBookmarks.setEnabled(!BEViewer.bookmarksModel.isEmpty());
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                BEMenus.this.miManageBookmarks.setEnabled(!BEViewer.bookmarksModel.isEmpty());
            }
        });
        this.miManageBookmarks.setEnabled(!BEViewer.bookmarksModel.isEmpty());
        JMenu jMenu12 = new JMenu("Tools");
        this.add(jMenu12);
        jMenuItem = new JMenuItem("Run bulk_extractor\u2026", BEIcons.RUN_BULK_EXTRACTOR_16);
        jMenu12.add(jMenuItem);
        jMenuItem.setAccelerator(this.KEYSTROKE_R);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WScan.openWindow(new ScanSettings());
            }
        });
        jMenuItem = new JMenuItem("bulk_extractor Run Queue\u2026");
        jMenu12.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WScanSettingsRunQueue.openWindow();
            }
        });
        JMenu jMenu13 = new JMenu("Help");
        this.add(jMenu13);
        jMenuItem = new JMenuItem("About Bulk Extractor Viewer 1.5.5", BEIcons.HELP_ABOUT_16);
        jMenu13.add(jMenuItem);
        jMenuItem.setAccelerator(this.KEYSTROKE_A);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WAbout.openWindow();
            }
        });
        jMenuItem = new JMenuItem("Check Versions");
        jMenu13.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BulkExtractorVersionReader.showVersions();
            }
        });
        jMenu13.addSeparator();
        JMenu jMenu14 = new JMenu("Diagnostics");
        jMenu13.add(jMenu14);
        this.miShowLog = new JMenuItem("Show Log");
        jMenu14.add(this.miShowLog);
        this.miShowLog.setAccelerator(this.KEYSTROKE_L);
        this.miShowLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WLog.setVisible();
            }
        });
        jMenuItem = new JMenuItem("Clear Log");
        jMenu14.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WLog.clearLog();
            }
        });
        jMenuItem = new JMenuItem("Copy Log to System Clipboard");
        jMenu14.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.rangeSelectionManager.clear();
                StringSelection stringSelection = new StringSelection(WLog.getLog());
                RangeSelectionManager.setSystemClipboard(stringSelection);
                RangeSelectionManager.setSelectionClipboard(stringSelection);
            }
        });
        jMenu14.addSeparator();
        jMenuItem = new JMenuItem("Close All Image Readers");
        jMenu14.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BEViewer.imageModel.closeAllImageReaders();
            }
        });
        jMenuItem = new JMenuItem("Run Tests\u2026");
        jMenu14.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new WTest();
            }
        });
    }
}

