/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BEPreferences {
    private static final Preferences preferences = Preferences.userNodeForPackage(BEViewer.class);
    public static final boolean DEFAULT_SHOW_TOOLBAR = true;
    public static final int DEFAULT_FEATURE_FONT_SIZE = 12;
    public static final int DEFAULT_IMAGE_FONT_SIZE = 12;
    public static final boolean DEFAULT_FORENSIC_PATH_NUMERIC_BASE_HEX = false;
    public static final String DEFAULT_IMAGE_LINE_FORMAT = "Text";
    public static final boolean DEFAULT_REQUEST_HIDE_REFERENCED_FEATURE_VIEW = false;
    public static final boolean DEFAULT_SHOW_STOPLIST_FILES = false;
    public static final boolean DEFAULT_SHOW_EMPTY_FILES = false;

    private BEPreferences() {
    }

    public static void clearPreferences() {
        try {
            preferences.removeNode();
            WLog.log("BEPreferences.clearPreferences: preferences cleared.");
        }
        catch (Exception exception) {
            WError.showError("Failure while clearing user preferences.", "BEViewer Preferences Error", exception);
        }
    }

    public static String getPreferencesString() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        preferences.exportSubtree(byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }

    public static void loadPreferences() {
        boolean bl = preferences.getBoolean("show_toolbar", true);
        BEViewer.toolbar.setVisible(bl);
        int n = preferences.getInt("feature_font_size", 12);
        BEViewer.featuresModel.setFontSize(n);
        BEViewer.referencedFeaturesModel.setFontSize(n);
        int n2 = preferences.getInt("image_font_size", 12);
        BEViewer.imageView.setFontSize(n2);
        boolean bl2 = preferences.getBoolean("forensic_path_numeric_base_hex", false);
        BEViewer.featuresModel.setUseHexPath(bl2);
        BEViewer.imageView.setUseHexPath(bl2);
        String string = preferences.get("image_line_format", DEFAULT_IMAGE_LINE_FORMAT);
        BEViewer.imageView.setLineFormat(ImageLine.LineFormat.lookup(string));
        boolean bl3 = preferences.getBoolean("request_hide_referenced_feature_view", false);
        BEViewer.reportSelectionManager.setRequestHideReferencedFeatureView(bl3);
        boolean bl4 = preferences.getBoolean("show_stoplist_files", false);
        BEViewer.reportsModel.setIncludeStoplistFiles(bl4);
        boolean bl5 = preferences.getBoolean("show_empty_files", false);
        BEViewer.reportsModel.setIncludeEmptyFiles(bl5);
        WTest.testWorkSettingsFileString = preferences.get("test_work_settings_file", "");
        WTest.testOutputDirectoryString = preferences.get("test_output_directory", "");
        WTest.testScanDirective = preferences.get("test_scan_directive", "bulk_extractor,");
        BEPreferences.loadSavedReports();
        BEPreferences.loadSavedBookmarks();
    }

    private static void loadSavedReports() {
        Preferences preferences = BEPreferences.preferences.node("saved_reports");
        int n = 0;
        while (true) {
            File file;
            String string = Integer.toString(n);
            String string2 = preferences.get("feature_directory_" + string, null);
            File file2 = string2 == null ? null : new File(string2);
            String string3 = preferences.get("image_file_" + string, null);
            File file3 = file = string3 == null ? null : new File(string3);
            if (file2 == null) break;
            if (file == null) {
                WLog.log("BEPreferences: loadSavedReports: unexpected null reportImageFile");
                break;
            }
            BEViewer.reportsModel.addReport(file2, file);
            ++n;
        }
    }

    private static void loadSavedBookmarks() {
        Preferences preferences = BEPreferences.preferences.node("saved_bookmarks");
        int n = 0;
        while (true) {
            String string = Integer.toString(n);
            String string2 = preferences.get("image_file_" + string, null);
            File file = string2 == null ? null : new File(string2);
            String string3 = preferences.get("features_file_" + string, null);
            File file2 = string2 == null ? null : new File(string3);
            long l = preferences.getLong("start_byte_" + string, 0L);
            int n2 = preferences.getInt("num_bytes_" + string, 0);
            if (file2 == null) break;
            if (file != null && !file.exists()) {
                WError.showError("The image file for the Feature being restored is not available:\nImage file: " + string2 + "\nFeature file: " + string3 + "\nFeature index: " + l, "BEViewer Preferences Error", null);
            }
            if (!file2.exists()) {
                WError.showError("Unable to restore feature from saved preferences because the Feature file is not available:\nImage file: " + string2 + "\nFeature file: " + string3 + "\nFeature index: " + l, "BEViewer Preferences Error", null);
                break;
            }
            try {
                FeatureLine featureLine = new FeatureLine(file, file2, l, n2);
                BEViewer.bookmarksModel.addElement(featureLine);
            }
            catch (Exception exception) {
                WError.showError("Unable to restore feature from saved preferences:\nImage file: " + string2 + "\nFeature file: " + string3 + "\nFeature index: " + l, "BEViewer Preferences Error", exception);
            }
            ++n;
        }
    }

    public static void savePreferences() {
        try {
            preferences.putBoolean("show_toolbar", BEViewer.toolbar.isVisible());
            preferences.putInt("feature_font_size", BEViewer.featuresModel.getFontSize());
            preferences.putInt("image_font_size", BEViewer.imageView.getFontSize());
            preferences.putBoolean("forensic_path_numeric_base_hex", BEViewer.featuresModel.getUseHexPath());
            preferences.put("image_line_format", BEViewer.imageView.getLineFormat().toString());
            preferences.putBoolean("request_hide_referenced_feature_view", BEViewer.reportSelectionManager.isRequestHideReferencedFeatureView());
            preferences.putBoolean("show_stoplist_files", BEViewer.reportsModel.isIncludeStoplistFiles());
            preferences.putBoolean("show_empty_files", BEViewer.reportsModel.isIncludeEmptyFiles());
            preferences.put("test_work_settings_file", WTest.testWorkSettingsFileString);
            preferences.put("test_output_directory", WTest.testOutputDirectoryString);
            preferences.put("test_scan_directive", WTest.testScanDirective);
            BEPreferences.saveReports();
            BEPreferences.saveBookmarks();
        }
        catch (Exception exception) {
            WError.showError("Unable to save user preferences.", "BEViewer Preferences Error", exception);
        }
    }

    private static void saveReports() throws Exception {
        Preferences preferences = BEPreferences.preferences.node("saved_reports");
        preferences.clear();
        Enumeration<ReportsModel.ReportTreeNode> enumeration = BEViewer.reportsModel.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ReportsModel.ReportTreeNode reportTreeNode = enumeration.nextElement();
            String string = FileTools.getAbsolutePath(reportTreeNode.featuresDirectory);
            String string2 = FileTools.getAbsolutePath(reportTreeNode.reportImageFile);
            String string3 = Integer.toString(n);
            preferences.put("feature_directory_" + string3, string);
            preferences.put("image_file_" + string3, string2);
            ++n;
        }
    }

    private static void saveBookmarks() throws Exception {
        Preferences preferences = BEPreferences.preferences.node("saved_bookmarks");
        preferences.clear();
        int n = BEViewer.bookmarksModel.size();
        for (int i = 0; i < n; ++i) {
            FeatureLine featureLine = BEViewer.bookmarksModel.get(i);
            String string = FileTools.getAbsolutePath(featureLine.reportImageFile);
            String string2 = FileTools.getAbsolutePath(featureLine.featuresFile);
            long l = featureLine.startByte;
            int n2 = featureLine.numBytes;
            String string3 = Integer.toString(i);
            preferences.put("image_file_" + string3, string);
            preferences.put("features_file_" + string3, string2);
            preferences.putLong("start_byte_" + string3, l);
            preferences.putInt("num_bytes_" + string3, n2);
        }
    }

    public static boolean exportWorkSettings(File file) {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("dfxml");
            element.setAttribute("xmloutputversion", "1.0");
            document.appendChild(element);
            Element element2 = document.createElement("work_settings");
            element.appendChild(element2);
            Enumeration<ReportsModel.ReportTreeNode> enumeration = BEViewer.reportsModel.elements();
            while (enumeration.hasMoreElements()) {
                ReportsModel.ReportTreeNode reportTreeNode = enumeration.nextElement();
                String string = FileTools.getAbsolutePath(reportTreeNode.featuresDirectory);
                object4 = FileTools.getAbsolutePath(reportTreeNode.reportImageFile);
                object3 = document.createElement("report");
                object3.setAttribute("feature_directory", string);
                object3.setAttribute("image_file", (String)object4);
                element2.appendChild((Node)object3);
            }
            int n = BEViewer.bookmarksModel.size();
            for (int i = 0; i < n; ++i) {
                object4 = BEViewer.bookmarksModel.get(i);
                object3 = FileTools.getAbsolutePath(((FeatureLine)object4).reportImageFile);
                object2 = FileTools.getAbsolutePath(((FeatureLine)object4).featuresFile);
                object = Long.toString(((FeatureLine)object4).startByte);
                String string = Integer.toString(((FeatureLine)object4).numBytes);
                Element element3 = document.createElement("bookmark");
                element3.setAttribute("image_file", (String)object3);
                element3.setAttribute("feature_file", (String)object2);
                element3.setAttribute("start_byte", (String)object);
                element3.setAttribute("num_bytes", string);
                element2.appendChild(element3);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            object4 = transformerFactory.newTransformer();
            ((Transformer)object4).setOutputProperty("indent", "yes");
            object3 = new DOMSource(document);
            object2 = new FileOutputStream(file);
            object = new StreamResult((OutputStream)object2);
            ((Transformer)object4).transform((Source)object3, (Result)object);
            ((OutputStream)object2).flush();
            ((FileOutputStream)object2).close();
            return true;
        }
        catch (Exception exception) {
            WError.showError("Unable to export work settings to file " + file + ".", "BEViewer file error", exception);
            return false;
        }
    }

    public static boolean importWorkSettings(File file, boolean bl) {
        try {
            File file2;
            Object object;
            Object object2;
            int n;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            Element element = document.getDocumentElement();
            Element element2 = (Element)element.getElementsByTagName("work_settings").item(0);
            if (!bl) {
                BEViewer.closeAllReports();
            }
            NodeList nodeList = element2.getElementsByTagName("report");
            for (n = 0; n < nodeList.getLength(); ++n) {
                object2 = (Element)nodeList.item(n);
                object = new File(object2.getAttribute("feature_directory"));
                file2 = new File(object2.getAttribute("image_file"));
                BEViewer.reportsModel.addReport((File)object, file2);
            }
            object2 = element2.getElementsByTagName("bookmark");
            for (n = 0; n < object2.getLength(); ++n) {
                object = (Element)object2.item(n);
                file2 = new File(object.getAttribute("image_file"));
                File file3 = new File(object.getAttribute("feature_file"));
                long l = Long.parseLong(object.getAttribute("start_byte"));
                int n2 = Integer.parseInt(object.getAttribute("num_bytes"));
                try {
                    FeatureLine featureLine = new FeatureLine(file2, file3, l, n2);
                    BEViewer.bookmarksModel.addElement(featureLine);
                    continue;
                }
                catch (Exception exception) {
                    WError.showError("Unable to restore work settings feature:\nReport Image file: " + file2 + "\nFeature file: " + file3 + "\nFeature index: " + l, "BEViewer Preferences Error", exception);
                }
            }
            return true;
        }
        catch (Exception exception) {
            WError.showError("Unable to load work settings from file " + file + ".", "BEViewer file error", exception);
            return false;
        }
    }
}

