/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class BasicImageUI
extends ImageUI
implements MouseListener,
MouseMotionListener {
    private ImageComponent imageComponent;
    private ImageView imageView;
    private ImageViewChangedListener imageViewChangedListener;
    private RangeSelectionManager rangeSelectionManager;
    private RangeSelectionManagerChangedListener rangeSelectionManagerChangedListener;
    private boolean makingRangeSelection;
    private int rangeMouseDownLine;
    private int fontHeight;
    private int monospaceWidth;
    private int lineCount;
    private int mouseDownLine = -1;
    private int minSelectionIndex = -1;
    private int maxSelectionIndex = -1;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicImageUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.imageComponent = (ImageComponent)jComponent;
        this.imageView = ((ImageComponent)jComponent).getImageView();
        this.rangeSelectionManager = ((ImageComponent)jComponent).getRangeSelectionManager();
        this.rangeSelectionManagerChangedListener = new RangeSelectionManagerChangedListener();
        this.rangeSelectionManager.addRangeSelectionManagerChangedListener(this.rangeSelectionManagerChangedListener);
        this.makingRangeSelection = false;
        this.imageComponent.addMouseListener(this);
        this.imageComponent.addMouseMotionListener(this);
        this.imageViewChangedListener = new ImageViewChangedListener();
        this.imageView.addImageViewChangedListener(this.imageViewChangedListener);
        this.setKeyboardListener();
    }

    private void setKeyboardListener() {
        this.imageComponent.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b' && BasicImageUI.this.rangeSelectionManager.getProvider() == BasicImageUI.this.imageView) {
                    BasicImageUI.this.rangeSelectionManager.clear();
                }
            }
        });
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.imageComponent.removeMouseListener(this);
        this.imageComponent.removeMouseMotionListener(this);
        this.imageView.removeImageViewChangedListener(this.imageViewChangedListener);
        this.imageViewChangedListener = null;
        this.imageComponent = null;
        this.rangeSelectionManager.removeRangeSelectionManagerChangedListener(this.rangeSelectionManagerChangedListener);
    }

    public Font getImageFont() {
        return new Font("monospaced", 0, this.imageView.getFontSize());
    }

    private void scrollToForensicPath() {
        Rectangle rectangle;
        int n = this.imageView.getForensicPathLineIndex(this.imageView.getImagePage().featureLine.forensicPath);
        if (n == -1) {
            rectangle = new Rectangle(0, 0, 0, 0);
        } else {
            int n2 = n * this.fontHeight;
            rectangle = new Rectangle(0, n2, 0, this.fontHeight * 3);
        }
        this.imageComponent.scrollRectToVisible(rectangle);
        this.imageComponent.scrollRectToVisible(rectangle);
    }

    private Dimension getViewDimension() {
        int n = this.imageView.getNumLines();
        int n2 = n == 0 ? 0 : this.imageView.getLine((int)0).text.length();
        FontMetrics fontMetrics = this.imageComponent.getFontMetrics(this.getImageFont());
        int n3 = fontMetrics.stringWidth(" ") * n2;
        int n4 = fontMetrics.getHeight() * n;
        return new Dimension(n3, n4);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = new Rectangle(jComponent.getPreferredSize());
        Rectangle rectangle2 = graphics.getClipBounds();
        Font font = this.getImageFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        this.monospaceWidth = fontMetrics.stringWidth(" ");
        this.fontHeight = fontMetrics.getHeight();
        int n = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
        int n2 = Math.max(0, n / this.fontHeight);
        int n3 = rectangle2.y - rectangle.y;
        int n4 = Math.max(0, n3 / this.fontHeight);
        int n5 = rectangle.height / this.fontHeight;
        int n6 = fontMetrics.getAscent();
        if (rectangle.height % this.fontHeight != 0) {
            ++n5;
        }
        Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y + n4 * this.fontHeight, rectangle.width, this.fontHeight);
        int n7 = rectangle3.y;
        int n8 = rectangle3.x;
        this.lineCount = this.imageView.getNumLines();
        int n9 = Math.min(this.lineCount, n5 - n2);
        graphics.setFont(font);
        for (int i = n4; i < n9; ++i) {
            int n10;
            ImageLine imageLine = this.imageView.getLine(i);
            if (i >= this.minSelectionIndex && i <= this.maxSelectionIndex) {
                graphics.setColor(UIManager.getColor("List.selectionBackground"));
                n10 = fontMetrics.stringWidth(imageLine.text);
                graphics.fillRect(0, n7, n10, this.fontHeight);
            }
            graphics.setColor(Color.YELLOW);
            for (n10 = 0; n10 < imageLine.numHighlights; ++n10) {
                int n11 = imageLine.highlightIndexes[n10];
                graphics.fillRect(n11 * this.monospaceWidth, n7, this.monospaceWidth, this.fontHeight);
            }
            graphics.setColor(jComponent.getForeground());
            graphics.drawString(imageLine.text, n8, n7 + n6);
            n7 += this.fontHeight;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.rangeSelectionManager.getProvider() == this.imageView) {
            this.rangeSelectionManager.clear();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.imageComponent.requestFocusInWindow();
        int n = mouseEvent.getY() / this.fontHeight;
        this.mouseDownLine = n >= 0 && n < this.lineCount ? n : -1;
        this.makingRangeSelection = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mouseDownLine != -1) {
            int n;
            int n2;
            int n3;
            if (!this.makingRangeSelection) {
                this.makingRangeSelection = true;
                this.rangeSelectionManager.setRange(this.imageView, this.mouseDownLine, this.mouseDownLine);
            }
            if ((n3 = mouseEvent.getY() / this.fontHeight) < 0) {
                n3 = 0;
            }
            if (n3 >= this.lineCount) {
                n3 = this.lineCount - 1;
            }
            if (this.mouseDownLine <= n3) {
                n2 = this.mouseDownLine;
                n = n3;
            } else {
                n2 = n3;
                n = this.mouseDownLine;
            }
            if (n2 != this.minSelectionIndex || n != this.maxSelectionIndex) {
                this.minSelectionIndex = n2;
                this.maxSelectionIndex = n;
                this.imageComponent.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.makingRangeSelection) {
            this.rangeSelectionManager.setRange(this.imageView, this.minSelectionIndex, this.maxSelectionIndex);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private class RangeSelectionManagerChangedListener
    implements Observer {
        private RangeSelectionManagerChangedListener() {
        }

        @Override
        public void update(Observable observable, Object object) {
            if (BasicImageUI.this.rangeSelectionManager.getProvider() != BasicImageUI.this.imageView) {
                BasicImageUI.this.minSelectionIndex = -1;
                BasicImageUI.this.maxSelectionIndex = -1;
                BasicImageUI.this.imageComponent.repaint();
            }
        }
    }

    private class ImageViewChangedListener
    implements Observer {
        private ImageViewChangedListener() {
        }

        @Override
        public void update(Observable observable, Object object) {
            ImageView.ChangeType changeType = BasicImageUI.this.imageView.getChangeType();
            if (changeType == ImageView.ChangeType.IMAGE_PAGE_CHANGED || changeType == ImageView.ChangeType.LINE_FORMAT_CHANGED) {
                BasicImageUI.this.imageComponent.setComponentSize(BasicImageUI.this.getViewDimension());
                BasicImageUI.this.imageComponent.revalidate();
                if (BasicImageUI.this.rangeSelectionManager.getProvider() == BasicImageUI.this.imageView) {
                    BasicImageUI.this.rangeSelectionManager.clear();
                }
                BasicImageUI.this.scrollToForensicPath();
                BasicImageUI.this.imageComponent.repaint();
            } else if (changeType == ImageView.ChangeType.USER_HIGHLIGHT_CHANGED) {
                BasicImageUI.this.imageComponent.repaint();
            } else if (changeType == ImageView.ChangeType.FORENSIC_PATH_NUMERIC_BASE_CHANGED || changeType == ImageView.ChangeType.FONT_SIZE_CHANGED) {
                BasicImageUI.this.imageComponent.setComponentSize(BasicImageUI.this.getViewDimension());
                BasicImageUI.this.imageComponent.revalidate();
                BasicImageUI.this.imageComponent.repaint();
            } else {
                throw new RuntimeException("Unexpected change type.");
            }
        }
    }
}

