/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FeatureFieldFormatter {
    public static final int MAX_CHAR_WIDTH = 1000;
    private static final DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    private static final byte[] EXIF_0 = new byte[]{-1, -40, -1, -32};
    private static final byte[] EXIF_1 = new byte[]{-1, -40, -1, -31};
    private static final byte[] EXIF_2 = new byte[]{-1, -40, -1, -30};
    private static final byte[] EXIF_3 = new byte[]{-1, -40, -1, -29};
    private static final byte[] EXIF_4 = new byte[]{-1, -40, -1, -28};
    private static final byte[] EXIF_5 = new byte[]{-1, -40, -1, -27};
    private static final byte[] EXIF_6 = new byte[]{-1, -40, -1, -26};
    private static final byte[] EXIF_7 = new byte[]{-1, -40, -1, -25};
    private static final byte[] EXIF_8 = new byte[]{-1, -40, -1, -24};
    private static final byte[] EXIF_9 = new byte[]{-1, -40, -1, -23};
    private static final byte[] EXIF_A = new byte[]{-1, -40, -1, -22};
    private static final byte[] EXIF_B = new byte[]{-1, -40, -1, -21};
    private static final byte[] EXIF_C = new byte[]{-1, -40, -1, -20};
    private static final byte[] EXIF_D = new byte[]{-1, -40, -1, -19};
    private static final byte[] EXIF_E = new byte[]{-1, -40, -1, -18};
    private static final byte[] EXIF_F = new byte[]{-1, -40, -1, -17};
    private static final byte[] PSD = new byte[]{56, 66, 80, 83, 0, 1};
    private static final byte[] TIFF_MM = new byte[]{77, 77, 0, 42};
    private static final byte[] TIFF_II = new byte[]{73, 73, 42, 0};
    private static final Vector<byte[]> EXIF = new Vector();
    private static final byte[] ELF_MAGIC_NUMBER;
    private static final Vector<byte[]> ELF;
    private static final byte[] WINPE_MAGIC_NUMBER;
    private static final Vector<byte[]> WINPE;

    private FeatureFieldFormatter() {
    }

    public static String getFormattedFeatureText(File file, byte[] byArray, byte[] byArray2) {
        String string = file.getName();
        String string2 = string.equals("elf.txt") ? FeatureFieldFormatter.getELFFormat(byArray2) : (string.equals("ether.txt") ? FeatureFieldFormatter.getEtherFormat(byArray, byArray2) : (string.equals("exif.txt") ? FeatureFieldFormatter.getEXIFFormat(byArray2) : (string.equals("gps.txt") ? FeatureFieldFormatter.getGPSFormat(byArray2) : (string.equals("ip.txt") ? FeatureFieldFormatter.getGenericFormatWithContext(byArray, byArray2) : (string.equals("winpe.txt") ? FeatureFieldFormatter.getWINPEFormat(byArray2) : (string.equals("identified_blocks.txt") || string.equals("identified_sources.txt") ? FeatureFieldFormatter.getGenericFormatWithContext(byArray, byArray2) : FeatureFieldFormatter.getGenericFormat(byArray)))))));
        if (string2.length() > 1000) {
            string2 = string2.substring(0, 1000) + "\u2026";
        }
        return string2;
    }

    private static String getELFFormat(byte[] byArray) {
        byte[] byArray2 = UTF8Tools.unescapeEscape(byArray);
        return new String(byArray2);
    }

    private static String getEtherFormat(byte[] byArray, byte[] byArray2) {
        return new String(byArray) + " " + new String(byArray2);
    }

    private static String getEXIFFormat(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            byte[] byArray2 = UTF8Tools.unescapeEscape(byArray);
            Document document = documentBuilder.parse(new ByteArrayInputStream(byArray2));
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                int n2;
                Node node = nodeList.item(i);
                if (node.getFirstChild() == null) continue;
                String string = node.getNodeName();
                String string2 = node.getFirstChild().getNodeValue();
                if (string == null) {
                    string = "not defined";
                }
                if ((n2 = string.lastIndexOf(46)) > 0) {
                    string = string.substring(n2 + 1);
                }
                stringBuffer.append(string);
                stringBuffer.append("=");
                stringBuffer.append(string2);
                if (i == n - 1) continue;
                stringBuffer.append(", ");
            }
        }
        catch (Exception exception) {
            stringBuffer.append("<EXIF parser failed, please see log>");
            WLog.log("FeatureFieldFormatter.getEXIFFormat parser failure:");
            WLog.logThrowable(exception);
            WLog.logBytes("on unescaped byte sequence", UTF8Tools.unescapeBytes(byArray));
            WLog.logBytes("From escaped byte sequence", byArray);
        }
        return stringBuffer.toString();
    }

    private static String getGPSFormat(byte[] byArray) {
        return new String(byArray);
    }

    private static String getWINPEFormat(byte[] byArray) {
        byte[] byArray2 = UTF8Tools.unescapeEscape(byArray);
        return new String(byArray2);
    }

    private static String getGenericFormat(byte[] byArray) {
        byte[] byArray2 = byArray;
        if (UTF8Tools.escapedLooksLikeUTF16(byArray2)) {
            byArray2 = UTF8Tools.stripNulls(byArray2);
        }
        byArray2 = UTF8Tools.unescapeEscape(byArray2);
        return new String(byArray2, UTF8Tools.UTF_8);
    }

    private static String getGenericFormatWithContext(byte[] byArray, byte[] byArray2) {
        return new String(byArray) + " " + new String(byArray2);
    }

    public static Vector<byte[]> getImageHighlightVector(ImageModel.ImagePage imagePage) {
        byte[] byArray;
        byte[] byArray2;
        if (imagePage.featureLine.featuresFile == null) {
            return new Vector<byte[]>();
        }
        String string = imagePage.featureLine.featuresFile.getName();
        if (string.equals("gps.txt")) {
            return EXIF;
        }
        if (string.equals("exif.txt")) {
            return EXIF;
        }
        if (string.equals("ip.txt")) {
            return FeatureFieldFormatter.getIPImageFormat(imagePage);
        }
        if (string.equals("tcp.txt")) {
            return FeatureFieldFormatter.getTCPImageFormat(imagePage);
        }
        if (string.equals("elf.txt")) {
            return ELF;
        }
        if (string.equals("winpe.txt")) {
            return WINPE;
        }
        Vector<byte[]> vector = new Vector<byte[]>();
        if (UTF8Tools.escapedLooksLikeUTF16(imagePage.featureLine.featureField)) {
            byArray2 = UTF8Tools.utf16To8Basic(imagePage.featureLine.featureField);
            byArray = imagePage.featureLine.featureField;
        } else {
            byArray2 = imagePage.featureLine.featureField;
            byArray = UTF8Tools.utf8To16Basic(imagePage.featureLine.featureField);
        }
        vector.add(byArray2);
        vector.add(byArray);
        return vector;
    }

    private static byte[] getIPBytes(String string) {
        String[] stringArray;
        int n = string.lastIndexOf(58);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if ((stringArray = string.split("\\.")).length != 4) {
            return null;
        }
        byte[] byArray = new byte[4];
        try {
            for (int i = 0; i < 4; ++i) {
                int n2 = Integer.parseInt(stringArray[i]);
                if (n2 < 0 || n2 > 255) {
                    return null;
                }
                byArray[i] = (byte)n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return byArray;
    }

    private static Vector<byte[]> getIPImageFormat(ImageModel.ImagePage imagePage) {
        Vector<byte[]> vector = new Vector<byte[]>();
        String string = new String(imagePage.featureLine.featureField);
        byte[] byArray = FeatureFieldFormatter.getIPBytes(string);
        if (byArray == null) {
            WLog.log("FeatureFieldFormatter.getIPImageFormat: Invalid IP in feature: '" + string + "'");
        } else {
            vector.add(byArray);
        }
        return vector;
    }

    private static Vector<byte[]> getTCPImageFormat(ImageModel.ImagePage imagePage) {
        Vector<byte[]> vector = new Vector<byte[]>();
        String string = new String(imagePage.featureLine.featureField);
        String[] stringArray = string.split("\\ ");
        if (stringArray.length < 3) {
            WLog.log("FeatureFieldFormatter.getIPImageFormat: Invalid TCP in feature: '" + string + "'");
            return vector;
        }
        byte[] byArray = FeatureFieldFormatter.getIPBytes(stringArray[0]);
        if (byArray == null) {
            WLog.log("FeatureFieldFormatter.getIPImageFormat: Invalid source TCP in feature: '" + string + "'");
        } else {
            vector.add(byArray);
        }
        byte[] byArray2 = FeatureFieldFormatter.getIPBytes(stringArray[2]);
        if (byArray2 == null) {
            WLog.log("FeatureFieldFormatter.getIPImageFormat: Invalid destination TCP in feature: '" + string + "'");
        } else {
            vector.add(byArray2);
        }
        return vector;
    }

    static {
        EXIF.add(EXIF_0);
        EXIF.add(EXIF_1);
        EXIF.add(EXIF_2);
        EXIF.add(EXIF_3);
        EXIF.add(EXIF_4);
        EXIF.add(EXIF_5);
        EXIF.add(EXIF_6);
        EXIF.add(EXIF_7);
        EXIF.add(EXIF_8);
        EXIF.add(EXIF_9);
        EXIF.add(EXIF_A);
        EXIF.add(EXIF_B);
        EXIF.add(EXIF_C);
        EXIF.add(EXIF_D);
        EXIF.add(EXIF_E);
        EXIF.add(EXIF_F);
        EXIF.add(EXIF_C);
        EXIF.add(EXIF_D);
        EXIF.add(EXIF_E);
        EXIF.add(EXIF_F);
        EXIF.add(PSD);
        EXIF.add(TIFF_MM);
        EXIF.add(TIFF_II);
        ELF_MAGIC_NUMBER = new byte[]{127, 69, 76, 70};
        ELF = new Vector();
        ELF.add(ELF_MAGIC_NUMBER);
        WINPE_MAGIC_NUMBER = new byte[]{80, 69, 0, 0};
        WINPE = new Vector();
        WINPE.add(WINPE_MAGIC_NUMBER);
    }
}

