/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.Observable;
import java.util.Observer;

public class FeaturesModel
implements CopyableLineInterface {
    private FeaturesParserThread featuresParserThread;
    private final ModelType modelType;
    private ModelRole modelRole = ModelRole.FEATURES_ROLE;
    private final ReportSelectionManager reportSelectionManager;
    private final ReportSelectionManagerChangedListener reportSelectionManagerChangedListener = new ReportSelectionManagerChangedListener();
    private File imageFile = null;
    private File featuresFile = null;
    private byte[] filterBytes = new byte[0];
    private boolean filterMatchCase = false;
    private boolean useHexPath = false;
    private int fontSize = 12;
    private FeatureLineTable featureLineTable = new FeatureLineTable(null, null);
    public WProgress progressBar = new WProgress("Reading");
    private final ModelChangedNotifier<Object> featuresModelChangedNotifier = new ModelChangedNotifier();
    private ChangeType changeType = ChangeType.FEATURES_CHANGED;

    FeaturesModel(ReportSelectionManager reportSelectionManager, ModelType modelType) {
        this.reportSelectionManager = reportSelectionManager;
        reportSelectionManager.addReportSelectionManagerChangedListener(this.reportSelectionManagerChangedListener);
        this.modelType = modelType;
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public ModelRole getModelRole() {
        return this.modelRole;
    }

    public void setReport(File file, File file2, ModelRole modelRole) {
        WLog.log("FeaturesModel.setReport image file: " + file + ", featuresFile: " + file2);
        if (file == this.imageFile && file2 == this.featuresFile) {
            return;
        }
        this.modelRole = modelRole;
        this.imageFile = file;
        this.featuresFile = file2;
        this.runFeaturesParserThread();
    }

    public void setFilterBytes(byte[] byArray) {
        if (UTF8Tools.bytesMatch(byArray, this.filterBytes)) {
            return;
        }
        this.filterBytes = byArray;
        this.runFeaturesParserThread();
    }

    public void setFilterMatchCase(boolean bl) {
        if (bl == this.filterMatchCase) {
            return;
        }
        if (this.modelType == ModelType.REFERENCED_FEATURES) {
            throw new RuntimeException("Request not allowed for Referenced Features");
        }
        this.filterMatchCase = bl;
        this.runFeaturesParserThread();
    }

    public byte[] getFilterBytes() {
        return this.filterBytes;
    }

    public boolean isFilterMatchCase() {
        return this.filterMatchCase;
    }

    public void setUseHexPath(boolean bl) {
        if (bl == this.useHexPath) {
            return;
        }
        this.useHexPath = bl;
        this.changeType = ChangeType.FORMAT_CHANGED;
        this.featuresModelChangedNotifier.fireModelChanged(null);
    }

    public boolean getUseHexPath() {
        return this.useHexPath;
    }

    public void setFontSize(int n) {
        if (n == this.fontSize) {
            return;
        }
        this.fontSize = n;
        this.changeType = ChangeType.FORMAT_CHANGED;
        this.featuresModelChangedNotifier.fireModelChanged(null);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public File getFeaturesFile() {
        return this.featuresFile;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public int getTotalLines() {
        return this.featureLineTable.size();
    }

    public int getWidestLineLength() {
        return this.featureLineTable.getWidestLineLength();
    }

    public FeatureLine getFeatureLine(int n) {
        FeatureLine featureLine = this.featureLineTable.get(n);
        return featureLine;
    }

    public void addFeaturesModelChangedListener(Observer observer) {
        this.featuresModelChangedNotifier.addObserver(observer);
    }

    public void removeFeaturesModelChangedListener(Observer observer) {
        this.featuresModelChangedNotifier.deleteObserver(observer);
    }

    private void runFeaturesParserThread() {
        WLog.log("FeaturesModel.runFeaturesParserThread: " + this + " imageFile: " + this.imageFile + ", featuresFile: " + this.featuresFile + ", filterBytes as string: " + new String(this.filterBytes) + ", filterMatchCase: " + this.filterMatchCase);
        if (this.filterBytes == null) {
            throw new NullPointerException();
        }
        if (this.featuresParserThread != null) {
            this.featuresParserThread.setAbortRequest();
            try {
                this.featuresParserThread.join();
            }
            catch (InterruptedException interruptedException) {
                WError.showError("Parser Thread error.", "BEViewer Thread error", interruptedException);
            }
        }
        this.featureLineTable = new FeatureLineTable(null, null);
        this.changeType = ChangeType.FEATURES_CHANGED;
        this.featuresModelChangedNotifier.fireModelChanged(null);
        this.featuresParserThread = new FeaturesParserThread(this, this.imageFile, this.featuresFile, this.filterBytes, this.filterMatchCase, this.useHexPath);
        this.featuresParserThread.start();
    }

    public void setFeatureLineTable(FeatureLineTable featureLineTable) {
        this.featureLineTable = featureLineTable;
        this.changeType = ChangeType.FEATURES_CHANGED;
        this.featuresModelChangedNotifier.fireModelChanged(null);
    }

    @Override
    public String getCopyableLine(int n) {
        FeatureLine featureLine = this.getFeatureLine(n);
        return ForensicPath.getPrintablePath(featureLine.forensicPath, this.useHexPath) + "\t" + featureLine.formattedFeature;
    }

    static /* synthetic */ byte[] access$702(FeaturesModel featuresModel, byte[] byArray) {
        featuresModel.filterBytes = byArray;
        return byArray;
    }

    private final class ReportSelectionManagerChangedListener
    implements Observer {
        private ReportSelectionManagerChangedListener() {
        }

        @Override
        public void update(Observable observable, Object object) {
            if (FeaturesModel.this.reportSelectionManager.getChangeType() == ReportSelectionManager.ChangeType.PREFERENCE_CHANGED) {
                return;
            }
            FeaturesModel.this.imageFile = FeaturesModel.this.reportSelectionManager.getImageFile();
            if (FeaturesModel.this.modelType == ModelType.FEATURES_OR_HISTOGRAM) {
                if (FeaturesModel.this.reportSelectionManager.getReportSelectionType() == ReportSelectionManager.ReportSelectionType.HISTOGRAM) {
                    FeaturesModel.this.modelRole = ModelRole.HISTOGRAM_ROLE;
                    FeaturesModel.this.featuresFile = FeaturesModel.this.reportSelectionManager.getHistogramFile();
                } else {
                    FeaturesModel.this.modelRole = ModelRole.FEATURES_ROLE;
                    FeaturesModel.this.featuresFile = FeaturesModel.this.reportSelectionManager.getFeaturesFile();
                }
                FeaturesModel.this.runFeaturesParserThread();
            } else if (FeaturesModel.this.modelType == ModelType.REFERENCED_FEATURES) {
                FeaturesModel.this.modelRole = ModelRole.FEATURES_ROLE;
                FeaturesModel.this.featuresFile = FeaturesModel.this.reportSelectionManager.getReferencedFeaturesFile();
                FeaturesModel.access$702(FeaturesModel.this, new byte[0]);
                FeaturesModel.this.runFeaturesParserThread();
            } else {
                throw new RuntimeException("Invalid type");
            }
        }
    }

    public static final class ModelRole {
        public static final ModelRole FEATURES_ROLE = new ModelRole("Features role");
        public static final ModelRole HISTOGRAM_ROLE = new ModelRole("Histogram role");
        private final String name;

        private ModelRole(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class ModelType {
        public static final ModelType FEATURES_OR_HISTOGRAM = new ModelType("Features or histogram, upper window");
        public static final ModelType REFERENCED_FEATURES = new ModelType("Referenced featues, lower window");
        private final String name;

        private ModelType(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class ChangeType {
        public static final ChangeType FEATURES_CHANGED = new ChangeType("Feature list changed");
        public static final ChangeType FORMAT_CHANGED = new ChangeType("Path format or font changed");
        private final String name;

        private ChangeType(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

