/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileChooserButton
extends JButton
implements ActionListener {
    private final Component parent;
    private final String toolTip;
    private final JTextField textField;
    private final int dialogType;
    private final int fileSelectionMode;
    private final FileFilter preferredFileFilter;
    public JFileChooser chooser = new JFileChooser();
    public static final int READ_FILE = 0;
    public static final int READ_DIRECTORY = 1;
    public static final int WRITE_FILE = 2;
    public static final int WRITE_DIRECTORY = 3;
    public static final int READ_IMAGE_FILE = 4;
    public static final int READ_REPORT_FILE = 5;

    public FileChooserButton(Component component, String string, int n, JTextField jTextField) {
        super("\u2026");
        this.setToolTipText(string);
        this.addActionListener(this);
        this.parent = component;
        this.toolTip = string;
        this.textField = jTextField;
        if (n == 0) {
            this.dialogType = 0;
            this.fileSelectionMode = 0;
            this.preferredFileFilter = null;
        } else if (n == 1) {
            this.dialogType = 0;
            this.fileSelectionMode = 1;
            this.preferredFileFilter = null;
        } else if (n == 2) {
            this.dialogType = 1;
            this.fileSelectionMode = 2;
            this.preferredFileFilter = null;
        } else if (n == 3) {
            this.dialogType = 1;
            this.fileSelectionMode = 2;
            this.preferredFileFilter = null;
        } else if (n == 4) {
            this.dialogType = 0;
            this.fileSelectionMode = 0;
            this.preferredFileFilter = ImageFileType.imageFileFilter;
        } else if (n == 5) {
            this.dialogType = 0;
            this.fileSelectionMode = 0;
            this.preferredFileFilter = new ReportFileFilter();
        } else {
            throw new RuntimeException("Invalid mode");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.chooser.setDialogTitle(this.toolTip);
        this.chooser.setDialogType(this.dialogType);
        this.chooser.setFileSelectionMode(this.fileSelectionMode);
        this.chooser.setSelectedFile(new File(this.textField.getText()));
        this.chooser.setFileFilter(this.preferredFileFilter);
        if (this.chooser.showOpenDialog(this.parent) == 0) {
            String string = this.chooser.getSelectedFile().getAbsolutePath();
            this.textField.setText(string);
        }
    }
}

