/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;

public class ImageComponent
extends JComponent
implements Scrollable {
    private static final long serialVersionUID = 1L;
    private ImageView imageView;
    private RangeSelectionManager rangeSelectionManager;
    private int rowHeight = 0;

    @Override
    public void setFont(Font font) {
        throw new RuntimeException("unexpected setFont interface used");
    }

    public void setComponentSize(Dimension dimension) {
        this.setPreferredSize(dimension);
    }

    public ImageComponent(ImageView imageView, RangeSelectionManager rangeSelectionManager) {
        this.imageView = imageView;
        this.rangeSelectionManager = rangeSelectionManager;
        this.updateUI();
        this.setOpaque(true);
        this.setBackground(UIManager.getColor("TextPane.background"));
    }

    public void setUI(ImageUI imageUI) {
        super.setUI(imageUI);
    }

    @Override
    public void updateUI() {
        this.setUI((ImageUI)UIManager.getUI(this));
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return "ImageUI";
    }

    public ImageView getImageView() {
        return this.imageView;
    }

    public RangeSelectionManager getRangeSelectionManager() {
        return this.rangeSelectionManager;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (this.rowHeight == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(((BasicImageUI)this.ui).getImageFont());
            this.rowHeight = fontMetrics.getHeight();
        }
        return this.rowHeight;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return rectangle.height;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }
}

