/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;

public class ImageHighlightProducer {
    private byte[] paddedPageBytes;
    private int paddingPrefixSize;
    private int availablePageSize;
    private boolean highlightMatchCase;
    private boolean[] pageHighlightFlags;

    public boolean[] getPageHighlightFlags(ImageModel.ImagePage imagePage, Vector<byte[]> vector, boolean bl) {
        this.paddedPageBytes = imagePage.paddedPageBytes;
        this.paddingPrefixSize = imagePage.paddingPrefixSize;
        this.availablePageSize = imagePage.pageBytes.length;
        this.pageHighlightFlags = new boolean[this.availablePageSize];
        this.highlightMatchCase = bl;
        this.setFlags(FeatureFieldFormatter.getImageHighlightVector(imagePage));
        if (vector != null) {
            this.setFlags(vector);
        }
        return this.pageHighlightFlags;
    }

    private byte[] getUTF16Bytes(byte[] byArray) {
        int n = byArray.length;
        if (n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[n * 2 - 1];
        for (int i = 0; i < n; ++i) {
            byArray2[i * 2] = byArray[i];
        }
        return byArray2;
    }

    private void setFlags(Vector<byte[]> vector) {
        Enumeration<byte[]> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = enumeration.nextElement();
            byte[] byArray2 = UTF8Tools.unescapeBytes(byArray);
            this.addHighlightFlags(byArray2);
            this.addHighlightFlags(this.getUTF16Bytes(byArray2));
        }
    }

    private void addHighlightFlags(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int n3 = this.paddedPageBytes.length;
        boolean[] blArray = new boolean[n3];
        for (n = 0; n < n3; ++n) {
            blArray[n] = false;
        }
        for (n = 0; n < n3 - n2; ++n) {
            int n4;
            boolean bl = true;
            for (n4 = 0; n4 < n2; ++n4) {
                byte by = this.paddedPageBytes[n + n4];
                byte by2 = byArray[n4];
                if (!this.highlightMatchCase) {
                    if (by >= 65 && by <= 90) {
                        by = (byte)(by + 32);
                    }
                    if (by2 >= 65 && by2 <= 90) {
                        by2 = (byte)(by2 + 32);
                    }
                }
                if (by == by2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            for (n4 = 0; n4 < n2; ++n4) {
                blArray[n + n4] = true;
            }
        }
        for (n = 0; n < this.availablePageSize; ++n) {
            if (!blArray[n + this.paddingPrefixSize]) continue;
            this.pageHighlightFlags[n] = true;
        }
    }
}

