/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;

public class ImageModel {
    private FeatureLine featureLine = new FeatureLine();
    private String pageForensicPath = "";
    private byte[] pageBytes = new byte[0];
    private long paddedPageOffset = 0L;
    private int paddingPrefixSize = 0;
    private ImageReader.ImageReaderResponse response = new ImageReader.ImageReaderResponse(new byte[0], 0L);
    private byte[] paddedPageBytes = new byte[0];
    private boolean[] pageHighlightFlags = new boolean[0];
    private long imageSize = 0L;
    private boolean busy = false;
    private boolean imageSelectionChanged = false;
    public final ImageReaderManager imageReaderManager = new ImageReaderManager();
    private final FeatureLineSelectionManager featureLineSelectionManager;
    private final WIndeterminateProgress busyIndicator = new WIndeterminateProgress("Reading Image");
    private final ModelChangedNotifier<Object> imageChangedNotifier = new ModelChangedNotifier();
    private ImageReaderThread imageReaderThread;
    public static final int PAGE_SIZE = 4096;
    private final Runnable fireChanged = new Runnable(){

        @Override
        public void run() {
            ImageModel.this.imageChangedNotifier.fireModelChanged(null);
        }
    };

    public ImageModel(FeatureLineSelectionManager featureLineSelectionManager) {
        this.featureLineSelectionManager = featureLineSelectionManager;
        this.featureLineSelectionManager.addFeatureLineSelectionManagerChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                FeatureLine featureLine = ImageModel.this.featureLineSelectionManager.getFeatureLineSelection();
                if (ForensicPath.isHistogram(featureLine.forensicPath)) {
                    return;
                }
                ImageModel.this.setImageSelection(featureLine);
            }
        });
    }

    public ImageModel() {
        this.featureLineSelectionManager = null;
    }

    public synchronized void setImageSelection(FeatureLine featureLine) {
        this.imageSelectionChanged = true;
        this.featureLine = featureLine;
        this.pageForensicPath = ForensicPath.getAlignedPath(featureLine.forensicPath);
        this.manageModelChanges();
    }

    public synchronized void setImageSelection(String string) {
        this.imageSelectionChanged = true;
        this.pageForensicPath = ForensicPath.getAlignedPath(string);
        this.manageModelChanges();
    }

    public synchronized void refresh() {
        this.imageSelectionChanged = true;
        this.manageModelChanges();
    }

    public void closeImageReader(File file) {
        this.imageReaderManager.close(file);
    }

    public void closeAllImageReaders() {
        this.imageReaderManager.closeAll();
    }

    public synchronized boolean isBusy() {
        return this.busy;
    }

    public synchronized ImagePage getImagePage() {
        if (this.busy) {
            WLog.log("ImageModel.getImagePage: note: blank image page provided while busy.");
            return new ImagePage(new FeatureLine(), "", new byte[0], new byte[0], 0, 4096, 0L);
        }
        return new ImagePage(this.featureLine, this.pageForensicPath, this.pageBytes, this.paddedPageBytes, this.paddingPrefixSize, 4096, this.imageSize);
    }

    public synchronized void manageModelChanges() {
        this.busy = true;
        String string = "Image file: " + FileTools.getAbsolutePath(this.featureLine.actualImageFile) + "\nFeature path: " + this.featureLine.forensicPath + "\nRequested read path: " + this.pageForensicPath;
        this.busyIndicator.startProgress(string);
        if (this.imageReaderThread == null || this.imageReaderThread.isDone) {
            if (this.featureLine.isBlank()) {
                this.imageReaderThread = null;
                this.imageSelectionChanged = false;
            }
            if (this.imageSelectionChanged) {
                SwingUtilities.invokeLater(this.fireChanged);
                long l = ForensicPath.getOffset(this.pageForensicPath);
                long l2 = l - 4096L;
                if (l2 < 0L) {
                    l2 = 0L;
                }
                if (l2 > this.imageSize) {
                    l2 = l;
                }
                this.paddingPrefixSize = (int)(l - l2);
                String string2 = ForensicPath.getAdjustedPath(this.pageForensicPath, l2);
                this.imageReaderThread = new ImageReaderThread(this, this.imageReaderManager, this.featureLine.actualImageFile, string2, this.paddingPrefixSize + 4096 + 4096);
                this.imageReaderThread.start();
                this.imageSelectionChanged = false;
            } else {
                if (this.imageReaderThread != null) {
                    ImageReader.ImageReaderResponse imageReaderResponse = this.imageReaderThread.response;
                    this.paddedPageBytes = imageReaderResponse.bytes;
                    this.setPageBytes();
                    this.imageSize = imageReaderResponse.totalSizeAtPath;
                    this.imageReaderThread = null;
                } else {
                    this.paddedPageBytes = new byte[0];
                    this.pageBytes = new byte[0];
                    this.imageSize = 0L;
                }
                this.busyIndicator.stopProgress();
                this.busy = false;
                SwingUtilities.invokeLater(this.fireChanged);
            }
        }
    }

    private byte[] getUTF16Bytes(byte[] byArray) {
        int n = byArray.length;
        if (n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[n * 2 - 1];
        for (int i = 0; i < n; ++i) {
            byArray2[i * 2] = byArray[i];
        }
        return byArray2;
    }

    private void setPageBytes() {
        int n;
        int n2 = this.paddingPrefixSize;
        if (n2 > this.paddedPageBytes.length) {
            n2 = this.paddedPageBytes.length;
        }
        if ((n = this.paddedPageBytes.length - n2) > 4096) {
            n = 4096;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        byteArrayOutputStream.write(this.paddedPageBytes, n2, n);
        this.pageBytes = byteArrayOutputStream.toByteArray();
    }

    public void addImageModelChangedListener(Observer observer) {
        this.imageChangedNotifier.addObserver(observer);
    }

    public void removeImageModelChangedListener(Observer observer) {
        this.imageChangedNotifier.deleteObserver(observer);
    }

    public static class ImagePage {
        public final FeatureLine featureLine;
        public final String pageForensicPath;
        public final byte[] pageBytes;
        public final byte[] paddedPageBytes;
        public final int paddingPrefixSize;
        public final int defaultPageSize;
        public final long imageSize;

        private ImagePage(FeatureLine featureLine, String string, byte[] byArray, byte[] byArray2, int n, int n2, long l) {
            this.featureLine = featureLine;
            this.pageForensicPath = string;
            this.pageBytes = byArray;
            this.paddedPageBytes = byArray2;
            this.paddingPrefixSize = n;
            this.defaultPageSize = n2;
            this.imageSize = l;
        }
    }
}

