/*
 * Decompiled with CFR 0.152.
 */
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class ImageView
implements CopyableLineInterface {
    private final int HEX_BYTES_PER_LINE = 16;
    private final int TEXT_BYTES_PER_LINE = 64;
    private final ImageModel imageModel;
    private final UserHighlightModel userHighlightModel;
    private final ImageHighlightProducer imageHighlightProducer;
    private final ModelChangedNotifier<Object> imageViewChangedNotifier = new ModelChangedNotifier();
    private ImageModel.ImagePage imagePage;
    private Vector<byte[]> userHighlights = new Vector();
    private boolean highlightMatchCase;
    private final Vector<ImageLine> lines = new Vector();
    private String pageForensicPath = "";
    private byte[] pageBytes = new byte[0];
    private boolean[] pageHighlightFlags = new boolean[0];
    private boolean useHexPath = false;
    private ImageLine.LineFormat lineFormat = ImageLine.LineFormat.HEX_FORMAT;
    private int fontSize = 12;
    private ChangeType changeType = ChangeType.IMAGE_PAGE_CHANGED;

    public ImageView(ImageModel imageModel, UserHighlightModel userHighlightModel) {
        this.imageModel = imageModel;
        this.userHighlightModel = userHighlightModel;
        this.imageHighlightProducer = new ImageHighlightProducer();
        this.imageModel.addImageModelChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                ImageModel.ImagePage imagePage = ImageView.this.imageModel.getImagePage();
                ImageView.this.setImagePage(imagePage);
            }
        });
        this.userHighlightModel.addUserHighlightModelChangedListener(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                Vector<byte[]> vector = ImageView.this.userHighlightModel.getUserHighlightByteVector();
                boolean bl = ImageView.this.userHighlightModel.isHighlightMatchCase();
                ImageView.this.setUserHighlights(vector, bl);
            }
        });
        this.setImagePage(this.imageModel.getImagePage());
    }

    public ImageView() {
        this.imageModel = null;
        this.userHighlightModel = null;
        this.imageHighlightProducer = new ImageHighlightProducer();
    }

    public void setImagePage(ImageModel.ImagePage imagePage) {
        this.imagePage = imagePage;
        this.pageForensicPath = imagePage.pageForensicPath;
        this.pageBytes = imagePage.pageBytes;
        this.pageHighlightFlags = this.imageHighlightProducer.getPageHighlightFlags(imagePage, this.userHighlights, this.highlightMatchCase);
        this.setLines(ChangeType.IMAGE_PAGE_CHANGED);
    }

    public ImageModel.ImagePage getImagePage() {
        return this.imagePage;
    }

    public void setUserHighlights(Vector<byte[]> vector, boolean bl) {
        this.userHighlights = vector;
        this.highlightMatchCase = bl;
        this.pageHighlightFlags = this.imageHighlightProducer.getPageHighlightFlags(this.imagePage, vector, bl);
        this.setLines(ChangeType.USER_HIGHLIGHT_CHANGED);
    }

    public void setUseHexPath(boolean bl) {
        this.useHexPath = bl;
        this.setLines(ChangeType.FORENSIC_PATH_NUMERIC_BASE_CHANGED);
    }

    public boolean getUseHexPath() {
        return this.useHexPath;
    }

    public void setLineFormat(ImageLine.LineFormat lineFormat) {
        this.lineFormat = lineFormat;
        this.setLines(ChangeType.LINE_FORMAT_CHANGED);
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public ImageLine.LineFormat getLineFormat() {
        return this.lineFormat;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
        this.setLines(ChangeType.FONT_SIZE_CHANGED);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public ImageLine getLine(int n) {
        if (n >= this.lines.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.lines.get(n);
    }

    public int getNumLines() {
        return this.lines.size();
    }

    private void setLines(ChangeType changeType) {
        this.changeType = changeType;
        this.lines.clear();
        if (this.lineFormat == ImageLine.LineFormat.HEX_FORMAT) {
            this.setHexLines();
        } else if (this.lineFormat == ImageLine.LineFormat.TEXT_FORMAT) {
            this.setTextLines();
        } else {
            throw new IllegalArgumentException();
        }
        this.imageViewChangedNotifier.fireModelChanged(null);
    }

    private void setHexLines() {
        long l = ForensicPath.getOffset(this.pageForensicPath);
        String string = ForensicPath.getAdjustedPath(this.pageForensicPath, l + 4096L);
        String string2 = ForensicPath.getPrintablePath(string, this.useHexPath);
        for (int i = 0; i < this.pageBytes.length; i += 16) {
            int n;
            int[] nArray = new int[80];
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer(80);
            String string3 = ForensicPath.getAdjustedPath(this.pageForensicPath, l + (long)i);
            String string4 = ForensicPath.getPrintablePath(string3, this.useHexPath);
            stringBuffer.append(string4);
            for (n = string4.length(); n < string2.length(); ++n) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("  ");
            for (n = 0; n < 16; ++n) {
                if (i + n < this.pageBytes.length) {
                    byte by;
                    if (this.pageHighlightFlags[i + n]) {
                        nArray[n2++] = stringBuffer.length();
                    }
                    if ((by = this.pageBytes[i + n]) > 31 && by < 127) {
                        stringBuffer.append((char)by);
                        continue;
                    }
                    stringBuffer.append(".");
                    continue;
                }
                stringBuffer.append(" ");
            }
            for (n = 0; n < 16; ++n) {
                if (n % 4 == 0) {
                    stringBuffer.append("  ");
                } else {
                    stringBuffer.append(" ");
                }
                if (i + n < this.pageBytes.length) {
                    if (this.pageHighlightFlags[i + n]) {
                        nArray[n2++] = stringBuffer.length();
                        nArray[n2++] = stringBuffer.length() + 1;
                    }
                    try {
                        stringBuffer.append(String.format("%1$02x", this.pageBytes[i + n]));
                        continue;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
                stringBuffer.append("  ");
            }
            String string5 = stringBuffer.toString();
            ImageLine imageLine = new ImageLine(string3, string5, nArray, n2);
            this.lines.add(imageLine);
        }
    }

    public int getForensicPathLineIndex(String string) {
        int n;
        if (this.lineFormat == ImageLine.LineFormat.HEX_FORMAT) {
            n = 16;
        } else if (this.lineFormat == ImageLine.LineFormat.TEXT_FORMAT) {
            n = 64;
        } else {
            throw new IllegalArgumentException();
        }
        long l = ForensicPath.getOffset(string);
        long l2 = ForensicPath.getOffset(this.pageForensicPath);
        int n2 = (int)((l - l2) / (long)n);
        if (n2 < 0 || n2 > this.lines.size()) {
            return -1;
        }
        return n2;
    }

    private void setTextLines() {
        long l = ForensicPath.getOffset(this.pageForensicPath);
        String string = ForensicPath.getAdjustedPath(this.pageForensicPath, l + 4096L);
        String string2 = ForensicPath.getPrintablePath(string, this.useHexPath);
        for (int i = 0; i < this.pageBytes.length; i += 64) {
            int n;
            int[] nArray = new int[64];
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer(64);
            String string3 = ForensicPath.getAdjustedPath(this.pageForensicPath, l + (long)i);
            String string4 = ForensicPath.getPrintablePath(string3, this.useHexPath);
            stringBuffer.append(string4);
            for (n = string4.length(); n < string2.length(); ++n) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("  ");
            for (n = 0; n < 64; ++n) {
                byte by;
                if (i + n >= this.pageBytes.length) continue;
                if (this.pageHighlightFlags[i + n]) {
                    nArray[n2++] = stringBuffer.length();
                }
                if ((by = this.pageBytes[i + n]) > 31 && by < 127) {
                    stringBuffer.append((char)by);
                    continue;
                }
                stringBuffer.append(".");
            }
            String string5 = stringBuffer.toString();
            ImageLine imageLine = new ImageLine(string3, string5, nArray, n2);
            this.lines.add(imageLine);
        }
    }

    @Override
    public String getCopyableLine(int n) {
        return this.getLine((int)n).text;
    }

    public void addImageViewChangedListener(Observer observer) {
        this.imageViewChangedNotifier.addObserver(observer);
    }

    public void removeImageViewChangedListener(Observer observer) {
        this.imageViewChangedNotifier.deleteObserver(observer);
    }

    public static final class ChangeType {
        public static final ChangeType IMAGE_PAGE_CHANGED = new ChangeType("Image page changed");
        public static final ChangeType USER_HIGHLIGHT_CHANGED = new ChangeType("User highlight changed");
        public static final ChangeType FORENSIC_PATH_NUMERIC_BASE_CHANGED = new ChangeType("Forensic path numeric base changed");
        public static final ChangeType LINE_FORMAT_CHANGED = new ChangeType("Line format changed");
        public static final ChangeType FONT_SIZE_CHANGED = new ChangeType("Font size changed");
        private final String name;

        private ChangeType(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

