/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Observer;

public class ReportSelectionManager {
    private ReportSelectionType activeReportSelectionType = ReportSelectionType.NONE;
    private File imageFile = null;
    private File featuresFile = null;
    private File histogramFile = null;
    private File referencedFeaturesFile = null;
    private ReportSelectionType reportSelectionType = ReportSelectionType.NONE;
    private ChangeType changeType = ChangeType.SELECTION_CHANGED;
    private boolean requestHideReferencedFeatureView = false;
    private final ModelChangedNotifier<Object> reportSelectionManagerChangedNotifier = new ModelChangedNotifier();

    public void setReportSelection(File file, File file2) {
        this.imageFile = file;
        if (file2 == null) {
            this.featuresFile = null;
            this.histogramFile = null;
            this.referencedFeaturesFile = null;
            this.reportSelectionType = ReportSelectionType.NONE;
        } else if (this.isHistogramFile(file2)) {
            this.featuresFile = null;
            this.histogramFile = file2;
            this.referencedFeaturesFile = this.getReferencedFile(this.histogramFile);
            this.reportSelectionType = ReportSelectionType.HISTOGRAM;
        } else {
            this.featuresFile = file2;
            this.histogramFile = null;
            this.referencedFeaturesFile = null;
            this.reportSelectionType = ReportSelectionType.FEATURES;
        }
        WLog.log("ReportSelectionManager.setReportSelection image file: " + file + ", features file: " + file2 + ", selection type: " + this.reportSelectionType);
        this.fire(ChangeType.SELECTION_CHANGED);
    }

    private void fire(ChangeType changeType) {
        this.changeType = changeType;
        this.reportSelectionManagerChangedNotifier.fireModelChanged(null);
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public ReportSelectionType getReportSelectionType() {
        return this.reportSelectionType;
    }

    private boolean isHistogramFile(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[]{-17, -69, -65};
            byte[] byArray2 = new byte[3];
            ((InputStream)fileInputStream).read(byArray2);
            if (byArray2[0] != byArray[0] || byArray2[1] != byArray[1] || byArray2[2] != byArray[2]) {
                fileInputStream = new FileInputStream(file);
                WLog.log("ReportSelectionManager.isHistogramFile: Note: File " + file + " does not contain a UTF-8 Byte Order Mark.");
            }
            while ((n = ((InputStream)fileInputStream).read()) == 35) {
                do {
                    if ((n = ((InputStream)fileInputStream).read()) != -1) continue;
                    return false;
                } while (n != 10);
            }
            return n == 110 && (n = ((InputStream)fileInputStream).read()) == 61;
        }
        catch (Exception exception) {
            WError.showError("Unable to evaluate Feature File type for file " + file, "Read error", exception);
            return false;
        }
    }

    private File getReferencedFile(File file) {
        String string = file.getAbsolutePath();
        int n = string.lastIndexOf(95);
        if (n < 0 || !string.endsWith(".txt")) {
            WError.showError("Unexpected Histogram filename: " + string, "Histogram Filename Error", null);
            return null;
        }
        String string2 = string.substring(0, n) + ".txt";
        File file2 = new File(string2);
        if (file2.exists()) {
            return file2;
        }
        return this.getReferencedFile(file2);
    }

    public void setRequestHideReferencedFeatureView(boolean bl) {
        if (this.requestHideReferencedFeatureView != bl) {
            this.requestHideReferencedFeatureView = bl;
            this.fire(ChangeType.PREFERENCE_CHANGED);
        }
    }

    public boolean isRequestHideReferencedFeatureView() {
        return this.requestHideReferencedFeatureView;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public File getFeaturesFile() {
        return this.featuresFile;
    }

    public File getHistogramFile() {
        return this.histogramFile;
    }

    public File getReferencedFeaturesFile() {
        return this.referencedFeaturesFile;
    }

    public void addReportSelectionManagerChangedListener(Observer observer) {
        this.reportSelectionManagerChangedNotifier.addObserver(observer);
    }

    public void removeReportSelectionManagerChangedListener(Observer observer) {
        this.reportSelectionManagerChangedNotifier.deleteObserver(observer);
    }

    public static final class ChangeType {
        public static final ChangeType SELECTION_CHANGED = new ChangeType("Selection changed");
        public static final ChangeType PREFERENCE_CHANGED = new ChangeType("User view preference changed");
        private final String name;

        private ChangeType(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class ReportSelectionType {
        public static final ReportSelectionType NONE = new ReportSelectionType("None");
        public static final ReportSelectionType HISTOGRAM = new ReportSelectionType("Histogram file");
        public static final ReportSelectionType FEATURES = new ReportSelectionType("Features file");
        private final String name;

        private ReportSelectionType(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

