/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.SwingUtilities;

public class ScanSettingsListModel
extends AbstractListModel {
    public final DefaultListSelectionModel selectionModel;
    private final Vector<ScanSettings> jobs = new Vector();

    public ScanSettingsListModel() {
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.setSelectionMode(0);
    }

    private void doRun(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                WLog.log("ScanSettingsListModel.doRun error");
                WLog.logThrowable(exception);
            }
        }
    }

    public void add(ScanSettings scanSettings) {
        RunnableAdd runnableAdd = new RunnableAdd(scanSettings);
        this.doRun(runnableAdd);
    }

    public ScanSettings remove() {
        RunnableRemoveTop runnableRemoveTop = new RunnableRemoveTop();
        this.doRun(runnableRemoveTop);
        return runnableRemoveTop.scanSettings;
    }

    public boolean remove(ScanSettings scanSettings) {
        RunnableRemoveJob runnableRemoveJob = new RunnableRemoveJob(scanSettings);
        this.doRun(runnableRemoveJob);
        return runnableRemoveJob.removed;
    }

    public boolean moveUp(ScanSettings scanSettings) {
        RunnableMoveUp runnableMoveUp = new RunnableMoveUp(scanSettings);
        this.doRun(runnableMoveUp);
        return runnableMoveUp.moved;
    }

    public boolean moveDown(ScanSettings scanSettings) {
        RunnableMoveDown runnableMoveDown = new RunnableMoveDown(scanSettings);
        this.doRun(runnableMoveDown);
        return runnableMoveDown.moved;
    }

    @Override
    public int getSize() {
        RunnableGetSize runnableGetSize = new RunnableGetSize();
        this.doRun(runnableGetSize);
        return runnableGetSize.size;
    }

    @Override
    public ScanSettings getElementAt(int n) {
        RunnableGetElementAt runnableGetElementAt = new RunnableGetElementAt(n);
        this.doRun(runnableGetElementAt);
        return runnableGetElementAt.scanSettings;
    }

    private class RunnableGetElementAt
    implements Runnable {
        private final int index;
        private ScanSettings scanSettings;

        RunnableGetElementAt(int n) {
            this.index = n;
        }

        @Override
        public void run() {
            this.scanSettings = (ScanSettings)ScanSettingsListModel.this.jobs.get(this.index);
        }
    }

    private class RunnableGetSize
    implements Runnable {
        private int size;

        private RunnableGetSize() {
        }

        @Override
        public void run() {
            this.size = ScanSettingsListModel.this.jobs.size();
        }
    }

    private class RunnableMoveDown
    implements Runnable {
        private final ScanSettings scanSettings;
        private boolean moved = false;

        RunnableMoveDown(ScanSettings scanSettings) {
            this.scanSettings = scanSettings;
        }

        @Override
        public void run() {
            int n = ScanSettingsListModel.this.jobs.indexOf(this.scanSettings);
            if (n != -1 && n < ScanSettingsListModel.this.jobs.size() - 1) {
                ScanSettings scanSettings = ScanSettingsListModel.this.jobs.set(n + 1, this.scanSettings);
                ScanSettings scanSettings2 = ScanSettingsListModel.this.jobs.set(n, scanSettings);
                this.moved = true;
            } else {
                WLog.log("ScanSettingsRunQueue.moveDown: failure at index " + n);
            }
            if (this.moved) {
                ScanSettingsListModel.this.fireContentsChanged(this, n, n + 1);
                ScanSettingsListModel.this.selectionModel.setSelectionInterval(n + 1, n + 1);
            }
        }
    }

    private class RunnableMoveUp
    implements Runnable {
        private final ScanSettings scanSettings;
        private boolean moved = false;

        RunnableMoveUp(ScanSettings scanSettings) {
            this.scanSettings = scanSettings;
        }

        @Override
        public void run() {
            int n = ScanSettingsListModel.this.jobs.indexOf(this.scanSettings);
            if (n > 0) {
                ScanSettings scanSettings = ScanSettingsListModel.this.jobs.set(n - 1, this.scanSettings);
                ScanSettings scanSettings2 = ScanSettingsListModel.this.jobs.set(n, scanSettings);
                this.moved = true;
            } else {
                WLog.log("ScanSettingsRunQueue.moveUp: failure at index " + n);
            }
            if (this.moved) {
                ScanSettingsListModel.this.fireContentsChanged(this, n - 1, n);
                ScanSettingsListModel.this.selectionModel.setSelectionInterval(n - 1, n - 1);
            }
        }
    }

    private class RunnableRemoveJob
    implements Runnable {
        private final ScanSettings scanSettings;
        private boolean removed = false;

        RunnableRemoveJob(ScanSettings scanSettings) {
            this.scanSettings = scanSettings;
        }

        @Override
        public void run() {
            int n = ScanSettingsListModel.this.jobs.indexOf(this.scanSettings);
            if (n >= 0) {
                WLog.log("ScanSettingsListModel.remove job '" + this.scanSettings.getCommandString() + "'");
                ScanSettingsListModel.this.jobs.remove(n);
                this.removed = true;
            } else {
                WLog.log("ScanSettingsRunQueue.remove scanSettings: no element to remove");
            }
            if (this.removed) {
                ScanSettingsListModel.this.fireIntervalRemoved(this, n, n);
            }
        }
    }

    private class RunnableRemoveTop
    implements Runnable {
        private ScanSettings scanSettings = null;

        private RunnableRemoveTop() {
        }

        @Override
        public void run() {
            boolean bl = false;
            if (ScanSettingsListModel.this.jobs.size() >= 1) {
                WLog.log("ScanSettingsListModel.remove top job '" + ((ScanSettings)ScanSettingsListModel.this.jobs.get(0)).getCommandString() + "'");
                this.scanSettings = (ScanSettings)ScanSettingsListModel.this.jobs.remove(0);
                bl = true;
            } else {
                WLog.log("ScanSettingsRunQueue.remove top: no top element to remove");
            }
            if (bl) {
                ScanSettingsListModel.this.fireIntervalRemoved(this, 0, 0);
            }
        }
    }

    private class RunnableAdd
    implements Runnable {
        private final ScanSettings scanSettings;

        public RunnableAdd(ScanSettings scanSettings) {
            this.scanSettings = scanSettings;
        }

        @Override
        public void run() {
            WLog.log("ScanSettingsListModel.add job '" + this.scanSettings.getCommandString() + "'");
            ScanSettingsListModel.this.jobs.add(this.scanSettings);
            ScanSettingsListModel.this.fireIntervalAdded(this, ScanSettingsListModel.this.jobs.size() - 1, ScanSettingsListModel.this.jobs.size() - 1);
            ScanSettingsListModel.this.selectionModel.setSelectionInterval(ScanSettingsListModel.this.jobs.size() - 1, ScanSettingsListModel.this.jobs.size() - 1);
        }
    }
}

