/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;

public class UTF8Tools {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset UTF_16 = Charset.forName("UTF-16");
    public static final Charset UTF_16LE = Charset.forName("UTF-16LE");
    public static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    private static final byte[] ESC_NULL = new byte[]{92, 120, 48, 48};
    private static final byte[] ESC_BACKSLASH = new byte[]{92, 120, 53, 67};

    public static byte[] unescapeBytes(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] == 92 && n + 3 < byArray.length) {
                if (byArray[n + 1] == 120 && (byArray[n + 2] >= 48 && byArray[n + 2] <= 57 || byArray[n + 2] >= 97 && byArray[n + 2] <= 102 || byArray[n + 2] >= 65 && byArray[n + 2] <= 70) && (byArray[n + 3] >= 48 && byArray[n + 3] <= 57 || byArray[n + 3] >= 97 && byArray[n + 3] <= 102 || byArray[n + 3] >= 65 && byArray[n + 3] <= 70)) {
                    int n2 = byArray[n + 2] <= 57 ? (byArray[n + 2] - 48) * 16 : (byArray[n + 2] <= 70 ? (byArray[n + 2] - 65 + 10) * 16 : (byArray[n + 2] - 97 + 10) * 16);
                    int n3 = byArray[n + 3] <= 57 ? (byArray[n + 3] - 48) * 16 : (byArray[n + 3] <= 70 ? (byArray[n + 3] - 65 + 10) * 16 : (byArray[n + 3] - 97 + 10) * 16);
                    byteArrayOutputStream.write(n2 * 16 + n3 * 1);
                    n += 4;
                    continue;
                }
                if (byArray[n + 1] >= 48 && byArray[n + 1] <= 51 && byArray[n + 2] >= 48 && byArray[n + 2] <= 55 && byArray[n + 3] >= 48 && byArray[n + 3] <= 55) {
                    byteArrayOutputStream.write((byArray[n + 1] - 48) * 64 + (byArray[n + 2] - 48) * 8 + (byArray[n + 3] - 48) * 1);
                    n += 4;
                    continue;
                }
                byteArrayOutputStream.write(byArray[n]);
                ++n;
                continue;
            }
            byteArrayOutputStream.write(byArray[n]);
            ++n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] unescapeEscape(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] == 92 && n + 3 < byArray.length) {
                if (byArray[n + 1] == 49 && byArray[n + 2] == 51 && byArray[n + 3] == 52 || byArray[n + 1] == 120 && byArray[n + 1] == 53 && (byArray[n + 2] == 67 || byArray[n + 2] == 99)) {
                    byteArrayOutputStream.write(92);
                    n += 4;
                    continue;
                }
                byteArrayOutputStream.write(byArray[n]);
                ++n;
                continue;
            }
            byteArrayOutputStream.write(byArray[n]);
            ++n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] utf8To16Basic(byte[] byArray) {
        if (byArray.length < 2) {
            return byArray;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < byArray.length - 1; ++i) {
            byteArrayOutputStream.write(byArray[i]);
            byteArrayOutputStream.write(ESC_NULL, 0, 4);
        }
        byteArrayOutputStream.write(byArray[byArray.length - 1]);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] utf16To8Basic(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < byArray.length; ++i) {
            if (i + 4 <= byArray.length && byArray[i + 0] == 92 && (byArray[i + 1] == 120 && byArray[i + 2] == 48 && byArray[i + 3] == 48 || byArray[i + 1] == 48 && byArray[i + 2] == 48 && byArray[i + 3] == 48)) {
                i += 3;
                continue;
            }
            byteArrayOutputStream.write(byArray[i]);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toLower(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by >= 65 && by <= 90) {
                byteArrayOutputStream.write((byte)(by + 32));
                continue;
            }
            byteArrayOutputStream.write(by);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean bytesMatch(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return false;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean escapedLooksLikeUTF16(byte[] byArray) {
        byte[] byArray2 = UTF8Tools.unescapeBytes(byArray);
        int n = 0;
        int n2 = 0;
        if (byArray2.length < 2) {
            return false;
        }
        for (int i = 0; i < byArray2.length - 1; i += 2) {
            if (byArray2[i] == 0) {
                ++n;
            }
            if (byArray2[i + 1] != 0) continue;
            ++n2;
        }
        return n > 1 && n2 == 0 || n == 0 && n2 > 1;
    }

    public static byte[] stripNulls(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] == 92 && n + 3 < byArray.length) {
                if (byArray[n + 1] == 48 && byArray[n + 2] == 48 && byArray[n + 3] == 48 || byArray[n + 1] == 120 && byArray[n + 2] == 48 && byArray[n + 3] == 48) {
                    n += 4;
                    continue;
                }
                byteArrayOutputStream.write(byArray[n]);
                ++n;
                continue;
            }
            byteArrayOutputStream.write(byArray[n]);
            ++n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] stringToBytes(String string, Charset charset) {
        return string.getBytes(charset);
    }
}

