/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class WExportWorkSettings
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static WExportWorkSettings wExportWorkSettings;
    private File workSettingsFile = null;
    private JTextField filenameTF = new JTextField();
    private JButton directoryChooserB = new FileChooserButton(BEViewer.getBEWindow(), "Export Work Settings to", 2, this.filenameTF);
    private JButton exportB = new JButton("Export");
    private JButton cancelB = new JButton("Cancel");

    public static void openWindow() {
        if (wExportWorkSettings == null) {
            wExportWorkSettings = new WExportWorkSettings();
        }
        wExportWorkSettings.setLocationRelativeTo(BEViewer.getBEWindow());
        wExportWorkSettings.setVisible(true);
    }

    private WExportWorkSettings() {
        this.buildInterface();
        this.wireActions();
        this.getRootPane().setDefaultButton(this.exportB);
        this.pack();
    }

    private void buildInterface() {
        this.setTitle("Export Work Settings");
        this.setModal(true);
        this.setAlwaysOnTop(true);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        container.add(this.buildFilePath(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        container.add(this.buildControls(), gridBagConstraints);
    }

    private Component buildFilePath() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        container.add((Component)new JLabel("Work Settings File"), gridBagConstraints);
        this.filenameTF.setMinimumSize(new Dimension(250, this.filenameTF.getPreferredSize().height));
        this.filenameTF.setPreferredSize(new Dimension(250, this.filenameTF.getPreferredSize().height));
        this.filenameTF.setToolTipText("Export opened Report and Bookmark settings to this file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.filenameTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        container.add((Component)this.directoryChooserB, gridBagConstraints);
        return container;
    }

    private Component buildControls() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        container.add((Component)this.exportB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        container.add((Component)this.cancelB, gridBagConstraints);
        return container;
    }

    private void wireActions() {
        this.directoryChooserB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle("Export Work Settings As");
                jFileChooser.setDialogType(1);
                jFileChooser.setFileSelectionMode(2);
                if (jFileChooser.showOpenDialog(wExportWorkSettings) == 0) {
                    String string = jFileChooser.getSelectedFile().getAbsolutePath();
                    WExportWorkSettings.this.filenameTF.setText(string);
                }
            }
        });
        this.exportB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WExportWorkSettings.this.workSettingsFile = new File(WExportWorkSettings.this.filenameTF.getText());
                boolean bl = WExportWorkSettings.this.exportWorkSettings();
                if (bl) {
                    WExportWorkSettings.this.setVisible(false);
                }
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WExportWorkSettings.this.setVisible(false);
            }
        });
    }

    private boolean exportWorkSettings() {
        if (this.workSettingsFile.exists()) {
            WError.showError("File " + this.workSettingsFile + " already exists.", "BEViewer file error", null);
            return false;
        }
        try {
            if (!this.workSettingsFile.createNewFile()) {
                WError.showError("File " + this.workSettingsFile + " already exists.", "BEViewer file error", null);
                return false;
            }
        }
        catch (IOException iOException) {
            WError.showError("File " + this.workSettingsFile + " cannot be created.", "BEViewer file error", iOException);
            return false;
        }
        boolean bl = BEPreferences.exportWorkSettings(this.workSettingsFile);
        return bl;
    }
}

