/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class WImportScanSettings
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextField settingsTF = new JTextField();
    private JButton importB = new JButton("Import");
    private JButton cancelB = new JButton("Cancel");

    public WImportScanSettings(String string) {
        this.setLocationRelativeTo(BEViewer.getBEWindow());
        this.buildInterface();
        this.wireActions();
        this.getRootPane().setDefaultButton(this.importB);
        this.settingsTF.setText(string);
        this.pack();
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    private void buildInterface() {
        this.setTitle("Import Scan Settings");
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        container.add(this.buildSettingsInput(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        container.add(this.buildControls(), gridBagConstraints);
    }

    private Component buildSettingsInput() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        container.add((Component)new JLabel("Settings Text"), gridBagConstraints);
        this.settingsTF.setPreferredSize(new Dimension(600, this.settingsTF.getPreferredSize().height));
        this.settingsTF.setToolTipText("Import settings from command line text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.settingsTF, gridBagConstraints);
        return container;
    }

    private Component buildControls() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        container.add((Component)this.importB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        container.add((Component)this.cancelB, gridBagConstraints);
        return container;
    }

    private void wireActions() {
        this.importB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScanSettings scanSettings = new ScanSettings(WImportScanSettings.this.settingsTF.getText());
                if (scanSettings.validTokens && scanSettings.validateSomeSettings()) {
                    WScan.openWindow(scanSettings);
                    WImportScanSettings.this.setVisible(false);
                }
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WImportScanSettings.this.setVisible(false);
            }
        });
    }
}

