/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class WImportWorkSettings
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static WImportWorkSettings wImportWorkSettings;
    private JTextField filenameTF = new JTextField();
    private JButton fileChooserB = new FileChooserButton(BEViewer.getBEWindow(), "Import Work Settings From", 0, this.filenameTF);
    private JCheckBox keepExistingWorkSettingsCB = new JCheckBox("Keep Existing Work Settings");
    private JButton importB = new JButton("Import");
    private JButton cancelB = new JButton("Cancel");

    public static void openWindow() {
        if (wImportWorkSettings == null) {
            wImportWorkSettings = new WImportWorkSettings();
        }
        wImportWorkSettings.setLocationRelativeTo(BEViewer.getBEWindow());
        wImportWorkSettings.setVisible(true);
    }

    private WImportWorkSettings() {
        this.buildInterface();
        this.wireActions();
        this.getRootPane().setDefaultButton(this.importB);
        this.pack();
    }

    private void buildInterface() {
        this.setTitle("Import Work Settings");
        this.setModal(true);
        this.setAlwaysOnTop(true);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        container.add(this.buildFilePath(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        container.add(this.buildOptionControl(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        container.add(this.buildControls(), gridBagConstraints);
    }

    private Component buildFilePath() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        container.add((Component)new JLabel("Work Settings File"), gridBagConstraints);
        this.filenameTF.setMinimumSize(new Dimension(250, this.filenameTF.getPreferredSize().height));
        this.filenameTF.setPreferredSize(new Dimension(250, this.filenameTF.getPreferredSize().height));
        this.filenameTF.setToolTipText("Import opened Report and Bookmark settings from this file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.filenameTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        container.add((Component)this.fileChooserB, gridBagConstraints);
        return container;
    }

    private Component buildOptionControl() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.keepExistingWorkSettingsCB.setToolTipText("Do not clear opened Reports and Bookmarks that are already active");
        container.add((Component)this.keepExistingWorkSettingsCB, gridBagConstraints);
        return container;
    }

    private Component buildControls() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        container.add((Component)this.importB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        container.add((Component)this.cancelB, gridBagConstraints);
        return container;
    }

    private void wireActions() {
        this.importB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                File file = new File(WImportWorkSettings.this.filenameTF.getText());
                boolean bl2 = BEPreferences.importWorkSettings(file, bl = WImportWorkSettings.this.keepExistingWorkSettingsCB.isSelected());
                if (bl2) {
                    WImportWorkSettings.this.setVisible(false);
                }
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WImportWorkSettings.this.setVisible(false);
            }
        });
    }
}

