/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class WIndeterminateProgress {
    private DelayerThread delayerThread;
    private final JDialog window;
    private final JProgressBar bar;
    private final JTextArea textArea = new JTextArea();

    public WIndeterminateProgress(String string) {
        this.window = new JDialog(BEViewer.getBEWindow(), string, false);
        this.window.setFocusableWindowState(false);
        this.window.setDefaultCloseOperation(0);
        Container container = this.window.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.textArea.setMinimumSize(new Dimension(400, 100));
        this.textArea.setPreferredSize(new Dimension(400, 100));
        this.textArea.setEditable(false);
        container.add((Component)this.textArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.bar = new JProgressBar();
        this.bar.setStringPainted(true);
        this.bar.setString("Reading");
        this.bar.setIndeterminate(true);
        this.bar.setMinimumSize(new Dimension(100, 16));
        this.bar.setPreferredSize(new Dimension(100, 16));
        container.add((Component)this.bar, gridBagConstraints);
        this.window.pack();
    }

    public synchronized void startProgress(String string) {
        SwingUtilities.invokeLater(new SwingSetText(string));
        if (this.delayerThread != null) {
            this.delayerThread.interrupt();
            this.delayerThread = null;
        }
        this.delayerThread = new DelayerThread();
        this.delayerThread.start();
    }

    public synchronized void stopProgress() {
        if (this.delayerThread == null) {
            WLog.log("WIndeterminateProgress stopProgress error: stop without start.");
        } else {
            this.delayerThread.interrupt();
            this.delayerThread = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WIndeterminateProgress.this.window.setVisible(false);
            }
        });
    }

    private class DelayerThread
    extends Thread {
        private static final int DELAY = 300;

        private DelayerThread() {
        }

        @Override
        public void run() {
            try {
                DelayerThread.sleep(300L);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WIndeterminateProgress.this.window.toFront();
                        WIndeterminateProgress.this.window.setLocationRelativeTo(BEViewer.getBEWindow());
                        WIndeterminateProgress.this.window.setVisible(true);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class SwingSetText
    extends Thread {
        String text;

        SwingSetText(String string) {
            this.text = string;
        }

        @Override
        public void run() {
            WIndeterminateProgress.this.textArea.setText(this.text);
        }
    }
}

