/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WOpen
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static WOpen wOpen;
    private final JTextField reportFileTF = new JTextField(30);
    private final JButton reportFileB = new FileChooserButton(BEViewer.getBEWindow(), "Select Report File (report.xml)", 5, this.reportFileTF);
    private final JRadioButton defaultImageFileRB = new JRadioButton("Use path from Report:");
    private final PathComponent defaultImageFileLabel = new PathComponent();
    private final JRadioButton customImageFileRB = new JRadioButton("Select custom path:");
    private final JRadioButton noImageFileRB = new JRadioButton("No Image File");
    private final ButtonGroup imageFileGroup = new ButtonGroup();
    private final JTextField customImageFileTF = new JTextField(30);
    private final JButton customImageFileB = new FileChooserButton(BEViewer.getBEWindow(), "Select Image File", 4, this.customImageFileTF);
    private final JButton okB = new JButton("OK");
    private final JButton cancelB = new JButton("Cancel");
    private ImagePathPreference imagePathPreference;
    private static final String REPORT_FILE_NAME_STRING = "report.xml";
    private final DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder builder;
    private static final FileFilter reportFileFilter;

    public static void openWindow() {
        if (wOpen == null) {
            wOpen = new WOpen();
        }
        wOpen.setInitialFiles();
        wOpen.setLocationRelativeTo(BEViewer.getBEWindow());
        wOpen.setVisible(true);
    }

    private void setReportFile(File file) {
        this.reportFileTF.setText(file == null ? "" : file.getPath());
    }

    private void setDefaultImageFile(File file) {
        this.defaultImageFileLabel.setPath(file);
    }

    private void setCustomImageFile(File file) {
        this.customImageFileTF.setText(file == null ? "" : file.getPath());
    }

    private void setImagePathPreference(ImagePathPreference imagePathPreference) {
        this.imagePathPreference = imagePathPreference;
        if (imagePathPreference == ImagePathPreference.DEFAULT) {
            this.defaultImageFileRB.setSelected(true);
            this.defaultImageFileLabel.setEnabled(true);
            this.customImageFileTF.setEnabled(false);
            this.customImageFileB.setEnabled(false);
        } else if (imagePathPreference == ImagePathPreference.CUSTOM) {
            this.customImageFileRB.setSelected(true);
            this.defaultImageFileLabel.setEnabled(false);
            this.customImageFileTF.setEnabled(true);
            this.customImageFileB.setEnabled(true);
        } else if (imagePathPreference == ImagePathPreference.NONE) {
            this.noImageFileRB.setSelected(true);
            this.defaultImageFileLabel.setEnabled(false);
            this.customImageFileTF.setEnabled(false);
            this.customImageFileB.setEnabled(false);
        } else {
            throw new RuntimeException("Invalid type");
        }
    }

    private void setInitialFiles() {
        Object object;
        TreePath treePath = BEViewer.reportsModel.getSelectedTreePath();
        ReportsModel.ReportTreeNode reportTreeNode = ReportsModel.getReportTreeNodeFromTreePath(treePath);
        if (reportTreeNode == null && (object = BEViewer.reportsModel.elements()).hasMoreElements()) {
            reportTreeNode = (ReportsModel.ReportTreeNode)object.nextElement();
        }
        if (reportTreeNode != null) {
            object = reportTreeNode.featuresDirectory;
            File file = new File((File)object, REPORT_FILE_NAME_STRING);
            this.setReportFile(file);
            File file2 = this.readDefaultImageFile(file);
            this.setDefaultImageFile(file2);
            this.setCustomImageFile(reportTreeNode.reportImageFile);
        } else {
            this.setReportFile(null);
            this.setDefaultImageFile(null);
            this.setCustomImageFile(null);
        }
        this.setImagePathPreference(ImagePathPreference.DEFAULT);
    }

    private File readDefaultImageFile(File file) {
        Document document;
        if (file == null || file.isDirectory() || !file.canRead() || !file.getName().equals(REPORT_FILE_NAME_STRING)) {
            return null;
        }
        try {
            this.builder.reset();
            document = this.builder.parse(new File(file.getPath()));
        }
        catch (IOException iOException) {
            WLog.log("WOpen XML parser: IO failure in file " + file.getPath());
            return null;
        }
        catch (SAXException sAXException) {
            WLog.log("WOpen XML parser: SAX failure in file " + file.getPath());
            return null;
        }
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            String string = xPath.evaluate("/dfxml/source/image_filename", document);
            if (string.equals("")) {
                WLog.log("WOpen XML parser: unable to parse image filename from report file at XPath /dfxml/source/image_filename");
                return null;
            }
            return new File(string);
        }
        catch (XPathExpressionException xPathExpressionException) {
            WLog.log("WOpen XML parser: unable to parse image filename from report file");
            return null;
        }
    }

    private WOpen() {
        super(BEViewer.getBEWindow(), "Open Report", true);
        this.setComponents();
        this.wireActions();
        this.getRootPane().setDefaultButton(this.okB);
        try {
            this.builder = this.builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            WError.showError("Parser failure.", "BEViewer file error", parserConfigurationException);
        }
        this.pack();
    }

    private void setComponents() {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        container.add((Component)this.getInputs(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 20, 20, 20);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        container.add(this.getControls(), gridBagConstraints);
    }

    private Container getInputs() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 21;
        container.add((Component)new JLabel("Report File (report.xml)"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        container.add((Component)this.reportFileTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.reportFileB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(20, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 21;
        container.add((Component)new JLabel("Image File"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.defaultImageFileRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        container.add((Component)this.defaultImageFileLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.customImageFileRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        container.add((Component)this.customImageFileTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.customImageFileB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 21;
        container.add((Component)this.noImageFileRB, gridBagConstraints);
        this.imageFileGroup.add(this.defaultImageFileRB);
        this.imageFileGroup.add(this.customImageFileRB);
        this.imageFileGroup.add(this.noImageFileRB);
        return container;
    }

    private Component getControls() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        container.add((Component)this.okB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        container.add((Component)this.cancelB, gridBagConstraints);
        return container;
    }

    private void wireActions() {
        this.reportFileTF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                WOpen.this.setDefaultImageFile(WOpen.this.readDefaultImageFile(new File(WOpen.this.reportFileTF.getText())));
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                WOpen.this.setDefaultImageFile(WOpen.this.readDefaultImageFile(new File(WOpen.this.reportFileTF.getText())));
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                WOpen.this.setDefaultImageFile(WOpen.this.readDefaultImageFile(new File(WOpen.this.reportFileTF.getText())));
            }
        });
        this.defaultImageFileRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WOpen.this.setImagePathPreference(ImagePathPreference.DEFAULT);
            }
        });
        this.customImageFileRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WOpen.this.setImagePathPreference(ImagePathPreference.CUSTOM);
            }
        });
        this.noImageFileRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WOpen.this.setImagePathPreference(ImagePathPreference.NONE);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                wOpen.setVisible(false);
            }
        });
        this.okB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                String string = null;
                File file2 = new File(WOpen.this.reportFileTF.getText());
                if (!file2.getName().equals(WOpen.REPORT_FILE_NAME_STRING)) {
                    string = "Report file " + file2.getPath() + "\ndoes not end in " + WOpen.REPORT_FILE_NAME_STRING + ".";
                } else if (file2.isDirectory()) {
                    string = "Directory " + file2.getPath() + "\nis not a valid Report file.";
                } else if (!file2.canRead() && !file2.isAbsolute()) {
                    string = "Report file " + file2.getPath() + "\ncannot be read.  Please select an absolute path.";
                } else if (!file2.canRead()) {
                    string = "Report file " + file2.getPath() + "\ncannot be read.  Please verify that the Report file is valid.";
                } else {
                    try {
                        file2 = file2.getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        string = "Report file " + file2.getPath() + "\ncannot be read: " + iOException;
                    }
                }
                if (string != null) {
                    WError.showError(string, "BEViewer Open error", null);
                    return;
                }
                if (WOpen.this.imagePathPreference == ImagePathPreference.DEFAULT) {
                    file = WOpen.this.defaultImageFileLabel.getPath();
                    if (file == null) {
                        WError.showError("The Image File path could not be obtained from the report.\nThe Image file may have been moved or the Report File may be invalid.\nPlease click on \"select custom path\" to select an Image File path for this Report file.", "BEViewer Open error", null);
                        return;
                    }
                } else if (WOpen.this.imagePathPreference == ImagePathPreference.CUSTOM) {
                    file = new File(WOpen.this.customImageFileTF.getText());
                } else if (WOpen.this.imagePathPreference == ImagePathPreference.NONE) {
                    file = null;
                } else {
                    throw new RuntimeException("Invalid type");
                }
                if (WOpen.this.imagePathPreference != ImagePathPreference.NONE) {
                    if (!file.canRead() && !file.isAbsolute()) {
                        string = "Image file \"" + file.getPath() + "\"\ncannot be read, likely because it is defined with a relative path.\nPlease click on \"Select custom path\" to select or type in an absolute path.";
                    } else if (!file.canRead()) {
                        string = "Image file \"" + file.getPath() + "\"\ncannot be read.";
                    } else {
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            string = "Image file \"" + file.getPath() + "\"\ncannot be read: " + iOException;
                        }
                    }
                    if (string != null) {
                        WError.showError(string, "BEViewer Open error", null);
                        return;
                    }
                }
                File file3 = file2.getParentFile();
                BEViewer.reportsModel.addReport(file3, file);
                TreePath treePath = BEViewer.reportsModel.getTreePath(file3, file);
                BEViewer.reportsPane.scrollToTreePath(treePath);
                BEViewer.reportsModel.getTreeSelectionModel().setSelectionPath(treePath);
                wOpen.setVisible(false);
            }
        });
    }

    static {
        reportFileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().equals(WOpen.REPORT_FILE_NAME_STRING);
            }

            @Override
            public String getDescription() {
                return "Report Files (report.xml)";
            }
        };
    }

    private static final class ImagePathPreference {
        private static final ImagePathPreference DEFAULT = new ImagePathPreference("Default");
        private static final ImagePathPreference CUSTOM = new ImagePathPreference("Custom");
        private static final ImagePathPreference NONE = new ImagePathPreference("None");
        private final String name;

        private ImagePathPreference(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class PathComponent
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private static final String NULL_FILE = "None";
        private File file;
        private boolean isEnabled;

        public PathComponent() {
            this.setText(" ");
            this.setPath(null);
            this.setMinimumSize(new Dimension(0, this.getPreferredSize().height));
        }

        @Override
        public void setEnabled(boolean bl) {
            this.isEnabled = bl;
            this.setPath(this.file);
        }

        public void setPath(File file) {
            this.file = file;
            Font font = this.getFont();
            if (file == null) {
                super.setEnabled(false);
                this.setFont(font.deriveFont(2));
                this.setText(NULL_FILE);
            } else {
                super.setEnabled(this.isEnabled);
                this.setFont(font.deriveFont(0));
                this.setText(file.getPath());
            }
        }

        public File getPath() {
            return this.file;
        }
    }
}

