/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WRawDeviceChooser
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final DefaultListModel listModel = new DefaultListModel();
    private static final FileFilter fileFilter = new RawDeviceFileFilter();
    private static final File DEV_FILE = new File("/dev");
    private static WRawDeviceChooser wRawDeviceChooser;
    private static JList rawDeviceL;
    private static JButton selectB;
    private static JButton cancelB;
    private static JButton refreshB;

    public static String getSelection() {
        return (String)rawDeviceL.getSelectedValue();
    }

    private void refreshList() {
        listModel.clear();
        File[] fileArray = DEV_FILE.listFiles(fileFilter);
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        for (int i = 0; i < fileArray.length; ++i) {
            listModel.addElement(fileArray[i].getAbsolutePath());
        }
        if (fileArray.length == 0) {
            WError.showMessage("There are no devices at /dev/sd*.", "Raw device list read failure");
        }
    }

    public static void openWindow() {
        if (wRawDeviceChooser == null) {
            wRawDeviceChooser = new WRawDeviceChooser();
        }
        wRawDeviceChooser.setLocationRelativeTo(BEViewer.getBEWindow());
        wRawDeviceChooser.refreshList();
        wRawDeviceChooser.setVisible(true);
    }

    private static void closeWindow() {
        if (wRawDeviceChooser != null) {
            wRawDeviceChooser.setVisible(false);
        }
    }

    private WRawDeviceChooser() {
        this.buildInterface();
        this.wireActions();
        this.getRootPane().setDefaultButton(selectB);
        this.pack();
    }

    private void buildInterface() {
        this.setTitle("Select Raw Device");
        this.setModal(true);
        this.setAlwaysOnTop(true);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        container.add((Component)new JLabel("Raw Devices (/dev)"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(rawDeviceL);
        jScrollPane.setPreferredSize(new Dimension(500, 300));
        container.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        container.add(this.buildControls(), gridBagConstraints);
    }

    private Component buildControls() {
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        selectB.setEnabled(false);
        container.add((Component)selectB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        container.add((Component)cancelB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        container.add((Component)new JSeparator(1), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        container.add((Component)refreshB, gridBagConstraints);
        return container;
    }

    private void wireActions() {
        rawDeviceL.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    selectB.setEnabled(rawDeviceL.getSelectedValue() != null);
                }
            }
        });
        selectB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WRawDeviceChooser.this.setVisible(false);
            }
        });
        cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                rawDeviceL.setSelectedValue(null, false);
                WRawDeviceChooser.this.setVisible(false);
            }
        });
        refreshB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                rawDeviceL.setSelectedValue(null, false);
                WRawDeviceChooser.this.refreshList();
            }
        });
    }

    static {
        rawDeviceL = new JList(listModel);
        selectB = new JButton("Select");
        cancelB = new JButton("Cancel");
        refreshB = new JButton("Refresh");
    }

    private static class RawDeviceFileFilter
    implements FileFilter {
        private RawDeviceFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getAbsolutePath().startsWith("/dev/sd");
        }

        public String getDescription() {
            return "Raw Devices (/dev/sd*)";
        }
    }
}

