/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WScanBoxedDebugging {
    public final Component component;
    private final JCheckBox useStartOnPageNumberCB = new JCheckBox("Start on Page Number");
    private final JTextField startOnPageNumberTF = new JTextField();
    private final JCheckBox useDebugNumberCB = new JCheckBox("Use Debug Mode Number");
    private final JTextField debugNumberTF = new JTextField();
    private final JCheckBox useEraseOutputDirectoryCB = new JCheckBox("Erase Output Directory");

    public WScanBoxedDebugging() {
        this.component = this.buildContainer();
        this.wireActions();
    }

    private Component buildContainer() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Debugging Options"));
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        WScan.addOptionalTextLine(jPanel, n++, this.useStartOnPageNumberCB, this.startOnPageNumberTF, 100);
        WScan.addOptionalTextLine(jPanel, n++, this.useDebugNumberCB, this.debugNumberTF, 50);
        WScan.addOptionLine(jPanel, n++, this.useEraseOutputDirectoryCB);
        return jPanel;
    }

    public void setScanSettings(ScanSettings scanSettings) {
        this.useStartOnPageNumberCB.setSelected(scanSettings.useStartOnPageNumber);
        this.startOnPageNumberTF.setEnabled(scanSettings.useStartOnPageNumber);
        this.startOnPageNumberTF.setText(scanSettings.startOnPageNumber);
        this.useDebugNumberCB.setSelected(scanSettings.useDebugNumber);
        this.debugNumberTF.setEnabled(scanSettings.useDebugNumber);
        this.debugNumberTF.setText(scanSettings.debugNumber);
        this.useEraseOutputDirectoryCB.setSelected(scanSettings.useEraseOutputDirectory);
    }

    public void getScanSettings(ScanSettings scanSettings) {
        scanSettings.useStartOnPageNumber = this.useStartOnPageNumberCB.isSelected();
        scanSettings.startOnPageNumber = this.startOnPageNumberTF.getText();
        scanSettings.useDebugNumber = this.useDebugNumberCB.isSelected();
        scanSettings.debugNumber = this.debugNumberTF.getText();
        scanSettings.useEraseOutputDirectory = this.useEraseOutputDirectoryCB.isSelected();
    }

    private void wireActions() {
        GetUIValuesActionListener getUIValuesActionListener = new GetUIValuesActionListener();
        this.useStartOnPageNumberCB.addActionListener(getUIValuesActionListener);
        this.useDebugNumberCB.addActionListener(getUIValuesActionListener);
        this.useEraseOutputDirectoryCB.addActionListener(getUIValuesActionListener);
    }

    private class GetUIValuesActionListener
    implements ActionListener {
        private GetUIValuesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScanSettings scanSettings = new ScanSettings();
            WScanBoxedDebugging.this.getScanSettings(scanSettings);
            WScanBoxedDebugging.this.setScanSettings(scanSettings);
        }
    }
}

